//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCTEXTFIELD_H
#define WSCTEXTFIELD_H

#include <WScom.h>
#include <WSCform.h>
#include <WSDkeyboard.h>
#include <WSCvscrBar.h>

class WSCvmifield;
class WSCvscrBar;

#define WSCtextField_VER  1002

class WSCtextField   :public WSCform{

  protected:
    WSCvmifield* _ifd;
    WSCvscrBar*  _h_scr;
    WSCvscrBar*  _v_scr;
    WSCform*    _form;
    WSCushort _bw;
//    char*     _label_string;
    short     _bar_back_color;
    short     _work_back_color;
    WSCulong _vpos;
    WSCulong _hpos;
    char      _fw;
    char      _fh;
    unsigned  _margin:3;
    unsigned  _enable_input:1;
    unsigned  _font:4;

//    WSMFpropertyDef(WSNlabelString, char*,     _label_string  );
    WSMFpropertyDef(WSNworkBackColor, short,     _work_back_color  );
    WSMFpropertyDef(WSNbarThickness,  WSCushort, _bw   );
    WSMFpropertyDef(WSNbarShadowColor,short,     _bar_back_color   );
    WSMFpropertyDef(WSNmargin,  WSCuchar, _margin);
    WSMFpropertyDef(WSNenableInput,  WSCbool, _enable_input);
    WSMFpropertyDef(WSNvbarValue,  WSCulong, _vpos);
    WSMFpropertyDef(WSNhbarValue,  WSCulong, _hpos);
    WSMFpropertyDef(WSNfont,WSCuchar,_font);

//    virtual void setWorkWSNlabelString(char*);
    WSDLEX32 virtual void setWorkWSNshadowThickness(WSCuchar);
    WSDLEX32 virtual void setWorkWSNforeColor(short);
    WSDLEX32 virtual void setWorkWSNtopShadowColor(short);
    WSDLEX32 virtual void setWorkWSNbottomShadowColor(short);
    WSDLEX32 virtual void setWorkWSNbackColor(short);
    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);

    WSDLEX32 static void _h_scr_work_op(WSCbase*);
    WSDLEX32 static void _ha_scr_work_op(WSCbase*);
    WSDLEX32 static void _v_scr_work_op(WSCbase*);
    WSDLEX32 static void _va_scr_work_op(WSCbase*);

    WSDLEX32 static void _valuech_work(WSCbase*);
    WSDLEX32 static void _keypress_work(WSCbase*);
    WSDLEX32 static void _keyrelease_work(WSCbase*);
    WSDLEX32 static void _keyhook_work(WSCbase*);
    WSDLEX32 static void _scr_mouse_press(WSCbase*);
    WSDLEX32 static void _scr_mouse_release(WSCbase*);
    WSDLEX32 static void _scr_mouse_move(WSCbase*);


//    virtual WSCbool _use_bscrbar_class();

    WSDLEX32 long _get_font_width();
    WSDLEX32 long _get_font_height();
    WSDLEX32 void _scr_adjust();
    WSDLEX32 virtual void _adjust();

  public:
    WSDLEX32 WSCtextField(WSCbase*,char*);
    WSDLEX32 virtual ~WSCtextField();

    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onValueChange();
    WSDLEX32 virtual void onKey(WSDkeyboard*,WSCbool);
    WSDLEX32 virtual void onKeyHook(WSDkeyboard*);
    WSDLEX32 virtual void onScrMousePress(WSCpoint*);
    WSDLEX32 virtual void onScrMouseRelease(WSCpoint*);
    WSDLEX32 virtual void onScrMouseMove(WSCpoint*);
    WSDLEX32 virtual void onMousePress(WSCpoint*);


WSDLEX32 static void setUseScrBarClass(char*);
WSDLEX32 static char* getUseScrBarClass();

    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual WSCbase* getPropertyInheritChild();

    WSDLEX32 WSCbase* getTextFrame();
    WSDLEX32 virtual void update();
    WSDLEX32 virtual char* getDefaultProperty();

    WSDLEX32 void addString(char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 WSCushort* getBuf(); 

    WSDLEX32 void replaceSelectedString(char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 WSCstring getSelectedString();
    WSDLEX32 WSCstring getString();
    WSDLEX32 void deleteSelectedString();
    WSDLEX32 long setSelect(long,long);
    WSDLEX32 long getSelectedPos();

    WSDLEX32 long getLines();
    WSDLEX32 long getTopLine();
    WSDLEX32 long setTopLine(long pos);
    WSDLEX32 long getBottomLine();
    WSDLEX32 long setBottomLine(long pos);

    WSMFguiClassDef(WSCtextField,WSCform);
    WSMFversionDef(WSCtextField);
};
#endif
