//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDMOUSE_H
#define WSDMOUSE_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSClistData.h>

class WSDmouse  :public WSCroot{

  protected:
    WSClistData _mlist;
    WSCulong _target_btn;
    WSCulong _status; 
    WSCbase* _fclient; 
  public:
    WSDLEX32 WSDmouse();

    WSDLEX32 virtual WSCbool getMousePosition(short* x,short* y);
    WSDLEX32 virtual WSCbool getMousePosition(short* x,short* y,WSCbase*);
 
    WSDLEX32 virtual long getMouseStatus()=0;
    WSDLEX32 virtual void setMousePosition(short x, short y);
    WSDLEX32 virtual void setMouseCursor(long);

    WSDLEX32 void  addMouseCursor(long id,long val,char*);
    WSDLEX32 char* getMouseCursorName(long id);
    WSDLEX32 long  getMouseCursorId(long pos);
    WSDLEX32 long  getMouseCursor(long id);
//DEVELOP
    WSDLEX32 virtual void setupMouseCursor(char*);
    WSDLEX32 virtual void initialize();
    WSDLEX32 virtual void resetMouseCursors();
    WSDLEX32 virtual void delMouseCursor(long pos);

    WSDLEX32 WSCulong getStatus();
    WSDLEX32 void setStatus(WSCulong);
    WSDLEX32 WSCulong getTargetBtn();
    WSDLEX32 void setTargetBtn(WSCulong);
    WSDLEX32 void setMouseFocusClient(WSCbase*);
    WSDLEX32 WSCbase* getMouseFocusClient();

    WSDLEX32 static  void setCreateInstanceHandler( WSDmouse* (*hd)() );

    WSMFclassDef(WSDmouse,WSCroot);
};
extern WSDLEX WSDmouse*  WSGIappMouse();
#endif//  WSDMOUSE_H
