//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDMWINDEV_H
#define WSDMWINDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>

class WSDmwindowDev :public WSDdev{

  protected: 
    WSCushort _w;
    WSCushort _h;

  public: 
    WSDLEX32 WSDmwindowDev();
    WSDLEX32 virtual WSCbool getReady();
    WSDLEX32 virtual long beginDraw(short,short,WSCushort,WSCushort,WSCbool absolute = True,WSCbool scaling = True);
    WSDLEX32 virtual long endDraw();
    WSDLEX32 void getGeometry(WSCushort* w,WSCushort* h);

    WSDLEX32 virtual long createPixmap(WSCushort w,WSCushort h) = 0;
    WSDLEX32 virtual long destroyPixmap() = 0;

    WSDLEX32 virtual long copyToWindow(WSDdev*,short x,short y,WSCushort w,WSCushort h,
                              short dx,short dy) = 0;
    WSDLEX32 virtual long copyFromWindow(WSDdev*,short x,short y,WSCushort w,WSCushort h,
                              short dx,short dy) = 0;
    WSDLEX32 virtual long copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,WSDimage*) = 0;
    WSDLEX32 virtual long copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,WSDmwindowDev*) = 0;

    WSDLEX32 virtual long initBuffer() = 0;
    WSDLEX32 virtual long setBufferRGB(WSCushort x,WSCushort y,
                              WSCuchar r,WSCuchar g,WSCuchar b) = 0;
    WSDLEX32 virtual long getBufferRGB(WSCushort x,WSCushort y,
                              WSCuchar* r,WSCuchar* g,WSCuchar* b) = 0;
    WSDLEX32 virtual long putBufferToPixmap() = 0;
    WSDLEX32 WSCuchar* getBuffer();
    WSDLEX32 long setBuffer(WSCuchar*);
    WSDLEX32 virtual long loadFile(char*);
    WSDLEX32 virtual long saveFile(char*,long);

WSDLEX32 static WSDmwindowDev* getNewInstance();
    WSMFclassDef(WSDmwindowDev,WSDdev);
};
#endif //WSDMWINDEV_H
