//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDWINDOWDEV_H
#define WSDWINDOWDEV_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSDdev.h>
#include <WSClistData.h>

class WSDwindowDev :public WSDdev{

 protected:
  WSClistData _event_clients;
  short     _exposed_x;
  short     _exposed_y;
  WSCushort _exposed_w;
  WSCushort _exposed_h;
  short     _pix_draw_x;
  short     _pix_draw_y;
  WSCushort _pix_draw_w;
  WSCushort _pix_draw_h;
  short     _w_x;
  short     _w_y;
  WSCushort _w_w;
  WSCushort _w_h;
  short     _bg_no;
  short     _bp_no;
  short     _diff_x;
  short     _diff_y;
  WSCushort _mouse_no;
  unsigned _expose_sequence:1;
  unsigned _pixmap_created:1;
 private:
  unsigned _event_delivering_sequence:1;
  unsigned _client_deleted:1;
  unsigned _pixmap_style:2;
 protected:
  WSDLEX32 void setExposedArea(short,short,WSCushort,WSCushort);
  WSDLEX32 void setPixmapStyle(char);
  WSDLEX32 virtual long createWindow();
  WSDLEX32 virtual long createPixmap();
  WSDLEX32 virtual long createContext();

  WSDLEX32 virtual long destroyWindow();
public:
  WSDLEX32 virtual long destroyPixmap();
protected:
  WSDLEX32 virtual long destroyContext();

  WSDLEX32 virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
  WSDLEX32 virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
  WSDLEX32 virtual void _clear_area( long x,long y,WSCulong w,WSCulong h);
public:
  WSDLEX32 virtual long exposeArea(long x,long y,WSCulong w,WSCulong h,WSCbool scaling = True);
protected:
  WSDLEX32 virtual long clearArea(long x,long y,WSCulong w,WSCulong h,WSCbool fl,WSCbool scaling = True);
  WSDLEX32 virtual void exposeExecute(short x,short y,WSCushort w,WSCushort h);

  WSDLEX32 void setBackColorNo(short);

 public:
  WSDLEX32 WSDwindowDev();

  WSDLEX32 void getWindowSize(short* x,short* y,WSCushort* w,WSCushort* h);
  WSDLEX32 void onMouseIn(WSCpoint*);
  WSDLEX32 void onMouseOut();
  WSDLEX32 void onMouseMove(WSCpoint*);
  WSDLEX32 void onMousePress(WSCpoint*);
  WSDLEX32 void onMouseDoubleClick(WSCpoint*);
  WSDLEX32 void onMouseRelease(WSCpoint*);
  WSDLEX32 void onResize(WSCrect*);
  WSDLEX32 void onExpose(WSCrect*);
  WSDLEX32 void onUnmap();
  WSDLEX32 void onFocusChange();

  WSDLEX32 char getPixmapStyle();
  WSDLEX32 void     setExposeSequence(WSCbool);
  WSDLEX32 WSCbool  getExposeSequence();

  WSDLEX32 virtual long setEventOrder(WSDdev*,char top_or_bottom);
  WSDLEX32 virtual long setEvent(WSDdev*,WSCbool on_off);
  WSDLEX32 virtual long execEvent(long ev_kind,void* data);
  WSDLEX32 virtual long cancelEvent(WSDdev* dev);

  WSDLEX32 virtual long    initialize();
  WSDLEX32 virtual long    getAvailableEventBit();
  WSDLEX32 virtual WSCbool isAvailableEvent(long ev_kind);
  WSDLEX32 virtual long    setEnableEvent(long ev_kind);
  WSDLEX32 virtual long    setEnableEventBit(long ev_bit);
  WSDLEX32 virtual long    setDisableEvent(long ev_kind);
  WSDLEX32 virtual void    getDispAddr(short*,short*);

  WSDLEX32 virtual long    beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute,WSCbool scaling = True);
  WSDLEX32 virtual long    endDraw();
  WSDLEX32 virtual long    getExposedArea(short* x,short* y,WSCushort* w,WSCushort* h,WSCbool scaling = True);
  WSDLEX32 virtual WSCbool isExposed(short x,short y,WSCushort w,WSCushort h,WSCbool scaling = True);
  WSDLEX32 virtual long  setValue(long kind,void* data);
  WSDLEX32 virtual long  getValue(long kind, void* value);
  WSDLEX32 virtual long  detachClient();
  WSDLEX32 virtual WSCbool getReady();
  WSDLEX32 virtual long copyArea(long,long,WSCulong,WSCulong,long,long);

  WSDLEX32 WSCbool getAbsoluteDraw();
  WSDLEX32 short getBackColorNo();

  WSDLEX32 WSCushort getWidth();
  WSDLEX32 WSCushort getHeight();

  WSDLEX32 virtual long raise();
  WSDLEX32 virtual long lower();

//  static void* setGlobalMouseInHandler( void(*)(WSDdev*) );
//  static void* setGlobalMousePressHandler( void(*)(WSDdev*) );
//  static void* setGlobalMouseReleaseHandler( void(*)(WSDdev*) );
  WSMFclassDef(WSDwindowDev,WSDdev);
};
#define WS_WINDOW_TO_WINDOW  0
#define WS_PIXMAP_TO_WINDOW  1
#endif
