//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCCOLOREDITOR_H
#define WSCCOLOREDITOR_H
#include <WScom.h>
#include <WSDappDev.h>
#include <WSCbaseDialog.h>

#define WSCcolorEditor_VER 1010

class WSCvtoggle;
class WSCoption;
class WSCvline;
class WSCbaseDialog;
class WSCform;
class WSCvbtn;
class WSCvlabel;
class WSCvslider;
class WSCvifield;
class WSCmessageDialog;
class WSDcolor;

class WSCcolorEditor :public WSCbaseDialog {

 protected:
  void* _rep_hd;

  WSMFpropertyDef(WSNreplyHandler,void*,_rep_hd);

  WSCform* clearea1;
  WSCvlabel* cledvlab000;
  WSCvslider* cledvsli001;
  WSCvifield* cledvifi001;
  WSCvifield* cledvifi002;
  WSCvifield* cledvifi003;
  WSCvslider* cledvsli002;
  WSCvslider* cledvsli003;
  WSCvslider* cledvsli004;
  WSCvifield* cledvifi004;
  WSCvifield* cledvlab001;
  WSCvlabel* cledvlab003;

  void _property_initialize();
  void _property_delete();

  void _set_color_name(char*);
  static WSDcolor* color;
  long  _slider_not_move;

  static void cl_set(WSCbase*);
  static void cl_end(WSCbase*);
  static void cl_drop(WSCbase*);
  static void cl_chop(WSCbase*);
  static void cl_if_set0(WSCbase*);
  static void cl_if_set1(WSCbase*);
  static void cl_if_set2(WSCbase*);
  static void cl_if_set3(WSCbase*);
  static void cl_ifname_set(WSCbase*);

  virtual void onActivate();

 public:
  WSCcolorEditor(WSCbase* base,char* name);
  virtual ~WSCcolorEditor();
  virtual long initialize();
  virtual void adjustForm();
  virtual void onGuiPolicyChange(long);

  char* getColorName();
  void  setColorName(char*);

  WSMFguiClassDef(WSCcolorEditor,WSCbaseDialog);
  WSMFversionDef(WSCcolorEditor);
};
extern WSDLEX WSCcolorEditor* WSGIappColorEditor();
#endif
