//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCCOLORSELECT_H
#define WSCCOLORSELECT_H

#include <WScom.h>
#include <WSCbaseDialog.h>

class WSCscrForm;
class WSCvbtn;
class WSCform;
class WSCvlabel;
class WSCoption;
class WSCbaseDialog;
class WSCvtoggle;
class WSCvifield;
class WSCmessageDialog;
class WSCindexForm;

class WSCcolorSelect            :public WSCbaseDialog {
   
  protected:
    void* _work_proc;
//    WSClistData _label_list;
    WSCform*  _area;
    WSCvbtn*     _set_btn;
    WSCscrForm*  _scr_area;
    WSCscrForm*  _scr_area0;
    WSCscrForm*  _scr_area2;
    WSCvlabel*   _color_show;
    WSCvlabel*   _color_name;
    WSClistData  _user_colors;
    WSClistData  _user_label_list;
    WSCmessageDialog* _message;
    WSCbool       _init;
    WSCindexForm* _index_area;

    WSMFpropertyDef( WSNreplyHandler, void*,      _work_proc ); 

//    short          _table_no;
    void updateList();

    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);

static void _set_btn_work(WSCbase*);
static void _label_push_work(WSCbase*);

virtual void onVisibleChange(WSCbool);
virtual void onParentVisibleChange(WSCbool);
virtual void onResize(WSCrect*);
virtual void onActivate();
    void _adjust();

    static WSCeventProc evprocs[];   
    static void _btn1_work(WSCbase*); 
    static void _btn2_work(WSCbase*);
    static void _btn3_work(WSCbase*);


    void _setup_area1(WSCbase*);
    void _setup_dbtn(WSCbase*,long,char*,char*,char*);

  public:
    WSCcolorSelect(WSCbase*,char*);
    virtual ~WSCcolorSelect();

    virtual  long initialize();
    virtual  void onGuiPolicyChange(long);

    char*    getSelectColor();
    char*    getSelectTopShadowColor();
    char*    getSelectBottomShadowColor();

    void addColorEntry(char*);
    long delColorEntry(char*);
    void updateColorEntry();
    void clearColorEntry();

    long save(char*);
    long load(char*);

    WSMFguiClassDef(WSCcolorSelect,WSCbaseDialog);
};
extern WSDLEX WSCcolorSelect* WSGIappColorSelect();

#endif //WSCCOLORSELECT_H
