//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCWINDOWEDITOR_H
#define WSCWINDOWEDITOR_H

#include <WScom.h>
#include <WSCform.h>

class WSCscrForm;
class WSCvbtn;
class WSCvlabel;
class WSCform;
class WSCvlabel;
class WSCoption;
class WSCvifield;
class WSCcolorSelect;
class WSCmessageDialog;
class WSCbaseDialog;
class WSCfileSelect;
class WSCvtoggle;
class WSClist;
class WSCclassPropEditor;
class WSCclassUTrgEditor;
class WSCtriggerEditor;
class WSCclassRMethodEditor;

#define WSCwindowEditor_VER 1000

class WSCwindowEditor :public WSCscrForm{

  protected:
    void* _voidp_client;
    WSCbase*     _client;

    WSCvtoggle*  _tgb1;
    WSCvtoggle*  _tgb2;
    WSCvtoggle*  _tgb3;
    WSCmessageDialog* _msg;
    WSCvtoggle*  _pstg1;
    WSCvtoggle*  _pstg2;
    WSCvtoggle*  _pstg3;
    WSCvbtn*     _psbt1;
    WSCvbtn*     _psbt2;
    WSCvbtn*     _psbt3;
    WSCvbtn*     _psbt4;
    WSCvbtn*     _bt1;
    WSCvlabel*  _cname;
    WSCvlabel*   pslb6;
    WSCvifield*  _class_icon;
    WSCvifield*  _class_cmmt;
    WSCvifield*  _class_base;
    WSCvifield*  _inst_name;
    WSCvifield*  _file_name;
    WSCclassPropEditor* _cpe;
    WSCclassUTrgEditor* _cute;
    WSCtriggerEditor* _cte;
    WSCvtoggle*  _vartg;
    WSCvtoggle*  _prjtg;
    WSCvtoggle*  _rctg;
    WSCvbtn*  _fbt1;
    WSCclassRMethodEditor* _crme;

    unsigned _editable:1;
    WSMFpropertyDef( WSNclient,  void*,          _voidp_client ); 

    static void _prjtg_work(WSCbase*);
    static void _vartg_work(WSCbase*);
    static void _stg1_work(WSCbase*);
    static void _psbt1_work(WSCbase*);
    static void _psbt2_work(WSCbase*);
    static void _psbt3_work(WSCbase*);
    static void _psbt4_work(WSCbase*);
    static void _vifi_work(WSCbase*);
    static void _fbtn_work(WSCbase*);
    static void _rctg_work(WSCbase*);

    virtual void onActivate();
    virtual void onVisibleChange(WSCbool);
    virtual void onParentVisibleChange(WSCbool);


    void _adjust();
    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);

  public:
    WSCwindowEditor(WSCbase*,char*);
    virtual ~WSCwindowEditor();

    virtual  long initialize();
//    virtual  long execEventProc(long,void*);
    virtual void onGuiPolicyChange(long);

    void setEditClient(WSCbase*);
    WSCbase* getEditClient();

    void setEditable(WSCbool);
    WSCbool getEditable();

    WSMFguiClassDef(WSCwindowEditor,WSCscrForm);
    WSMFversionDef(WSCwindowEditor);

};
#endif
