//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDBTRONWINDEV_H
#define WSDBTRONWINDEV_H

#include <basic.h>
#include <WSDmwindowDev.h>

class WSDbtronmwinDev   :public WSDmwindowDev{
 protected:
  W         _mem_gid;
  UB*       _mem_gid_buf;
  WSCushort* _buf;
  char      _bit;
  long _copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,W mask_gid);
 public:
  WSDbtronmwinDev();
  virtual ~WSDbtronmwinDev();

  virtual long createPixmap(WSCushort w,WSCushort h);
  virtual long destroyPixmap();
  long createContext();
  long destroyContext();

  virtual long copyToWindow(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short);
  virtual long copyFromWindow(WSDdev*,short,short,WSCushort,WSCushort,
                                    short,short);
  virtual long copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,WSDimage*);
  virtual long copyToWindowWithMask(WSDdev*,short x,short y,
                                WSCushort w,WSCushort h,
                                short dx,short dy,WSDmwindowDev*);

  virtual long getWindowResource();
  virtual long getDeviceResource();
  virtual long getSpecialResource();
  virtual long getContextResource();

  virtual long initBuffer();
  virtual long setBufferRGB(WSCushort x,WSCushort y,
                            WSCuchar r,WSCuchar g,WSCuchar b);
  virtual long getBufferRGB(WSCushort x,WSCushort y,
                            WSCuchar* r,WSCuchar* g,WSCuchar* b);
  virtual long putBufferToPixmap();

  WSMFclassDef(WSDbtronmwinDev,WSDmwindowDev);
};
#endif
