#ifndef WSDDEVICEFONT_H
#define WSDDEVICEFONT_H

#include <stdio.h>
#include <WScom.h>
#include <WSCstring.h>

#define WS_FONT_BITMAP 0

#define WS_FONT_TYPE_BDF 1
#define WS_FONT_TYPE_PCF 2
#define WS_FONT_TYPE_TTF 3

#define WS_FONT_COUNT      23
#define WS_FONT_NONE        0
#define WS_FONT_ISO8859(n) (n) /* 1 - 15 */
#define WS_FONT_UNICODE    16
#define WS_FONT_KOI8R      17
#define WS_FONT_JIS0201    18
#define WS_FONT_JIS0208    19
#define WS_FONT_KSC5601    20
#define WS_FONT_GB2312     21
#define WS_FONT_BIG5       22

struct WSDdeviceFontGryph{
  unsigned char* _data;
  int _char_code;
  unsigned char _width;
  char _left_bearing;
  char _right_bearing;
  char _ascent;
  char _descent;

  WSDdeviceFontGryph();
  virtual ~WSDdeviceFontGryph();

  virtual int destroy();
};

struct WSDdeviceFont{
  WSCstring _font_name;
  int _type;
  int _height;
  int _width;
  int _ascent;
  int _descent;
  int _chars;
  int _default_char_code;
  WSDdeviceFontGryph* _font_gryph;
  int _font_encode;
  unsigned char* _gryph_buf;

  WSDdeviceFont();
  virtual ~WSDdeviceFont();
  virtual int destroy();
  virtual int getStringWidth(WSCushort* str,int len,int* w);
  virtual WSDdeviceFontGryph* getFontGryph(WSCushort str);
  virtual WSDdeviceFontGryph* _get_font_gryph(WSCushort str,int pos,int snum,int lnum);
};

struct WSDdeviceFontList{
  int _font_order[WS_FONT_COUNT];
  WSClistData _list;
  WSDdeviceFontList();
  virtual ~WSDdeviceFontList();
  int destroy();
  WSDdeviceFontGryph* getFontGryph(unsigned int code);
  int addFont(WSDdeviceFont*);
  int* getFontOrder();
  WSDdeviceFont* getFont(int fenc);
  int getFontHeight();
  int getStringWidth(WSCushort* str,int len,int* w);
};

extern WSDdeviceFont* WSGFdeviceReadFont(char* file_name,char* fontname,int type,int fenc);
extern WSDdeviceFontList* WSGFdeviceOpenFont(char* fname,char* path);

#endif
