//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#ifndef DEVFB_DEP_H
#define DEVFB_DEP_H

class  WSDdeviceFontList;
class  WSClistData;

typedef struct _graphics_context {
  short _gid;
  unsigned char _lw;
  unsigned char _ld_type;
  unsigned int _fg_color;
  unsigned int _bg_color;
  short _x;
  short _y;
  unsigned short _w;
  unsigned short _h;
  unsigned char* _buf;
  unsigned int _row_bytes;
  unsigned int _hatch_type;
  int _window_id;
  unsigned char _depth;
  unsigned char _start_red;
  unsigned char _start_green;
  unsigned char _start_blue;
  unsigned char _red_bits;
  unsigned char _green_bits;
  unsigned char _blue_bits;
  short _draw_pt_x;
  short _draw_pt_y;
  WSDdeviceFontList*  _font;
  WSClistData* _ex_region_list;
  WSClistData* _visible_region_list;
} WSDdeviceGC;

typedef struct _window_context {
  short _x;
  short _y;
  unsigned short _w;
  unsigned short _h;
  unsigned int _attr;
  unsigned int _bg_color;
  void* _user_data;
  unsigned short* _title_string;
  short _window_id;
  short _parent_window_id;
  short _stack_no;
  long _status;
  int _pid;
  int _gc;
} WSDdeviceWindow;


typedef struct _event_list {
  WSDdeviceEvent _event;
  struct _event_list* _next;
} WSDdeviceEventList;

#include <devfb/WSDdeviceFont.h>

#define WS_MAX_WINDOW    64
#define WS_MAX_GC       256
#define WS_MAX_POINTS   256

#define WS_MAX_WINDOW_AREA (sizeof(WSDdeviceWindow)*WS_MAX_WINDOW)
#define WS_MAX_GC_AREA     (sizeof(WSDdeviceGC)*WS_MAX_GC)
#define WS_MAX_CONTEXT_AREA (WS_MAX_WINDOW_AREA + WS_MAX_GC_AREA)

#define WS_DEVICE_NEED_EXPOSE 1

extern int WSGFdeviceFrameBufferInitialize();
extern int WSGFdeviceGetNewWindow(unsigned int attr,unsigned int parent,short x,short y,unsigned short w, unsigned short h,unsigned int bg);
extern int WSGFdeviceDestroyWindow(int wid);
extern int WSGFdeviceMoveWindow(int wid,short x,short y);
extern int WSGFdeviceResizeWindow(int wid,unsigned short w,unsigned short h);
extern int WSGFdeviceGetWindowPosition(int wid,short* x, short* y);
extern int WSGFdeviceGetWindowSize(int wid,unsigned short* w, unsigned short* h);
extern int WSGFdeviceGetWindowStatus(int wid,unsigned int* status);
extern int WSGFdeviceSetWindowStatus(int wid,unsigned int status);
extern int WSGFdeviceSetWindowTitle(int wid,unsigned short* code);
extern int WSGFdeviceSetWindowColor(int wid,unsigned int color);
extern int WSGFdeviceGetActiveWindow(int* wid);
extern int WSGFdeviceGetWindowOwner(int wid,int* pid);
extern int WSGFdeviceSetWindowData(int wid,void*);
extern int WSGFdeviceGetWindowData(int wid,void**);
extern int WSGFdeviceGetNextEvent(WSDdeviceEvent* evt,unsigned int mode);

extern int WSGFdeviceGetNewGC(short x,short y,
                       unsigned short w, unsigned short h,
                       unsigned int depth, unsigned short row_bytes,
                       unsigned char* buf,
                       unsigned int start_red,
                       unsigned int start_green,
                       unsigned int start_blue,
                       unsigned int red_bits,
                       unsigned int green_bits,
                       unsigned int blue_bits);
extern int WSGFdeviceDestroyGC(int gid);

extern int WSGFdeviceDrawLine(int gid,short x1,short y1,short x2,short y2,
                              unsigned int fg,int lw,int type);

extern int WSGFdeviceDrawRect(int gid,short x,short y,
                              unsigned short w, unsigned short h,
                              unsigned int fg,int lw,int type);

extern int WSGFdeviceDrawPolygon(int gid,WSCpoint* point,int num,
                              unsigned int fg,int lw,int type);

extern int WSGFdeviceDrawFillPolygon(int gid,WSCpoint* point,int num,
                              unsigned int bg,int rev);

extern int WSGFdeviceDrawArc(int gid,short x,short y,
                              unsigned short w,unsigned short h,
                              int a1,int a2, 
                              unsigned int bg,int lw,int type);

extern int WSGFdeviceDrawFillArc(int gid,short x,short y,
                              unsigned short w,unsigned short h,
                              int a1,int a2, int arctype,
                              unsigned int bg);


extern int WSGFdeviceDrawFillRect(int gid,short x,short y,
                              unsigned short w, unsigned short h,
                              unsigned int bg,int htype);

extern int WSGFdeviceDrawString(int gid,short x,short y,
                              WSDdeviceFontList* fl,
                              unsigned int fg,WSCushort* string,int len);
extern int WSGFdeviceGetStringWidth(int gid,
                              WSDdeviceFontList* fl,
                              WSCushort* string,int len);

extern int WSGFdeviceGetWindowGC(int wid);
extern int WSGFdeviceGetGCWindow(int gid);
extern int WSGFdeviceFlushGC(int gid);
extern int WSGFdeviceGetDevSpec(int gid,DEV_SPEC* dspec);
extern int WSGFdeviceGetColorSpec(int gid,CSPEC* cspec);
extern int WSGFdeviceBitBuild(int sgid,short x,short y,
                              unsigned short w, unsigned short h,
                              int dgid, short dx,short dy,
                              unsigned int mode);
extern int WSGFdeviceStretchedBitBuild(int sgid,short x,short y,
                              unsigned short w, unsigned short h,
                              int dgid, short dx,short dy,
                              unsigned short w, unsigned short h,
                              unsigned int mode);

extern int WSGFdeviceDestroyVisibleRegion(int gid);
extern int WSGFdeviceDestroyExclusiveRegion(int gid);
extern int WSGFdeviceAddVisibleRegion(int gid,short,short,unsigned short,unsigned short);
extern int WSGFdeviceAddExclusiveRegion(int gid,short,short,unsigned short,unsigned short);
extern WSClistData* WSGFdeviceGetVisibleRegion(int gid);
extern WSClistData* WSGFdeviceGetExclusiveRegion(int gid);

extern int WSGFdeviceSetDrawPoint(int gid,short x,short y);
extern int WSGFdeviceGetDrawPoint(int gid,short* x,short* y);
extern int WSGFdeviceSetFont(int gid,WSDdeviceFontList* font);
extern int WSGFdeviceGetFont(int gid,WSDdeviceFontList** font);
extern int WSGFdeviceSetForeColor(int gid,unsigned int col);
extern int WSGFdeviceGetForeColor(int gid,unsigned int* col);
extern int WSGFdeviceSetBackColor(int gid,unsigned int col);
extern int WSGFdeviceGetBackColor(int gid,unsigned int* col);
extern int WSGFdeviceGetScreenSize(int* w,int* h);
extern int WSGFdeviceSearchWindow(short x,short y);
extern int WSGFdeviceGetGCPos(int gid,short* x,short* y);
extern int WSGFdeviceGetCursorPos(short* x,short* y);
extern int WSGFdeviceGetCursorPos();
extern int WSGFdeviceGetWindowList(int* list,int num);

extern int WSGFdeviceSemCreate(int cnt,unsigned int opt);
extern int WSGFdeviceSemLock(int id);
extern int WSGFdeviceSemUnlock(int id);
extern int WSGFdeviceSemDestroy(int id);

extern int WSGFdeviceSleep(int time);
extern int WSGFdeviceCreateThread(int* thr,void(*proc)(int),int arg);
extern int WSGFdeviceExitThread();
extern int WSGFdeviceTerminateThread(int id);
extern int WSGFdeviceGetThreadId();
extern int WSGFdeviceSendMessage(MESSAGE*);
extern int WSGFdeviceSendDelayMessage(MESSAGE*,int,int*);
extern int WSGFdeviceRecvMessage(int type,MESSAGE*,int size);
extern int WSGFdeviceCheckEventAvailable();

#define DEFAULT_DEVICE_WIDTH   240
#define DEFAULT_DEVICE_HEIGHT  320
//#define DEFAULT_DEVICE_WIDTH   480
//#define DEFAULT_DEVICE_HEIGHT  640

//#define DEFAULT_DEVICE_WIDTH   320
//#define DEFAULT_DEVICE_HEIGHT  240

#define DEFAULT_DEVICE_DEPTH    32
#define DEFAULT_DEVICE_RED_SHIFT   16
#define DEFAULT_DEVICE_GREEN_SHIFT  8
#define DEFAULT_DEVICE_BLUE_SHIFT   0
#define DEFAULT_DEVICE_RED_BIT    8
#define DEFAULT_DEVICE_GREEN_BIT  8
#define DEFAULT_DEVICE_BLUE_BIT   8

#define DEFAULT_LINUX_FRAME_BUFFER_DEVICE   "/dev/fb0"
#define DEFAULT_LINUX_KEYB_DEVICE   "/dev/input/event0"
#define DEFAULT_LINUX_MOUSE_DEVICE  "/dev/input/event1"

#define DEFAULT_FONT_DEFINITION  "wsfonts"

#endif
