//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDDFBAPPDEV_H
#define WSDDFBAPPDEV_H

#include <WSDappDev.h>
#include <directfb.h>

#define F_MEMGID

class WSDdfbFormDev;

class WSDdfbAppDev               :public WSDappDev {

  private:
  protected:
    IDirectFB*              _app_context;
    IDirectFBDisplayLayer*  _layer;
    DFBCardCapabilities     _caps;
    DFBDisplayLayerConfig   _layer_config;
    IDirectFBEventBuffer*   _ev_buffer;
    int _display_w;
    int _display_h;
    void* _color_map;
    WSCbool _have_color_map;
  public:
     WSDdfbAppDev();
     virtual ~WSDdfbAppDev();

     virtual void update();

     IDirectFB* getAppContext();
     IDirectFBDisplayLayer* getDisplayLayer();
     void attachEventBuffer(IDirectFBWindow* win);

     long setInitPrm(int, char**);
virtual long handleEvents();
virtual long dispatchEvent();
virtual long processEvent();
        long _dispatchEvent(WSCbool wait);
virtual long initialize();


virtual long     getDeviceResource();
virtual long     getWindowResource();
virtual long     getContextResource();
virtual long     getSpecialResource();

virtual WSCushort getWidth();
virtual WSCushort getHeight();

    virtual long loadGuiPolicy();
    virtual long saveGuiPolicy();

    WSCbool haveColorMap();
    void* getActiveWindow();

    WSCbool getMouseGrabbed();
    void setGrabTarget(WSDdfbFormDev*);
    void setBtnPressGrabTarget(WSDdfbFormDev*);
    WSDdfbFormDev* getGrabTarget();
    WSDdfbFormDev* getBtnPressGrabTarget();
//----------------------------------------------//
     WSMFclassDef(WSDdfbAppDev,WSDappDev);
};
extern WSDdfbAppDev* WSGIdfbAppDev();

extern void WSGFsetRect(WSCrect*,short,short,WSCushort,WSCushort);

#define DFBCHECK(x...) \
     {                                                                \
          DFBResult err = x;                                                \
          if (err != DFB_OK) {                                        \
               fprintf( stderr, "%s <%d>:\n\t", __FILE__, __LINE__ ); \
               DirectFBErrorFatal( #x, err );                         \
          }                                                           \
     }



#endif
