//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDDFBFORMDEV_H
#define WSDDFBFORMDEV_H

#include <WSDwindowDev.h>
#include <dfb/WSDdfbAppDev.h>

#define N_VIEWR     64

class WSDdfbFormDev               :public WSDwindowDev {
  private:
  protected:
   WSClistData _child_dev_list;
   IDirectFBWindow*       _window;
   IDirectFBSurface*      _context;
   IDirectFBSurface*      _mem_context;

   short       _bg;
   short       _bg_pix;

    long       _click_time;
    WSCushort _mno;
    WSCbool _added_to_child_dev_list;
    WSCrectList* _clip_fore_list;
    long    _clip_num;
static WSCbool _expose_sequence;
static WSClistData _geometry_update_list;
static WSClistData _update_list;
static WSClistData _expose_list;
static short _global_region_x;
static short _global_region_y;
static WSCushort _global_region_w;
static WSCushort _global_region_h;

static short _exposed_global_region_x;
static short _exposed_global_region_y;
static WSCushort _exposed_global_region_w;
static WSCushort _exposed_global_region_h;

  public:
virtual long createWindow();
virtual long createPixmap(); //call for Expose only...
virtual long createContext();
virtual long destroyWindow();
virtual long destroyPixmap();
virtual long destroyContext();
virtual WSCbool getParentVisible();
    WSCrectList* getClipList();
    void   clearClipList();
    void   setClipNum(long num);

virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
virtual void _clear_area( long x,long y,WSCulong w,WSCulong h);

    WSDdfbFormDev();
    virtual ~WSDdfbFormDev();
    virtual long setVisible(WSCbool fl);
    virtual long setValue(long kind,void*);
    virtual long getDeviceResource();
    virtual long getWindowResource();
    virtual long getContextResource();
    virtual long getSpecialResource();
    virtual WSDdev* getEventParentDev();

    void _evh_expose(WSCrect* );
    void _evh_expose_abs(WSCrect* );
    void _expose_ex(WSCrect*);
    void _expose_ex_abs(WSCrect*);
    void _evh_btn_press(int x,int y,DFBWindowEvent*);
    void _evh_btn_release(int x,int y,DFBWindowEvent*);
    void _evh_mouse_move(int x,int y,DFBWindowEvent*);
    void _evh_mouse_out();
    void _evh_mouse_in(short x,short y);
    void _evh_resize(WSCrect*);
    void _evh_destroy(void* ev);

    IDirectFBWindow*  getWindow();
    IDirectFBSurface*  getContext();
    IDirectFBSurface*  getMemContext();
    IDirectFBWindow*  getParentWindow();
    IDirectFBSurface*  getParentContext();
    IDirectFBSurface*  getParentMemContext();
    WSCbool getUseMemContext();

    WSDdfbFormDev* getParentAreaDev();
    WSDdfbFormDev* getMostParentAreaDev();
    void addChildDevList(WSDdfbFormDev*);
    void delChildDevList(WSDdfbFormDev*);
    void setChildDevListFlag(WSCbool);
    WSCbool getChildDevListFlag();

    virtual long raise();
    virtual long lower();
    static WSCbool isValidInstance(WSDdfbFormDev*);

    virtual void getAbstSize(short*,short*,WSCushort*,WSCushort*);
    virtual void getAbstPos(short*,short*);
    virtual WSCbool haveWindow();
    WSClistData getChildDevList();

    void setDefaultRegion();
    void redrawAll();

    WSDdfbFormDev* getChildWithPoint(short x,short y);
    static WSDdfbFormDev* getMouseGrabedDev(); 
    static void setMouseGrabedDev(WSDdfbFormDev* dev); 
    virtual void drawBackGround(long x,long y,WSCulong w,WSCulong h);
    virtual void exposeExecute(short x,short y,WSCushort w,WSCushort h);
    virtual void recursiveExposeExecute(short x,short y,WSCushort w,WSCushort h);
    virtual long exposeArea(long x,long y,WSCulong w,WSCulong h,WSCbool scaling = True);    
    void addUpdateList();
    void addGeometryUpdateList();
static void executeUpdate();
static void setGlobalRegion(short x,short y,WSCushort,WSCushort);
static void getGlobalRegion(short* x,short* y,WSCushort*,WSCushort*);

    virtual void getParentAbstPos(short*,short*);

  WSMFclassDef(WSDdfbFormDev,WSDwindowDev);
};
#endif
 
