//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.


#ifndef WSDWINAPPDEV_H
#define WSDWINAPPDEV_H

#include <windows.h>
#include <WSDappDev.h>
class WSDwinformDev;

class WSDwinAppDev  :public WSDappDev{

 protected:
  HINSTANCE _hinst;
  LPSTR  _lpCmdLine;
  HWND   _hwnd;
  MSG    _msg;
  WSDwinformDev* _mfocus_dev;
  WSClistData _update_dev_list;
  HPALETTE _palette;
  HWND _grabed_wnd;
  void* _wnd_proc;
 public:
  WSDLEX32 WSDwinAppDev();
  WSDLEX32 virtual ~WSDwinAppDev();

  WSDLEX32 virtual void update();

  WSDLEX32 long setInitPrm(LPSTR);
  WSDLEX32 long setWnd(HWND);
  WSDLEX32 long handleEvents();

  WSDLEX32 virtual long dispatchEvent();
  WSDLEX32 virtual long processEvent();
          WSDLEX32 long _dispatchEvent(WSCbool wait);
  WSDLEX32 virtual long initialize();

  WSDLEX32 void setInstanceHandle(HINSTANCE);
  WSDLEX32 HINSTANCE getInstanceHandle();
  WSDLEX32 HWND getHWND();
  WSDLEX32 HWND getEventWnd();
  static HWND   _event_wnd;

  WSDLEX32 virtual long getDeviceResource();
  WSDLEX32 virtual long getWindowResource();
  WSDLEX32 virtual long getContextResource();
  WSDLEX32 virtual long getSpecialResource();

  WSDLEX32 virtual WSCushort getWidth();
  WSDLEX32 virtual WSCushort getHeight();

  WSDLEX32 virtual long loadGuiPolicy();
  WSDLEX32 virtual long saveGuiPolicy();

  WSDLEX32 WSDwinformDev* getMouseFocusDev();
  WSDLEX32 void    setMouseFocusDev(WSDwinformDev*);
  WSDLEX32 void addUpdateDev(WSDwinformDev*);
  WSDLEX32 void delUpdateDev(WSDwinformDev*);
  WSDLEX32 void setGrabedWnd(HWND wnd);
  WSDLEX32 HWND getGrabedWnd();
  WSDLEX32 HPALETTE getPalette();
  WSDLEX32 long setInitPrm(int iprm,char** cprm);
  WSDLEX32 long setWndProc(void*);
  WSDLEX32 void* getWndProc();
  WSMFclassDef(WSDwinAppDev,WSDappDev);
};

extern WSDwinAppDev* WSGIwinAppDev();

#endif
