//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCPULLDOWNMENU_H
#define WSCPULLDOWNMENU_H

#include <WScom.h>
#include <WSCvlabel.h>
#include <WSDkeyboard.h>
class WSCpulldownMenuPopup;

#define WSCpulldownMenu_VER  1030

class WSCpulldownMenu  :public WSCvlabel{

  protected:
    WSCpulldownMenuPopup* _menu;
    short     _mouse_x;
    short     _mouse_y;
    char*     _menu_str;
    char*     _sc_str;
    char*     _ld_name;
    char*     _rd_name;
    unsigned  _press_state:1;
    unsigned  _grabed:1;
    unsigned  _mouse_no_check:1;


    WSMFpropertyDef(WSNleftward,  char*, _ld_name);
    WSMFpropertyDef(WSNrightward, char*, _rd_name);
    WSMFpropertyDef( WSNshortcut,  char*,  _sc_str); 
    WSMFpropertyDef( WSNmenuItems,  char*,  _menu_str); 
    //menu string= string:op name:shortcut key:value,
    //             string:op name:shortcut key:value,
    //             string:{
    //               string:op name:shortcut key:value,
    //               string:op name:shortcut key:value,
    //             },...

    WSDLEX32 virtual void setWorkWSNemboss(WSCbool);
    WSDLEX32 virtual void setWorkWSNshadowThickness(WSCuchar);

    WSDLEX32 virtual long _device_initialize();
    WSDLEX32 void _menu_popup(WSCpoint*);
    WSDLEX32 void _menu_popdown();
    WSDLEX32 void _menu_update();

    WSDLEX32 static WSCpulldownMenu* _ptarget;
    WSDLEX32 static void _key_handler(void*,WSDkeyboard*,WSCbool);
    WSDLEX32 WSCstring _get_proc_name_by_sc(char*,char*);
WSDLEX32 static void      (*_ext_draw_proc)(void*);
WSDLEX32 static WSCstring _policy_name;

  public:
    WSDLEX32 WSCpulldownMenu(WSCbase*,char*);
    WSDLEX32 virtual ~WSCpulldownMenu();

    WSDLEX32 virtual void onMousePress(WSCpoint*);
    WSDLEX32 virtual void onMouseRelease(WSCpoint*);
    WSDLEX32 virtual void onMouseMove(WSCpoint*);
    WSDLEX32 virtual void onVisibleChange(WSCbool fl);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool fl);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onGuiPolicyChange(long);

    WSDLEX32 virtual long execEventProc(long ev,void*);
    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual long addProcedure(WSCprocedure*);

    WSDLEX32 long setItemSensitive(short no,WSCbool flag);
    WSDLEX32 long setValueSensitive(short id,WSCbool flag);

    WSDLEX32 WSCbool* getItemSensitive();

    WSDLEX32 long getValue();
    WSDLEX32 long getItems();

    WSDLEX32 long beginCascade(char* lb);
    WSDLEX32 long addItem(char* lb,char* op,char* shortc,long id);
    WSDLEX32 long endCascade();

    WSMFguiClassDef(WSCpulldownMenu,WSCvlabel);
    WSMFversionDef(WSCpulldownMenu);
};

struct WSCpulldownMenu_draw_struct{
  WSCpulldownMenu* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  long blinking;
  long blink_fore;
  long shadow_type;
  long blink_type;
  long twin_blink;
  short fore_color;
  short back_color;
  short blink_color;
  short back_blink_color;
  short top_shadow_color;
  short bottom_shadow_color;
  WSCstring label_string;
//--
  WSCstring short_cut;
//--
  short label_pixmap;
  short blink_pixmap;
  short press_state;
  long  orientation;
  long  gradation;
  long  gradation_margin;
  long  margin_left;
  long  margin_right;
  long  margin_top;
  long  margin_bottom;
  WSCbool  emboss;
  WSCuchar font;
  WSCbool  reverse_flag;
};


#endif
