//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCSCRFORM_H
#define WSCSCRFORM_H

#include <WScom.h>
#include <WSCform.h>

class WSCscrFrame;
class WSCvscrBar;

#define WSCscrForm_VER  1001

class WSCscrForm   :public WSCform{

  protected:
    WSCscrFrame* _scr_area;
    WSCvscrBar*  _h_scr;
    WSCvscrBar*  _v_scr;
    WSCushort    _scr_area_w;
    WSCushort    _scr_area_h;

    WSCushort _v_scr_slider_sz;
    WSCushort _h_scr_slider_sz;
    WSCushort _v_scr_max_sz;
    WSCushort _h_scr_max_sz;

    short     _v_scr_x_bk;
    short     _h_scr_y_bk;
    WSCushort _v_scr_w_bk;
    WSCushort _v_scr_h_bk;
    WSCushort _h_scr_w_bk;
    WSCushort _h_scr_h_bk;

    WSCushort _work_width;
    WSCushort _work_height;
    WSCushort _wx_pos;
    WSCushort _wy_pos;
    WSCushort _increment;
    WSCushort _page_increment;
    WSCushort _scroll_width;
    WSCushort _scroll_height;
    WSCushort _bar_thick;
    short     _bar_back_color;
    short     _work_back_color;
    short     _scr_offset_x;
    short     _scr_offset_y;
    unsigned  _marginw:3;
    unsigned  _padding:5;
    unsigned  _hbar_visible:1;
    unsigned  _vbar_visible:1;
    unsigned  _virtual_scr:1;
    unsigned  _frame:1;
    unsigned  _no_scroll:1;
    unsigned  _update_work_area:1;

    WSDLEX32 static short _btn_x;
    WSDLEX32 static short _btn_y;
    WSDLEX32 static short _btn_x_pressed;
    WSDLEX32 static short _btn_y_pressed;
    WSDLEX32 static WSCushort _value_pressed;

    WSMFpropertyDef(WSNworkWidth,     WSCushort, _work_width  );
    WSMFpropertyDef(WSNworkHeight,    WSCushort, _work_height );
    WSMFpropertyDef(WSNhbarValue,     WSCushort, _wx_pos      );
    WSMFpropertyDef(WSNvbarValue,     WSCushort, _wy_pos      );
    WSMFpropertyDef(WSNincrement,     WSCushort, _increment   );
    WSMFpropertyDef(WSNpageIncrement, WSCushort, _page_increment );
    WSMFpropertyDef(WSNworkBackColor, short,     _work_back_color  );
    WSMFpropertyDef(WSNbarThickness,  WSCushort, _bar_thick   );
    WSMFpropertyDef(WSNbarShadowColor,short,     _bar_back_color   );
    WSMFpropertyDef(WSNhbarVisible,   WSCbool,   _hbar_visible);
    WSMFpropertyDef(WSNvbarVisible,   WSCbool,   _vbar_visible);
    WSMFpropertyDef(WSNscrollWidth,   WSCushort, _scroll_width );
    WSMFpropertyDef(WSNscrollHeight,  WSCushort, _scroll_height);
    WSMFpropertyDef(WSNmargin,  WSCuchar, _marginw);
    WSMFpropertyDef(WSNvirtualScroll, WSCbool, _virtual_scr);
    WSMFpropertyDef(WSNframe, WSCbool, _frame);

    WSDLEX32 virtual void setWorkWSNshadowThickness(WSCuchar);
    WSDLEX32 virtual void setWorkWSNforeColor(short);
    WSDLEX32 virtual void setWorkWSNtopShadowColor(short);
    WSDLEX32 virtual void setWorkWSNbottomShadowColor(short);
    WSDLEX32 virtual void setWorkWSNpixmapStyle(WSCuchar);
    WSDLEX32 virtual void setWorkWSNbackColor(short);
    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);

    WSDLEX32 static void _h_scr_work_op(WSCbase*);
    WSDLEX32 static void _ha_scr_work_op(WSCbase*);
    WSDLEX32 static void _v_scr_work_op(WSCbase*);
    WSDLEX32 static void _va_scr_work_op(WSCbase*);
    WSDLEX32 static void _scr_mouse_press(WSCbase*);
    WSDLEX32 static void _scr_mouse_release(WSCbase*);
    WSDLEX32 static void _scr_mouse_move(WSCbase*);
    WSDLEX32 static void _scr_mouse_dclick(WSCbase*);

    WSDLEX32 WSCushort _get_shift_width();
    WSDLEX32 WSCushort _get_shift_height();

    WSDLEX32 virtual void  _adjust();
    WSDLEX32 void _adjust_scr_area();
    WSDLEX32 void _adjust_children();
    WSDLEX32 void _redraw_scr();

    WSDLEX32 virtual long _device_initialize();
//    virtual WSCbool _use_bscrbar_class();
    WSDLEX32 WSCbool _get_hbar_visible();
    WSDLEX32 WSCbool _get_vbar_visible();
    WSDLEX32 void _set_no_scroll(WSCbool fl);
    WSDLEX32 virtual void _adjust_no_scroll();
WSDLEX32 static void      (*_ext_draw_proc)(void*);
WSDLEX32 static WSCstring _policy_name;

  public:
    WSDLEX32 WSCscrForm(WSCbase*,char*);
    WSDLEX32 virtual ~WSCscrForm();

WSDLEX32 static void setUseScrBarClass(char*);
WSDLEX32 static char* getUseScrBarClass();

    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual void update();

    WSDLEX32 virtual void onParentVisibleChange(WSCbool);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onChildAdded(WSCbase*);
    WSDLEX32 virtual void onValueChange();
    WSDLEX32 virtual void onGuiPolicyChange(long);
    WSDLEX32 virtual void onMousePress(WSCpoint*);
    WSDLEX32 virtual void onScrMousePress(WSCpoint*);
    WSDLEX32 virtual void onScrMouseRelease(WSCpoint*);
    WSDLEX32 virtual void onScrMouseMove(WSCpoint*);
    WSDLEX32 virtual void onScrMouseDoubleClick(WSCpoint*);

    WSDLEX32 virtual long execEventProc(long ev,void*);
    WSDLEX32 virtual long clear();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual long redraw();
    WSDLEX32 virtual long cdraw();
    WSDLEX32 virtual long setPropertyEditMode(WSCbool );
    WSDLEX32 virtual void  _exec_child_adjust_for_anchors();
    WSDLEX32 virtual long getObjectType();

    WSDLEX32 long getVisibleWidth();
    WSDLEX32 long getVisibleHeight();
    WSDLEX32 WSCbase* getScrFrame();
    WSMFguiClassDef(WSCscrForm,WSCform);
    WSMFversionDef(WSCscrForm);
};

struct WSCscrForm_draw_struct{
  WSCscrForm* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  short fore_color;
  short back_color;
  short top_shadow_color;
  short bottom_shadow_color;
  short work_back_color;
  short back_pixmap;
  long shadow_type;
  short gradation;
  short gradation_margin;
  WSCushort bar_thickness;
  WSCuchar  margin_width;
  WSCuchar  padding;
  WSCbool   frame;
  WSCbool   vbar_visible;
  WSCbool   hbar_visible;
  
};

#endif
