#ifndef _WSCSHEET_H
#define _WSCSHEET_H

#include <WScom.h>
#include <WSCform.h>
#include <WSCsheetListData.h>
#include <WSCvdb.h>
#include <WSCdb.h>
#include <WSCsheetdef.h>
#include <WSDkeyboard.h>

#define WSsheet_VER                    1000

#define WSCSHEET_DEFAULT               -1

#define WSCSHEET_NONE                  0
#define WSCSHEET_HORZ                  1
#define WSCSHEET_VERT                  2
#define WSCSHEET_BOTH                  3

#define WSCSHEET_DEF_ROW_HEIGHT        20
#define WSCSHEET_DEF_COL_WIDTH         80

#define WSCSHEET_DEFCOLOR              0
#define WSCSHEET_DEFFONT               -1

#define WSCSHEET_DEF_ROWS              51
#define WSCSHEET_DEF_COLS              11
#define WSCSHEET_DEF_FIXEDROWS         1
#define WSCSHEET_DEF_FIXEDCOLS         1

#define WSCSHEET_CELL_NOLOCK           False
#define WSCSHEET_CELL_LOCK             True

#define WSCSHEET_DB_SORT_ASC           0
#define WSCSHEET_DB_SORT_DESC          1


class WSCvscrBar;
class WSCvifield;

class WSCsheetCell
{
public:
    WSCsheetCell()
    {
        lock = WSCSHEET_CELL_NOLOCK;
        align = WS_LEFT;
        text.clear();
        crBkClr = WSCSHEET_DEFCOLOR;
        crFgClr = WSCSHEET_DEFCOLOR;
        fontno = WSCSHEET_DEFFONT;
        crLine = WSCSHEET_DEFAULT;
    }

public:
    WSCbool       lock;                // Cell Edit Lock (or WSCSHEET_CELL_NOLOCK)
    char          align;               // Cell text align (or WS_LEFT)
    WSCstring     text;                // Cell text (or binary data if you wish...)
    short         crBkClr;             // Background colour (or WSCSHEET_DEFCOLOR)
    short         crFgClr;             // Forground colour (or WSCSHEET_DEFCOLOR)
    short         fontno;              // Cell font (or WSCSHEET_DEFFONT)
    short         crLine;              // Cell Line Type (or WSCSHEET_DEFAULT)
}; 

class WSCsheetRow
{
public:
    WSCsheetRow(long cols, long height = WSCSHEET_DEFAULT)
    {
        _height = height;
        setColSize(cols);
    }
    void clear()
    {
        long num = _colData.getNum();
        for(long col = 0; col < num; col++) {
            WSCsheetCell* coldata = (WSCsheetCell*)_colData.getData(col);
            delete coldata;
        }
        _colData.clear();
    }
    void setRowHeight(long height) { _height = height; }
    long getRowHeight() { return _height; }
    long setColSize(long cols)
    {
        _colData.setSize(cols);
        return WS_NO_ERR;
    }
    WSCsheetCell* newCell(long col)
    {
        WSCsheetCell* cell = new WSCsheetCell();
        _colData.setData(col, cell);
        return cell;
    }
    WSCsheetCell* getCell(long col)
    {
        WSCsheetCell* cell = (WSCsheetCell*)_colData.getData(col);
        return cell;
    }
    long insertCol(long col, long cols)
    {
        long num = _colData.getNum();
        for(long count = 0; count < cols; count++) {
            WSCsheetCell* coldata = new WSCsheetCell();
            _colData.add(coldata, col);
        }
        setColSize(num);
        return WS_NO_ERR;
    }
    long deleteCol(long col, long cols)
    {
        long num = _colData.getNum();
        long max = num - col;
        for(long count = 0; (count < cols) && (count < max); count++) {
            WSCsheetCell* coldata = (WSCsheetCell*)_colData.getData(col);
            delete coldata;
            _colData.delPos(col);
        }
        setColSize(num);
        return WS_NO_ERR;
    }
public:
    long             _height;
    WSCsheetListData _colData;
};


class WSCsheet : public WSCform
{
public:
    WSDLEX32 WSCsheet(WSCbase* parent, char* name);
    WSDLEX32 virtual ~WSCsheet();

    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long clear(long col = WSCSHEET_DEF_COLS, long row = WSCSHEET_DEF_ROWS);
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual long redraw();
    WSDLEX32 virtual long cdraw();
    WSDLEX32 virtual void update();

    WSDLEX32 virtual void onResize(WSCrect* rect);
    WSDLEX32 virtual void onMouseMove(WSCpoint* pt);
    WSDLEX32 virtual void onMousePress(WSCpoint* pt);
    WSDLEX32 virtual void onMouseRelease(WSCpoint* pt);
    WSDLEX32 virtual void onVisibleChange(WSCbool vis);

public:
    WSDLEX32 long      getRowCount() const { return _rows; }
    WSDLEX32 long      setRowCount(long rows = WSCSHEET_DEF_ROWS);
    WSDLEX32 long      getColumnCount() const { return _cols; }
    WSDLEX32 long      setColumnCount(long cols = WSCSHEET_DEF_COLS);

    WSDLEX32 long      getRowHeight(long row);
    WSDLEX32 long      setRowHeight(long row, long height);
    WSDLEX32 long      getColumnWidth(long col);
    WSDLEX32 long      setColumnWidth(long col, long width);
   
    WSDLEX32 long      getFixedRowCount() const { return _fixedRows; }
    WSDLEX32 long      setFixedRowCount(long fixedRows = WSCSHEET_DEF_FIXEDROWS);
    WSDLEX32 long      getFixedColumnCount() const { return _fixedCols; }
    WSDLEX32 long      setFixedColumnCount(long fixedCols = WSCSHEET_DEF_FIXEDCOLS);

    WSDLEX32 long      getFixedRowHeight(long row);
    WSDLEX32 long      setFixedRowHeight(long row, long height);
    WSDLEX32 long      getFixedColumnWidth(long col);
    WSDLEX32 long      setFixedColumnWidth(long col, long width);

    WSDLEX32 long      setSheetBkColor(char* cname);
    WSDLEX32 long      setSheetBkColor(short color);
    WSDLEX32 short     getSheetBkColor() const { return _sheetBackColor; }

    WSDLEX32 long      setCellDefBkColor(char* cname);
    WSDLEX32 long      setCellDefBkColor(short color);
    WSDLEX32 short     getCellDefBkColor() const { return _cellBackColor; }

    WSDLEX32 long      setCellBkColor(char* cname);
    WSDLEX32 long      setCellBkColor(long col, long row, char* cname);
    WSDLEX32 long      setCellBkColor(short color);
    WSDLEX32 long      setCellBkColor(long col, long row, short color);
    WSDLEX32 short     getCellBkColor(long col, long row);

    WSDLEX32 long      setCellDefTextColor(char* cname);
    WSDLEX32 long      setCellDefTextColor(short color);
    WSDLEX32 short     getCellDefTextColor() const { return _cellTextColor; }

    WSDLEX32 long      setCellTextColor(char* cname);
    WSDLEX32 long      setCellTextColor(long col, long row, char* cname);
    WSDLEX32 long      setCellTextColor(short color);
    WSDLEX32 long      setCellTextColor(long col, long row, short color);
    WSDLEX32 short     getCellTextColor(long col, long row);

    WSDLEX32 long      setFixedBkColor(char* cname);
    WSDLEX32 long      setFixedBkColor(short color);
    WSDLEX32 short     getFixedBkColor() const { return _fixedBackColor; }

    WSDLEX32 long      setFixedTextColor(char* cname);
    WSDLEX32 long      setFixedTextColor(short color);
    WSDLEX32 short     getFixedTextColor() const { return _fixedTextColor; }

    WSDLEX32 long      setGridColor(char* cname);
    WSDLEX32 long      setGridColor(short color);
    WSDLEX32 short     getGridColor() { return _gridColor; }

    WSDLEX32 long      setGridLines(short glidLines = WSCSHEET_BOTH);
    WSDLEX32 short     getGridLines() const { return _gridLines; }

    WSDLEX32 long      setCellGridLines(short glidLines = WSCSHEET_BOTH);
    WSDLEX32 long      setCellGridLines(long col, long row, short glidLines = WSCSHEET_BOTH);
    WSDLEX32 short     getCellGridLines(long col, long row);

    WSDLEX32 long      setText(short text);
    WSDLEX32 long      setText(WSCushort text);
    WSDLEX32 long      setText(long text);
    WSDLEX32 long      setText(WSCulong text);
    WSDLEX32 long      setText(float text);
    WSDLEX32 long      setText(double text);
    WSDLEX32 long      setText(const char* text);
    WSDLEX32 long      setText(const WSCvariant& text);
    WSDLEX32 long      setText(const WSCstring& text);
    WSDLEX32 long      setText(long col, long row, short text);
    WSDLEX32 long      setText(long col, long row, WSCushort text);
    WSDLEX32 long      setText(long col, long row, long text);
    WSDLEX32 long      setText(long col, long row, WSCulong text);
    WSDLEX32 long      setText(long col, long row, float text);
    WSDLEX32 long      setText(long col, long row, double text);
    WSDLEX32 long      setText(long col, long row, const char* text);
    WSDLEX32 long      setText(long col, long row, const WSCvariant& text);
    WSDLEX32 long      setText(long col, long row, const WSCstring& text);
    WSDLEX32 WSCstring getText(long col, long row);

    WSDLEX32 long      setFixedText(long col, long row, short text);
    WSDLEX32 long      setFixedText(long col, long row, WSCushort text);
    WSDLEX32 long      setFixedText(long col, long row, long text);
    WSDLEX32 long      setFixedText(long col, long row, WSCulong text);
    WSDLEX32 long      setFixedText(long col, long row, float text);
    WSDLEX32 long      setFixedText(long col, long row, double text);
    WSDLEX32 long      setFixedText(long col, long row, const char* text);
    WSDLEX32 long      setFixedText(long col, long row, const WSCvariant& text);
    WSDLEX32 long      setFixedText(long col, long row, const WSCstring& text);
    WSDLEX32 WSCstring getFixedText(long col, long row);

    WSDLEX32 long      getCellNo(WSCpoint* pt, long* col, long* row);

    WSDLEX32 long      setFocusCell(long col, long row);
    WSDLEX32 void      getFocusCell(long* col, long* row) { *col = _focusCol; *row = _focusRow; }
    WSDLEX32 long      getFocusCol() { return _focusCol; }
    WSDLEX32 long      getFocusRow() { return _focusRow; }
    
    WSDLEX32 void      setRow(long row);
    WSDLEX32 long      getRow() { return _startRow; }
    WSDLEX32 void      setStartRow(long row);
    WSDLEX32 long      getStartRow() { return (_startRow <= _endRow ? _startRow : _endRow); }
    WSDLEX32 void      setEndRow(long row);
    WSDLEX32 long      getEndRow() { return (_startRow > _endRow ? _startRow : _endRow); }

    WSDLEX32 void      setCol(long col);
    WSDLEX32 long      getCol() { return _startCol; }
    WSDLEX32 void      setStartCol(long col);
    WSDLEX32 long      getStartCol() { return (_startCol <= _endCol ? _startCol : _endCol); }
    WSDLEX32 void      setEndCol(long col);
    WSDLEX32 long      getEndCol() { return (_startCol > _endCol ? _startCol : _endCol); }

    WSDLEX32 void      setSelectCell(WSCbool val);
    WSDLEX32 WSCbool   getSelectCell() { return _selectCell; }

    WSDLEX32 void      setEditEnabled(WSCbool val) { _editEnabled = val; }
    WSDLEX32 WSCbool   getEditEnabled() { return _editEnabled; }

    WSDLEX32 long      getFocusCellRect(WSCrect* rect);
    WSDLEX32 long      getVisibleCellRect(long col, long row, WSCrect* rect);
    WSDLEX32 long      getCellRect(long col, long row, WSCrect* rect);

    WSDLEX32 long      setTopVisibleRow(long row);
    WSDLEX32 long      getTopVisibleRow() { return _topVisibleRow; };
    WSDLEX32 long      setTopVisibleCol(long col);
    WSDLEX32 long      getTopVisibleCol() { return _topVisibleCol; };

    WSDLEX32 long      setCellDefFont(short fontno);
    WSDLEX32 short     getCellDefFont() { return _font; }

    WSDLEX32 long      setCellFont(short fontno);
    WSDLEX32 long      setCellFont(long col, long row, short fontno);
    WSDLEX32 short     getCellFont() { return _font; }
    WSDLEX32 short     getCellFont(long col, long row);
    
    WSDLEX32 long      setFixedCellFont(short fontno);
    WSDLEX32 short     getFixedCellFont() { return _fixedFont; }

    WSDLEX32 void      setVertAutoNumber(WSCbool val) { _vautoNumber = val; }
    WSDLEX32 WSCbool   getVertAutoNumber() { return _vautoNumber; }
    WSDLEX32 void      setHorzAutoNumber(WSCbool val) { _hautoNumber = val; }
    WSDLEX32 WSCbool   getHorzAutoNumber() { return _hautoNumber; }

    WSDLEX32 long      setCellAlignemnt(char align);
    WSDLEX32 long      setCellAlignemnt(long col, long row, char align);
    WSDLEX32 char      getCellAlignemnt(long col, long row);

    WSDLEX32 long      setFixedCellAlignemnt(long col, long row, char align);
    WSDLEX32 char      getFixedCellAlignemnt(long col, long row);

    WSDLEX32 long      setCellLock(WSCbool lock);
    WSDLEX32 long      setCellLock(long col, long row, WSCbool lock);
    WSDLEX32 WSCbool   getCellLock(long col, long row);
    
    WSDLEX32 WSCushort getClientWidth() { return _clientWidth; }
    WSDLEX32 WSCushort getClientHeight() { return _clientHeight; }
    
    WSDLEX32 void      setNoRefresh(WSCbool val) { _no_refresh = val; }
    WSDLEX32 WSCbool   getNoRefresh() { return _no_refresh; }
    
    WSDLEX32 long      insertRow();
    WSDLEX32 long      insertRow(long row, long rows);
    WSDLEX32 long      insertCol();
    WSDLEX32 long      insertCol(long col, long cols);
    
    WSDLEX32 long      deleteRow();
    WSDLEX32 long      deleteRow(long row, long rows);
    WSDLEX32 long      deleteCol();
    WSDLEX32 long      deleteCol(long col, long cols);

    /// database 
    WSDLEX32 long      setDataSource(const char* name);
    WSDLEX32 long      setDataSource(WSCstring& name);
    WSDLEX32 WSCstring getDataSource() { _dbwork = _dataSource; return _dbwork; }

    WSDLEX32 long      setTableName(const char* table);
    WSDLEX32 long      setTableName(WSCstring& table);
    WSDLEX32 WSCstring getTableName() { _dbwork = _tableName; return _dbwork; }
    
    WSDLEX32 long      setDbItem(const char* item);
    WSDLEX32 long      setDbItem(WSCstring& item);
    WSDLEX32 WSCstring getDbItem() { _dbwork = _dbItem; return _dbwork; }

    WSDLEX32 long      setDbSortItem1(const char* item);
    WSDLEX32 long      setDbSortItem1(WSCstring& item);
    WSDLEX32 WSCstring getDbSortItem1() { _dbwork = _dbSortItem1; return _dbwork; }

    WSDLEX32 long      setDbSort1(WSCuchar sort);
    WSDLEX32 WSCuchar  getDbSort1() { return _dbSort1; }

    WSDLEX32 long      setDbSortItem2(const char* item);
    WSDLEX32 long      setDbSortItem2(WSCstring& item);
    WSDLEX32 WSCstring getDbSortItem2() { _dbwork = _dbSortItem2; return _dbwork; }

    WSDLEX32 long      setDbSort2(WSCuchar sort);
    WSDLEX32 WSCuchar  getDbSort2() { return _dbSort2; }

    WSDLEX32 long      setDbSortItem3(const char* item);
    WSDLEX32 long      setDbSortItem3(WSCstring& item);
    WSDLEX32 WSCstring getDbSortItem3() { _dbwork = _dbSortItem3; return _dbwork; }

    WSDLEX32 long      setDbSort3(WSCuchar sort);
    WSDLEX32 WSCuchar  getDbSort3() { return _dbSort3; }
    
    WSDLEX32 long      setDbFilter(const char* filter);
    WSDLEX32 long      setDbFilter(WSCstring& filter);
    WSDLEX32 WSCstring getDbFilter() { _dbwork = _dbFilter; return _dbwork; }

    WSDLEX32 long      setDbStmtString(const char* stmt);
    WSDLEX32 long      setDbStmtString(WSCstring& stmt);
    WSDLEX32 WSCstring getDbStmtString() { _dbwork = _dbStmtString; return _dbwork; }

    WSDLEX32 long      dbRefresh();
    WSDLEX32 long      dataClear(long col = 2, long row = 2);

protected:
    WSDLEX32 virtual   long _device_initialize();
    WSDLEX32 static    void onHscroolClick(WSCbase* obj);
    WSDLEX32 static    void onVscrollClick(WSCbase* obj);
    WSDLEX32 static    void onEditFocusChange(WSCbase* obj);
    WSDLEX32 static    void onSheetExpose(WSCbase* obj);
    WSDLEX32 static    void onSheetMouseMove(WSCbase* obj);
    WSDLEX32 static    void onSheetMousePress(WSCbase* obj);
    WSDLEX32 static    void onSheetMouseRelease(WSCbase* obj);
    WSDLEX32 virtual   void onScrMouseMove(WSCpoint* pt);
    WSDLEX32 virtual   void onScrMousePress(WSCpoint* pt);
    WSDLEX32 virtual   void onScrMouseRelease(WSCpoint* pt);
    WSDLEX32 static    void onEditActivate(WSCbase* obj);
    WSDLEX32 static    void onEditKeyPress(WSCbase* obj);
    WSDLEX32 static    void onEditKeyRelease(WSCbase* obj);
    WSDLEX32 static    void onEditKeyHook(WSCbase* obj);
    WSDLEX32 static    void onEditValueChange(WSCbase* obj);
    WSDLEX32 virtual   void onActivate();
    WSDLEX32 virtual   void onKeyPress(WSDkeyboard* keyboard);
    WSDLEX32 virtual   void onKeyRelease(WSDkeyboard* keyboard);
    WSDLEX32 virtual   void onKeyHook(WSDkeyboard* keyboard);
    WSDLEX32 virtual   void onValueChange();

    WSMFguiClassDef(WSCsheet, WSCform);
    WSMFversionDef(WSsheet);

    WSDLEX32 long      setCellText(const WSCstring& text);
    WSDLEX32 long      setCellText(long col, long row, const WSCstring& text);
    WSDLEX32 WSCstring getCellText(long col, long row);
    WSDLEX32 long      setFixedCellText(long col, long row, const WSCstring& text);
    WSDLEX32 WSCstring getFixedCellText(long col, long row);
    WSDLEX32 void      adjustScrollBar();
    WSDLEX32 char*     getUseScrBarClass();
    WSDLEX32 long      drawFixedCell(WSDdev* dev, long col, long row, WSCrect rect);
    WSDLEX32 long      drawCell(WSDdev* dev, long col, long row, WSCrect rect);
    WSDLEX32 long      rowSize(long rows);
    WSDLEX32 long      colSize(long cols);
    WSDLEX32 void      setRowCol(long col, long row);
    WSDLEX32 void      focusCellVisible(long coldCol, long oldRow, long newCol, long newRow);
    WSDLEX32 void      posMoveCell(WSCpoint* pt);
    WSDLEX32 long      getWidthValue(long col);
    WSDLEX32 void      setEndVisibleRow(long row) { _endVisibleRow = row; };
    WSDLEX32 long      getEndVisibleRow() { return _endVisibleRow; };
    WSDLEX32 void      setEndVisibleCol(long col) { _endVisibleCol = col; };
    WSDLEX32 long      getEndVisibleCol() { return _endVisibleCol; };
    
    WSDLEX32 WSCsheetCell* getCell(long col, long row, WSCbool alloc = False);
    WSDLEX32 WSCsheetRow*  getRowData(long row);
    WSDLEX32 long*         getWidthData(long col);

    WSDLEX32 long      dbConnect();
    WSDLEX32 long      setFixedCelldbItem(WSCdbRecord* rs);
    WSDLEX32 long      dbDataSet();
    WSDLEX32 WSCstring getDbErrorMsg();
    

protected:
    long        _rows;
    long        _cols;
    long        _fixedRows;
    long        _fixedCols;
    short       _gridLines;

    long        _colHeight;
    long        _colWidth;
    long        _fixedColHeight;
    
    long        _topVisibleRow;
    long        _topVisibleCol;
    long        _endVisibleRow;
    long        _endVisibleCol;
    long        _focusRow;
    long        _focusCol;
    long        _startRow;
    long        _startCol;
    long        _endRow;
    long        _endCol;

    WSCushort   _clientWidth;
    WSCushort   _clientHeight;
    WSCushort   _bar_thick;

    short       _font;
    short       _fixedFont;
    
    WSCbool     _mousepress;
    WSCbool     _mouseSelect;
    WSCbool     _selectCell;
    WSCbool     _editEnabled;
    WSCbool     _hautoNumber;
    WSCbool     _vautoNumber;
    WSCbool     _initVisible;
    WSCbool     _adjust;
    
    WSCform*    _sheet;
    WSCvscrBar* _hscrBar;
    WSCvscrBar* _vscrBar;
    WSCvifield* _edit;

    short       _sheetBackColor;
    short       _cellBackColor;
    short       _cellTextColor;
    short       _fixedBackColor;
    short       _fixedTextColor;
    short       _gridColor;
    short       _selectBackColor;
    
    WSCsheetListData _rowData;
    WSCsheetListData _colWidthData;
    WSCsheetCell     _defCell;
    
    /// database
    WSCvdb*     _vdb;
    char*       _dataSource;
    char*       _tableName;
    char*       _dbItem;
    char*       _dbSortItem1;
    char*       _dbSortItem2;
    char*       _dbSortItem3;
    char*       _dbFilter;
    char*       _dbStmtString;
    WSCuchar    _dbSort1;
    WSCuchar    _dbSort2;
    WSCuchar    _dbSort3;
    WSCstring   _dbwork;
    WSCbool     _dbCellAutoResize;
    WSCbool     _dbCellTitle;
    WSCstring   _dbError;
    
protected:
    WSMFpropertyDef(WSNrows, long, _rows);
    WSMFpropertyDef(WSNcols, long, _cols);
    WSMFpropertyDef(WSNfixedRows, long, _fixedRows);
    WSMFpropertyDef(WSNfixedCols, long, _fixedCols);
    WSMFpropertyDef(WSNgridLines, short, _gridLines);
    WSMFpropertyDef(WSNcellDefWidth, long, _colWidth);
    WSMFpropertyDef(WSNcellDefHeight, long, _colHeight);
    WSMFpropertyDef(WSNfixedColHeight, long, _fixedColHeight);
    WSMFpropertyDef(WSNcellDefFont, short, _font);
    WSMFpropertyDef(WSNfixedCellFont, short, _fixedFont);
    WSMFpropertyDef(WSNeditEnabled, WSCbool, _editEnabled);
    WSMFpropertyDef(WSNhautoNumber, WSCbool, _hautoNumber);
    WSMFpropertyDef(WSNvautoNumber, WSCbool, _vautoNumber);
    WSMFpropertyDef(WSNsheetBackColor, short, _sheetBackColor);
    WSMFpropertyDef(WSNcellDefBackColor, short, _cellBackColor);
    WSMFpropertyDef(WSNcellDefTextColor, short, _cellTextColor);
    WSMFpropertyDef(WSNfixedBackColor, short, _fixedBackColor);
    WSMFpropertyDef(WSNfixedTextColor, short, _fixedTextColor);
    WSMFpropertyDef(WSNgridColor, short, _gridColor);

    WSMFpropertyDef(WSNdataSourceName, char*, _dataSource);
    WSMFpropertyDef(WSNdbTableName, char*, _tableName);
    WSMFpropertyDef(WSNdbItem, char*, _dbItem);
    WSMFpropertyDef(WSNsortItem1, char*, _dbSortItem1);
    WSMFpropertyDef(WSNsort1, WSCuchar, _dbSort1);
    WSMFpropertyDef(WSNsortItem2, char*, _dbSortItem2);
    WSMFpropertyDef(WSNsort2, WSCuchar, _dbSort2);
    WSMFpropertyDef(WSNsortItem3, char*, _dbSortItem3);
    WSMFpropertyDef(WSNsort3, WSCuchar, _dbSort3);
    WSMFpropertyDef(WSNfilter, char*, _dbFilter);
    WSMFpropertyDef(WSNsql, char*, _dbStmtString);
    WSMFpropertyDef(WSNdbCellAutoResize, WSCbool, _dbCellAutoResize);
    WSMFpropertyDef(WSNdbCellTitle, WSCbool, _dbCellTitle);

};
#endif // _WSCSHEET_H
