//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCVIFIELD_H
#define WSCVIFIELD_H

#include <WScom.h>
#include <WSCvlabel.h>
class WSDkeyboard;

#define WSCvifield_VER  1001

class WSCvifield   :public WSCvlabel{

  protected:
    static long _cur_timer_id;
    long      _mx;
    long      _my;
    char*     _upname;
    char*     _dwname;
    char*     _lname;
    char*     _rname;
    char*     _rtname;
    char*     _tbname;
    char*     _btbname;
    char*     _data_source_name;

    long      _cur_pos;
//    WSCushort _columns;
    WSCushort _cbase;
    long     _disp_cur_x;
    long     _disp_cur_y;
    long      _cur_pos_bk;
    WSCushort* _ucs2;
    WSCushort* _str_work;

    long      _lines;
    unsigned  _data_source_type:2;
    long      _select_pos1;
    long      _select_pos2;
    unsigned  _kanji_in:1;
    unsigned  _icursor:1;
    unsigned  _enable_focus_move:1;
    unsigned  _fspace:1;
    unsigned  _cursor_adjust:1;
    unsigned  _multi_lines:1;
    unsigned  _skip_mode:1;
    unsigned  _enable_max:1;
    unsigned  _cursor_fore:1;
    unsigned  _no_hatch:1;
    unsigned  _no_mcur_adjust:1;
    unsigned  _mouse_pressed:1;
    unsigned  _deleting:1;
    unsigned  _return_key_focus:1;
    unsigned  _key_input_disable:1;
    unsigned  _fep_set_focus:1;
    unsigned  _display_only:1;
    unsigned  _need_ds_update:1;
    unsigned  _text_changed:1;


//    WSMFpropertyDef(WSNcolumns,     WSCushort, _columns);
    WSMFpropertyDef(WSNcursorPos,   short,    _cur_pos);
    WSMFpropertyDef(WSNkanjiIn,     WSCbool,  _kanji_in);
    WSMFpropertyDef(WSNinterCur,    WSCbool,  _icursor);
    WSMFpropertyDef(WSNenableFocusMove,  WSCbool, _enable_focus_move );
    WSMFpropertyDef(WSNupward,    char*,   _upname);
    WSMFpropertyDef(WSNdownward, char*,   _dwname);
    WSMFpropertyDef(WSNleftward,   char*,   _lname);
    WSMFpropertyDef(WSNrightward,  char*,   _rname);
    WSMFpropertyDef(WSNreturn,     char*,   _rtname);
    WSMFpropertyDef(WSNtab,     char*,   _tbname);
    WSMFpropertyDef(WSNbacktab,     char*,   _btbname);
    WSMFpropertyDef(WSNfillSpace,   WSCbool,      _fspace);
    WSMFpropertyDef(WSNcursorAdjust,WSCbool,      _cursor_adjust);
    WSMFpropertyDef(WSNifieldSkipMode,   WSCbool, _skip_mode);
    WSMFpropertyDef(WSNnoHatch,   WSCbool, _no_hatch);
    WSMFpropertyDef(WSNreturnKeyFocus,   WSCbool, _return_key_focus);

    WSMFpropertyDef(WSNdataSource,  WSCuchar, _data_source_type  );
    WSMFpropertyDef(WSNdataSourceName,  char*, _data_source_name  );
    WSMFpropertyDef(WSNdisplayOnly,  WSCbool, _display_only  );


    WSDLEX32 virtual void setWorkWSNmaxLength(WSCushort data);
    WSDLEX32 virtual void setWorkWSNlabelString(char* data);
    WSDLEX32 virtual void getWorkWSNlabelString(char** data);

    WSDLEX32 static void _cursor_blink_handler(WSCuchar,void*);
    WSDLEX32 static WSCbool _special_key_handler(void*,WSDkeyboard*,WSCbool);
    WSDLEX32 static void _key_handler(void*,WSDkeyboard*,WSCbool);
//    static void _focus_lose_handler(void*);


    WSDLEX32 virtual void  _on_key_input(WSDkeyboard*,WSCbool); 
    WSDLEX32 virtual long  _device_initialize();

//    char* _get_text();
    WSDLEX32 void  _adjust_cbase();
    WSDLEX32 void  _set_text(WSCushort*);
    WSDLEX32 void  _update_text();
    WSDLEX32 void  _fill_space();
    WSDLEX32 void  _set_cur_pos(long absolute_pos);
    WSDLEX32 void  _get_cur_pos(long* x,long* y,long* pos);

//    WSCushort* _get_disp_string();
    WSDLEX32 WSCbool _return_key_ok();  

    WSDLEX32 void _fep_cursor_adjust(WSDkeyboard*);
WSDLEX32 virtual long _cursor_move(char direction);
    WSDLEX32 void _get_disp_cur_pos(long* x,long* y);
    WSDLEX32 long _get_absolute_pos(long x,long y);
    WSDLEX32 void _set_select_pos1(long pos);
    WSDLEX32 void _set_select_pos2(long pos);
    WSDLEX32 void _delete_select_string();
    WSDLEX32 void _reset_select_string();
    WSDLEX32 void _replace_string(WSCushort*);
    WSDLEX32 void _adjust_max_len();
    WSDLEX32 void _set_ds_instance();

  public:
    WSDLEX32 WSCvifield(WSCbase*,char*);
    WSDLEX32 virtual ~WSCvifield();

    WSDLEX32 virtual void onCursorBlink();                  
    WSDLEX32 virtual void onFocusChange(WSCbool);
    WSDLEX32 virtual void onWindowFocusChange(WSCbool);
    WSDLEX32 virtual void onSpecialFocusChange(WSCbool);
    WSDLEX32 virtual void onMousePress(WSCpoint*);
    WSDLEX32 virtual void onMouseRelease(WSCpoint*);
    WSDLEX32 virtual void onMouseMove(WSCpoint*);
    WSDLEX32 virtual void onKeyHook(WSDkeyboard*);
    WSDLEX32 virtual void onKeyInput(WSDkeyboard*,WSCbool);
    WSDLEX32 virtual void onKey(WSDkeyboard*,WSCbool);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onValueChange();
    WSDLEX32 virtual void onSelectionChange(WSCbool);
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool);

    WSDLEX32 virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT);
    WSDLEX32 virtual long getDataSourceType();                                     
    WSDLEX32 virtual char* getDataSourcePropertyName();

    WSDLEX32 virtual long draw();
    WSDLEX32 virtual void update();

    WSDLEX32 void setCursorFore(WSCbool fl);
    WSDLEX32 WSCbool getCursorFore();
    WSDLEX32 WSCbool setCurPos(long pos); //pos >= 0
    WSDLEX32 void replaceSelectedString(char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 WSCstring getSelectedString();
    WSDLEX32 void deleteSelectedString();
    WSDLEX32 long setSelect(long,long);
    WSDLEX32 long getSelectedPos();
    WSDLEX32 long setFepStatus(WSCbool);
    WSDLEX32 WSCushort* getBuf();
    WSDLEX32 WSCstring getString();
    WSDLEX32 void setBuf(WSCushort*);
    WSDLEX32 void addString(char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 void setKeyInputDisable(WSCbool);
    WSDLEX32 WSCbool getKeyInputDisable();

    WSMFguiClassDef(WSCvifield,WSCvlabel);
    WSMFversionDef(WSCvifield);
};
#define WS_MLINE_MARGIN 2
#endif
