//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDKEYBOARD_H
#define WSDKEYBOARD_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSkeysym.h>
#include <WSCstring.h>
class WSDdev;
class WSCballoonHelp;

typedef WSCbool (*WSDkeyProc)(long,WSCbool );
typedef void (*WSDfocusKeyProc)(void*,WSCbool );
typedef void (*WSDloseFocusProc)(void*);

class WSDkeyboard :public WSCroot{

  protected:
    WSCstring _select_str;
    void (*_normal_proc1)(void*,WSDkeyboard*,WSCbool);
    void (*_normal_proc2)(void*);
    WSCbool (*_special_proc)(void*,WSDkeyboard*,WSCbool);
    WSCbool (*_global_proc)(long,WSCbool);
    void* _normal_ptr;
    void* _special_ptr;
    long  _key;
    WSCstring _text;
    unsigned  _with_shift:1;
    unsigned  _with_lock:1;
    unsigned  _with_alt:1;
    unsigned  _with_cntl:1;
    unsigned  _is_cursor:1;
    unsigned  _is_function:1;
    unsigned  _is_tty_function:1;
    unsigned  _enable_fep:1;
    unsigned  _fep_on:1;
    unsigned  _is_pressed:1;

    static WSCballoonHelp*  _status_win;
    WSDLEX32 static void _mode_win_move(WSCbase*);

    WSDLEX32 void setVisibleModeWindow(WSCbool fl);
    WSDLEX32 void setPositionModeWindow(short x,short y);
    WSDLEX32 void setModeString(char*);

  public:
    WSDLEX32 WSDkeyboard();

    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual void setKey(long);
    WSDLEX32 virtual void setEnableFep(WSDdev*,WSCbool);

    WSDLEX32 long    getKey();
    WSDLEX32 WSCbool isPressed();
    WSDLEX32 WSCbool withShift();
    WSDLEX32 WSCbool withLock();
    WSDLEX32 WSCbool withCntl();
    WSDLEX32 WSCbool withAlt();
    WSDLEX32 WSCbool isCursorKey();
    WSDLEX32 WSCbool isFuncKey();
    WSDLEX32 WSCbool isTtyFunction();
    WSDLEX32 WSCbool getFepStatus();
    WSDLEX32 WSCbool executeHandler(WSCbool press);
    WSDLEX32 WSCbool getEnableFep();

    WSDLEX32 void setWithShift(WSCbool fl);
    WSDLEX32 void setWithLock(WSCbool fl);
    WSDLEX32 void setWithCntl(WSCbool fl);
    WSDLEX32 void setWithAlt(WSCbool fl);
    WSDLEX32 void setIsCursorKey(WSCbool fl);
    WSDLEX32 void setIsFuncKey(WSCbool fl);
    WSDLEX32 void setIsTtyFunction(WSCbool fl);
    WSDLEX32 void setIsPressed(WSCbool fl);

    WSDLEX32 virtual long startKanji(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    WSDLEX32 virtual long startAscii(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    WSDLEX32 virtual long setFepPos(WSDdev*,short x,short y,short fontno,short fgno,short bgno);
    WSDLEX32 virtual long resetFep(WSDdev*);

    WSDLEX32 WSCstring* getTextString();
    WSDLEX32 char*  getText(long encode = WS_EN_DEFAULT);
    WSDLEX32 void   setText(char*,long encode = WS_EN_DEFAULT);    
    WSDLEX32 static void setCreateInstanceHandler( WSDkeyboard* (*hd)() );

    WSDLEX32 void setFocusInputWorkProc( void (*)(void*,WSDkeyboard*, WSCbool), void (*)(void*),void* ); 
    WSDLEX32 void resetFocusInputWorkProc();
    WSDLEX32 void setSpecialInputWorkProc( WSCbool (*)(void* ptr, WSDkeyboard*,WSCbool ), void* ptr );
    WSDLEX32 void resetSpecialInputWorkProc();
    WSDLEX32 void setGlobalKeyHook( WSCbool (*)(long,WSCbool) ); 
    WSDLEX32 virtual void setSelectedString(char*,long encode = WS_EN_DEFAULT);
    WSDLEX32 virtual char* getSelectedString(long encode = WS_EN_DEFAULT);

    WSMFclassDef(WSDkeyboard,WSCroot);
};
extern WSDLEX WSDkeyboard* WSGIappKeyboard();
#endif
