//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCINSPECTOR_H
#define WSCINSPECTOR_H

#include <WScom.h>
#include <WSCsform.h>
#include <WSClistData.h>

#define WSCinspector_VER 1000
class WSCindexForm;
class WSCpropertyEditor;
class WSClist;
class WSCprocedureEditor;
class WSCwindowEditor;
class WSCpopupMenu;
class WSCfform;
class WSCdirTree;


class WSCinspector :public WSCsform{

  protected:
    WSClist*           _list;
    WSCindexForm*      _area2;
    WSCpropertyEditor* _prope;
    WSClistData*       _target_list;
    WSCprocedureEditor* _ope;
    WSCwindowEditor*    _we;
    WSCpopupMenu*       _pmenu;
    WSCpopupMenu*       _pmenu2;
    WSClist*           _list2;
    WSClistData        _pname;
    WSClistData        _procs;
    WSClistData*       _selected;
    WSCbase*           _pmenu_client;
    WSClist*           _file_list;
    WSCfform*          _fform;
    WSCfform*          _ifform;
    WSCfform*          _dfform;
    WSCdirTree*        _dir_tree;
    WSCsform*          _sform;
    WSCsform*          _sform2;
    WSCfform*          _mfform;
    WSCbase*           _pform;
    WSCfform*          _cfform;
    WSClist*           _class_list;
    
    char*              _pos_bk;
    void  (*_load_project_fn)(WSCinspector*,char*);

    void (*_search_proc)(WSCbase*);
    void (*_copy_proc)(WSCbase*);
    void (*_paste_proc)(WSCbase*);
    void (*_editor_proc)(WSCprocedureEditor*,char*);
    WSCulong           _value;
    void _adjust_work();

    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);
    virtual void setWorkWSNshadowThickness(WSCuchar);
    virtual void setWorkWSNbarValue(char*);
    virtual void getWorkWSNbarValue(char**);
  
    virtual void onResize(WSCrect* rect);

    WSCbase* _search_inst_work(char* name,WSCbase*);
    static void _area2_work(WSCbase*);
    static void _pe_select_work(WSCbase*);
    static void _prope_activate_work(WSCbase*);
    static void _lb_press_work(WSCbase*);
    static void _lb_activate_work(WSCbase*);
    static void _flb_activate_work(WSCbase*);
    static void _lb_activate2_work(WSCbase*);
    static void _popup_ch_work(WSCbase*);
    static void _file_list_vis_work(WSCbase*);
    static void _flb_press_work(WSCbase*);
    static void _float_work(WSCbase*);
    static void _float_work2(WSCbase*);
    static void _float_work3(WSCbase*);
    static void _float_work4(WSCbase*);
    static void _float_work5(WSCbase*);
    static void _float_vis_work(WSCbase*);
    static void _float_vis_work2(WSCbase*);
    static void _float_vis_work3(WSCbase*);
    static void _file_selected_work(WSCbase*);

    static void _prj_work(WSCbase*);
    static void _cmpl_work(WSCbase*);
    static void _save_work(WSCbase*);
    static void _disp_work(WSCbase*);
    static void _search_work(WSCbase*);
    static void _copy_work(WSCbase*);
    static void _paste_work(WSCbase*);
    static void _del_work(WSCbase*);

    void _set_list_work(WSCbase*,long);
    void _set_file_list_work(WSCbase*);
    void _update_lb();
    void (*_getproc(char*))(WSCbase*);
    virtual WSCbase* getPropertyInheritChild();
    void _adjust_forms();
    WSMFpropertyDef(WSNvalue,     WSCulong, _value);


  public:
    WSCinspector(WSCbase*,char*);
    virtual ~WSCinspector();
    virtual  long initialize();
    virtual void onGuiPolicyChanged(long);

    WSCbase* getPropertyEditor();
    WSCbase* getProcedureEditor();
    WSCbase* getDirTree();
    WSCbase* getClassList();
    WSCstring getSelectedClassName();
    void setLoadProjectHandler(void(*)(WSCinspector*,char*));

    void setClients(WSClistData*);
    void setSelectedClientList(WSClistData*);
    void updateList();
    WSCbase* getSelectedClient();
    void setGetDirHandler(void*);
    char* getSrcPath();
    void setEditorExecuteHandler(void*);
    WSCbase* getPopupMenuSelectedClient();
    WSCbase* getForm1();
    WSCbase* getForm2();
    WSCbase* getForm3();
    WSCbase* getForm4();
    WSCbase* getForm5();
    void setFormVisible(long no,WSCbool fl);
    WSCulong getFormVisible();
    void setSelectIndexTab(long no);
 
    void setForm4Client(WSCbase*);

    virtual long draw();

    WSMFguiClassDef(WSCinspector,WSCsform);
    WSMFversionDef(WSCinspector);
};
#endif
