//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#ifndef DEVFB_H
#define DEVFB_H

#ifdef UCLINUX
#define NO_THREAD
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef char           B;
typedef unsigned char  UB;
typedef unsigned char  Bool;
typedef short          H;
typedef unsigned short UH;
typedef unsigned short TC;
typedef int            W;
typedef int            GID;
typedef int            WID;
typedef int            ERR; 
typedef int            WERR; 
typedef int            PTRSTL; 
typedef int            ID; 
typedef int            TMOUT; 
typedef unsigned int   UW;
typedef unsigned int   DEG;

typedef char    VB;
typedef short   VH;
typedef int     VW;
typedef void*   VP;



typedef struct point{
  H x;
  H y;
} PNT;

typedef struct Size{
  H h;
  H v;
} SIZE;

typedef union rect {
  struct _rect {
    H   left;
    H   top;
    H   right;
    H   bottom;
  } c;
  struct {
    PNT lefttop;
    PNT rightbot;
  } p;
}RECT;

typedef struct  RectangleList{
  struct RectangleList *next;
  RECT rcomp;
}RLIST;

typedef struct Polygon{
  UH  round;
  UH  size;
  PNT pt[1];
} POLY;


typedef unsigned int COLOR;
typedef struct ColorSpec{
  W     attr;
  H     info[4];
  COLOR* colmap;
} CSPEC;

typedef struct Bitmap {
  UW    planes;
  UH    pixbits;
  UH    rowbytes;
  RECT  bounds;
  UB*   baseaddr[1];
} BMP;

typedef W PatKind;
typedef union pattern{
  struct spat {
    PatKind kind;
    UH      hsize;
    UH      vsize;
    COLOR   fgcol;
    COLOR   bgcol;
    UB*     mask;
  } spat;
  struct mpat{
    PatKind kind;
    UH      hsize;
    UH      vsize;
    UB*     mask;
    BMP*    bmap;
  } mpat;
  struct ipat{
    PatKind kind;
    UH      hsize;
    UH      vsize;
    UB*     pat;
  } ipat;
} PAT;

typedef struct HorizontalRegion{
  UH  nx;
  UH  x[1];
}HRGN;

typedef struct GenericRegion{
  RECT  r;
  UW    ns;
  struct{
    UW  y;
    HRGN* hp;
  } s[1];
} GRGN;


#define FILL0   ((UB*)1)
#define FILL12  ((UB*)2)
#define FILL25  ((UB*)3)
#define FILL50  ((UB*)4)
#define FILL75  ((UB*)5)
#define FILL87  ((UB*)6)
#define FILL100 ((UB*)7)

typedef struct ExtendFontSpecifier{
  TC   name[12];
  UW   fclass;
  UW   attr;
  SIZE size;
  W    _f;
} FSSPEC;


typedef struct wdstat{
  UW   attr;
  W    parent;
  W    pid;
  RECT r;
  RECT wr;
  RECT org;
} WDSTAT;

typedef struct {
  UW     frame;
  UW     tlbg;
  UW     barpat;
  UW     barbg;
  COLOR  tlcol;
} WDDISP;

typedef union {
  struct {
    UH  keytop;
    TC  code;
  } key;
  struct {
    H   kind;
    H   devno;
  } dev;
  W info;
} EVDATA;

typedef struct {
  W      type;
  UW     time;
  PNT    pos;
  EVDATA data;
  UW     stat;
} EVENT;


typedef struct SEVENT{
  W   type;
  UW  time;
  PNT pos;
  H   cmd;
  H   wid;
  UW  stat;
} SEVENT;

typedef struct REVENT{
  W     type;
  RECT  r;
  H     cmd;
  H     wid;
  W     src;
} REVENT;

typedef struct GEVENT{
  W type;
  H data[4];
  H cmd;
  H wid;
  W src;
} GEVENT;

typedef union _WEVENT {
  EVENT   e;
  SEVENT  s;
  REVENT  r;
  GEVENT  g;
} WEVENT;

typedef WEVENT WSDdeviceEvent;


#define WA_FRONT   0x00000001
#define WA_SUBW    0x00000002
#define WA_SIZE    0x00000004
#define WA_HHDL    0x00000008
#define WA_VHDL    0x00000010
#define WA_RBAR    0x00000020
#define WA_BBAR    0x00000040
#define WA_LBAR    0x00000080
#define WA_TITL    0x00000100
#define WA_BGDSP   0x00000200
#define WA_FULL    0x00000400
#define WA_SFULL   0x00000800
#define WA_POPUP   0x00008000
#define WA_NORMAL  0x0000007c

#define WA_STD     0x00000000
#define WA_WORK    0x00001000
#define WA_FRAME   0x00002000
#define WA_FMOVE   0x00004000
#define WA_GROUP   0x00010000
#define WA_THIN    0x00020000
#define WA_NOFRAME 0x00040000


#define EV_NULL     0
#define EV_BUTDWN   1
#define EV_BUTUP    2
#define EV_KEYDWN   3
#define EV_KEYUP    4
#define EV_AUTKEY   5
#define EV_DEVICE   6
#define EV_RSV      7
#define EV_SWITCH   8
#define EV_APPL1    8
#define EV_REQUEST  9
#define EV_APPL2    9
#define EV_APPL3    10
#define EV_MENU     10
#define EV_APPL4    11
#define EV_APPL5    12
#define EV_APPL6    13
#define EV_APPL7    14
#define EV_APPL8    15
#define EV_RSWITCH  16
#define EV_INACT    17
#define EV_MSG      18
#define EV_NOMSG    19

#define EM_NULL    0x0000
#define EM_ALL     0x7fff
#define EM_BUTDWN  0x0001
#define EM_BUTUP   0x0002
#define EM_KEYDWN  0x0004
#define EM_KEYUP   0x0008
#define EM_AUTKEY  0x0010
#define EM_DEVICE  0x0020
#define EM_RSV     0x0040
#define EM_APPL1   0x0080
#define EM_APPL2   0x0100
#define EM_APPL3   0x0200
#define EM_APPL4   0x0400
#define EM_APPL5   0x0800
#define EM_APPL6   0x1000
#define EM_APPL7   0x2000
#define EM_APPL8   0x4000

#define ES_BUT     0x00000001
#define ES_BUT2    0x00000002
#define ES_ALPH    0x00000004
#define ES_KANA    0x00000008
#define ES_LSHFT   0x00000010
#define ES_RSHFT   0x00000020
#define ES_EXT     0x00000040
#define ES_CMD     0x00000080
#define ES_LLSHFT  0x00000100
#define ES_LRSHFT  0x00000200
#define ES_LEXT    0x00000400
#define ES_LCMD    0x00000800
#define ES_TLSHFT  0x00001000
#define ES_TRSHFT  0x00002000
#define ES_TEXT    0x00004000
#define ES_TCMD    0x00008000
#define ES_HAN     0x00010000
#define ES_KBSEL   0x00020000
#define ES_NODSP   0x00200000
#define ES_PDSIM   0x00C00000

#define W_REDISP   0
#define W_PASTE    1
#define W_DELETE   2
#define W_FINISH   3
#define W_OPENED   5

#define W_WORK     0
#define W_FRAM     1
#define W_PICT     2
#define W_TITL     3
#define W_LTHD     4
#define W_RTHD     5
#define W_LBHD     6
#define W_RBHD     7
#define W_RBAR     8
#define W_BBAR     9
#define W_LBAR     10

#define W_PRESS    0
#define W_QPRESS   1
#define W_CLICK    2
#define W_DCLICK   3

#define W_NORM     0
#define W_FULL     1

#define W_SCRL     1

#define W_MOVE     0
#define W_MOVEC    1
#define W_HOLD     2

#define W_VALID    1
#define W_NOOVL    2
#define W_RDSET    4

#define W_SWITCH   128
#define W_CLOSED   129

#define DA_COLOR_MONO 0
#define DA_COLOR_RGB  1
#define DA_COLOR_CMY  2

#define G_CVFORM  0x0100
#define G_CVCOLOR 0x0200

#define PS_SELECT  0
#define PS_MODIFY  1
#define PS_MOVE    2
#define PS_VMOVE   3
#define PS_HMOVE   4
#define PS_GRIP    5
#define PS_VGRIP   6
#define PS_HGRIP   7
#define PS_RSIZ    8
#define PS_VRSIZ   9
#define PS_HRSIZ   10
#define PS_PICK    11
#define PS_VPICK   12
#define PS_HPICK   13
#define PS_BUSY    14
#define PS_MENU    15

typedef struct PointerStatus{
  PNT    pos;
  PTRSTL style;
  COLOR  fgcol;
  COLOR  bgcol;
  W      motion;
  W      hidden;
  W      size;
} PTRSTS;

typedef struct  {
  H attr;
  H planes;
  H pixbits;
  H hpixels;
  H vpixels;
  H hres;
  H vres;
  H color[4];
  H resv[6];
}DEV_SPEC;


#define E_OK   0

#define CLR     0x0000
#define NOCLR   0x0008
#define DELEXIT 0x8000

#define WAIT    0x0000
#define NOWAIT  0x0001
#define NOMSG   0x0010
#define RAWEVT  0x0020
#define DRGEVT  0x0030
#define MSG     0x0040
#define DSPEVT  0x0050

#define G_STORE 0
#define G_XOR   1
#define G_OR    2
#define G_AND   3
#define G_CPYN  4
#define G_XORN  5
#define G_ORN   6
#define G_ANDN  7
#define G_NOP   8


#define WI_GENERAL             200
//#define WI_FRAMESIZE   (WI_GENERAL + 0)
#define WI_WORKSIZE    (WI_GENERAL + 1)
#define WI_WINLIST     (WI_GENERAL + 2)
#define WI_FRONTLIST   (WI_GENERAL + 3)
//#define WI_MSGSTR      (WI_GENERAL + 4)
//#define WI_MENUSTR     (WI_GENERAL + 5)
//#define WI_ATTRGID     (WI_GENERAL + 6)
//#define WI_BELLREQ     (WI_GENERAL + 50)
//#define WI_NODRAGBREAK (WI_GENERAL + 51)

#define LN_SOLID  0
#define LN_DASH   1
#define LN_DOT    2
#define LN_DDASH  3
#define LN_DDDASH 4
#define LN_LDASH  5
#define LN_MASK   255


typedef union {
  struct{
    W   pid;
    W   code;
  } ABORT;
  struct{
    W   pid;
    W   code;
  } EXIT;
  struct{
    W   pid;
    W   code;
  } TERM;
  struct{
    W   code;
  } TMOUT;
  struct{
    W   code;
  } SYSEVT;
  struct{
    UB  msg_str[32];
  } ANYMSG;
} MSGBODY;

typedef struct message{
  W       msg_type;
  W       msg_size;
  MSGBODY msg_body;
} MESSAGE;

typedef struct {
  UW state;
  W  priority;
  W  parpid;
} P_STATE;


#define MS_TYPE0 (24)
#define MS_TYPE1 (25)
#define MS_TYPE2 (26)
#define MS_TYPE3 (27)
#define MS_TYPE4 (28)
#define MS_TYPE5 (29)
#define MS_TYPE6 (30)
#define MS_TYPE7 (31)

#define MM_TYPE0  (1 << (MS_TYPE0 -1))
#define MM_TYPE1  (1 << (MS_TYPE1 -1))
#define MM_TYPE2  (1 << (MS_TYPE2 -1))
#define MM_TYPE3  (1 << (MS_TYPE3 -1))
#define MM_TYPE4  (1 << (MS_TYPE4 -1))
#define MM_TYPE5  (1 << (MS_TYPE5 -1))
#define MM_TYPE6  (1 << (MS_TYPE6 -1))
#define MM_TYPE7  (1 << (MS_TYPE7 -1))

#define SEM_SYNC  0x0000
#define SEM_EXCL  0x4000
#define T_NOWAIT       0
#define T_FOREVER      (-1)
#define HBUFLEN       64


//WSDdevfbSocket
extern ERR  sig_sem( ID id );
extern ERR  wai_sem( ID id, TMOUT tmo );
extern ERR  cre_sem( W cnt, UW opt );
extern ERR  del_sem( ID id );

//WSDdevfbWinDev..
extern WID wopn_wnd(UW attr, UW par, RECT* r, RECT* org, W pict, TC* tit, PAT* bgpat, WDDISP* atr);
extern ERR wcls_wnd(W wid, W opt);
extern W   wmov_wnd(W wid, RECT* r);
extern W   wrsz_wnd(W wid, RECT* r);
extern ERR wget_wrk(W wid, RECT* r);
extern W   wsta_dsp(W wid, RECT* r, RLIST* rl);
extern W   wend_dsp(W wid);
extern ERR wset_tit(W wid, W pict, TC* title, W mode);
extern ERR wset_bgp(W wid, PAT* pat);
extern WID wget_act(W* pid);
extern ERR wget_dat(W wid, W* dat);
extern ERR wset_dat(W wid, W dat);

extern GID wget_gid(W wid);
extern ERR gcls_env(GID gid);
extern ERR gget_for(GID gid, RLIST* rl);
extern ERR gset_ptr(PTRSTL s, void* img, COLOR fgc, COLOR bgc);
extern ERR gset_vis(GID gid, RECT r);
extern ERR gcop_bmp(GID sid, RECT* sr, GID did, RECT* dr, GRGN* mask, W mode);

//WSDdevfbFormDev
extern W   wget_sts(W wid, WDSTAT* stat, WDDISP* atr);
extern W   wget_inf(W item, VP buf, W size);
extern W   wcnv_rec(UW attr, RECT* r, UW opt);
extern ERR gset_for(GID gid, RLIST* rl);
extern ERR gfil_rec(GID gid, RECT r, PAT* pat, DEG ang, W mode);
extern ERR gcnv_rel(GID gid, PNT* pp);
extern ERR gcnv_abs(GID gid, PNT* pp);

//WSDdevfbAppDev
extern WERR prc_sts(W pid, P_STATE* buff, TC* path);
extern WERR rcv_msg(W mask, MESSAGE* msg, W size, W opt);
extern W    wget_evt(WEVENT* evt, W mode);
extern W    wchk_dck(UW first);
extern W    wchg_wnd(W wid, RECT* r, W mode);
extern W    wrsz_drg(WEVENT* evt, RECT* limit, RECT* r);
extern W    wscr_wnd(W wid, RECT* r, W dx, W dy, W mode);
extern WERR chg_emk(W mask);
extern WERR gget_dsp(W gid, DEV_SPEC* dspec);
extern WERR gget_csp(W gid, CSPEC* cspec);
extern WERR gget_col(GID gid, UW p, COLOR* cv, UW cnt);
extern GID  gopn_mem(TC* dev, BMP* bmap, B* par);
extern W    wmov_drg(WEVENT *evt, RECT *r);

//WSDdevfbDraw
extern ERR  gfra_ovl(GID gid, RECT r, W attr, PAT *pat, DEG ang, W mode);
extern ERR  gfil_ovl(GID gid, RECT r, PAT *pat, DEG ang, W mode);
extern ERR  gdra_arc(GID gid, RECT r, PNT sp, PNT ep, W attr, PAT *pat, DEG ang, W mode);
extern ERR  gfra_sec(GID gid, RECT r, PNT sp, PNT ep, W attr, PAT *pat, DEG ang, W mode);
extern ERR  gfil_sec(GID gid, RECT r, PNT sp, PNT ep, PAT *pat, DEG ang, W mode);
extern ERR  gfil_cho(GID gid, RECT r, PNT sp, PNT ep, PAT *pat, DEG ang, W mode);
extern ERR  gdra_lin(GID gid, PNT p1, PNT p2, W attr, PAT *pat, W mode);
extern ERR  gfra_rec(GID gid, RECT r, W attr, PAT* pat, DEG ang, W mode);
extern ERR  gfil_rec(GID gid, RECT r, PAT* pat, DEG ang, W mode);
extern ERR  gfra_pol(GID gid, POLY* p, W attr, PAT *pat, W mode);
extern ERR  gfil_pol(GID gid, POLY* p, PAT *pat, W mode);
extern ERR  gset_fon(GID gid, FSSPEC* fnt);
extern ERR  gset_chp(GID gid, W x, W y, Bool absolute);

//WSDdevfbFont
//extern WERR fopn_fon(void);
extern ERR  fset_fon(W fdesc, FSSPEC* spec);
extern ERR  fcls_fon(W fdesc);

//WSdevfbcom
extern WERR gdra_str(GID gid, TC* str, W len, W mode);
extern ERR  gset_chc(GID gid, COLOR fgc, COLOR bgc);
extern WERR gget_stw(GID gid, TC* str, W len, void* gap, W* pos);

//WSDdevfbMouse
extern WERR gget_ptr(PTRSTS* sts, void* img);
extern W    wfnd_wnd(PNT* gpos, PNT* lpos, W* wid);

//WSDdevfbPrivateTimer
extern ERR  wai_prc(W time);
extern WERR get_tid(void);
extern ERR  snd_msg(W pid, MESSAGE *msg, W opt);
extern void ext_tsk(void);
extern WERR cre_tsk(void (*entry)(W), W pri, W arg);
extern ERR ter_tsk(W tskid);

#ifndef WS_NO_ERR
#define WS_NO_ERR   0
#endif

#ifndef WS_ERR
#define WS_ERR     -1
#endif

#define EX_NOSPC   -2
#define WS_ERR_NOSPC   -2
#define EX_ADR     -3
#define EG_ADR     -3
#define WS_ERR_ADR     -3
#define EX_WID     -4
#define WS_ERR_WID     -4
#define EX_WPRC    -5
#define WS_ERR_WPRC    -5
#define EX_WND     -6
#define WS_ERR_WND     -6
#define ER_PAR     -7
#define EG_PAR     -7
#define WS_ERR_PAR     -7

#define EG_GID     -8
#define WS_ERR_GID     -8
#define EX_NOMEM   -9
#define WS_ERR_NOMEM   -9

#ifdef __cplusplus
};
#endif

#define DEVFB_WHITE 0xffffffff
#define DEVFB_BLACK 0xff000000

#endif
