//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#if !defined(_tpolygon_h)
#define _tpolygon_h

#include  "vertex.h"

struct  Polygon3D {
    int  color;
    int  n;
    double reflection;
    double ambient;
    int  f_normal;
    Vector_d    normal;
    Vector_d    enormal;
    long off_center;
    int  *index;
};

class  TPolygons {
    int  Max;
    int  Count;
    double reflection;
    double ambient;
    long off_center;

  public:
    TVertex   Vertex;
    Polygon3D **pg;

    TPolygons(int vn, int pn);
    ~TPolygons();
    int  GetCount() { return Count; };
    void Add(int n, int color, const int *idx);

    void SetPoly(int pos, int color, const int *idx);

    void GetPoly(int pos, int &color, int *idx);

    int  GetVertexCount(int pos);

    void SetReflection(double ref) { reflection = ref; }

    void SetAmbient(double amb) { ambient = amb; }

    void SetCenterGrav(long cg) { off_center = cg; }

};

#endif
