//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDUNIXFILE_H
#define WSDUNIXFILE_H

#include <WSDfile.h>
#include <WSCmfile.h>

class WSDunixFile :public WSDfile{

protected:
  FILE*   _fp;
  WSCmfile* _mfp;

public:
  virtual long    open(char* name,char* mode);
  virtual long    close();
  virtual long    read(void*,long len);
  virtual long    write(void*,long len);
  virtual WSCbool eof();
  virtual long    seek(long addr);
  virtual long    seekSet();
  virtual long    seekEnd();
  virtual long    getSize();
  virtual long    tell();

  WSDunixFile();
  virtual ~WSDunixFile();

  WSMFclassDef(WSDunixFile,WSDfile);

};
extern WSDLEX void WSGFinitializeUnixFile();
#endif
