//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from  
// Toshikaz Hirabayashi.

#ifndef WSCBASELIST_H
#define WSCBASELIST_H

#include <WScom.h>
#include <WSCstring.h>
#include <WSClistData.h>
#include <WSCRroot.h>
#include <WSCRbase.h>

class WSCbase;
//class WSClistData;
class WSCremoteInstanceData{
  public:
    WSCstring _addr;
    WSCushort _port;
    WSCstring _public_instance_name;
    WSCstring _instance_name;
    WSCstring _class_name;

    WSCremoteInstanceData();
    ~WSCremoteInstanceData();

    void setPublicInstanceName(char*);
    void setInstanceName(char*);
    void setClassName(char*);
    void setAddr(char*);
    void setPort(WSCushort);

    WSCstring getPublicInstanceName();
    WSCstring getInstanceName();
    WSCstring getClassName();
    WSCstring getAddr();
    WSCushort getPort();

};

class WSCbaseList{

 private:
  void*         _search_handler;
  WSClistData*  _base_list;
  WSClistData*  _need_update;
  WSClistData*  _need_init;
  WSClistData   _event_list;
  WSClistData   _event_client_list;
  WSClistData   _remote_instance_list;
  WSClistData   _export_instance_list;
  WSClistData   _export_instance_update_list;
  WSClistData   _export_instance_delete_list;
  WSCbool       _remote_data_list_updated;

 public:
  WSCbaseList();
  virtual ~WSCbaseList();

  WSCbase* getInstance(char* class_name,char* objname);
  WSClistData* getClassList();

  void addClient(WSCbase*,void* bases = NULL);
  void delClient(WSCbase* ,void* bases = NULL);

  long countObject(char* );
  void addNeedUpdate(WSCbase*);
  void addNeedInitialize(WSCbase*);
  void execUpdate();
  void execInitialize();
  void  setUserData(char*,void *);
  void* getUserData(char*);

  WSClistData* getInstanceList(char*);
  WSCRbase*    getRemoteInstance(char*);

  void         setSearchInstanceHandler(void*);
  WSCbase*     searchInstance(char* class_name,char* objname);
  WSCbool      existInstance(WSCbase*);
  void     addEvent(WSCbase*,long ev = WSEV_NONE);
  void     delEvent(WSCbase*,long ev = WSEV_NONE);
  void     execEvent(long,void*);
  void     execEvent(long);
  void     execEvent(char*);

  long     addRemoteInstanceData(WSCremoteInstanceData* idata);
  long     delRemoteInstanceData(WSCremoteInstanceData* idata);
  WSCbool  getRemoteInstanceListUpdated();
  void     setRemoteInstanceListUpdated(WSCbool);


  long     addExportInstanceList(WSCbase* inst);
  long     delExportInstanceList(WSCbase* inst);
  long     addExportInstanceUpdateList(WSCbase* inst);
  long     delExportInstanceUpdateList(WSCbase* inst);

  long     addExportInstanceDeleteList(WSCbase* inst);
  long     delExportInstanceDeleteList(WSCbase* inst);


  WSClistData* getExportInstanceDeleteList();
  WSClistData* getExportInstanceUpdateList();
  WSClistData* getExportInstanceList();

  WSCremoteInstanceData*  getRemoteInstanceData(char* pname);
  WSClistData* getRemoteInstanceList();

};

extern WSDLEX WSCbaseList* WSGIappObjectList();
#endif
