//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCOPTION_H
#define WSCOPTION_H

#include <WScom.h>
#include <WSCvlabel.h>

class WSCpopupFrame;

#define WSCoption_VER  1000

class WSCoption    :public WSCvlabel{

  protected:
    WSCpopupFrame* _menu;
    WSCbool* _status_array;
    char*    _menu_str;
    long     _value;
    unsigned _press_state:1;

    WSMFpropertyDef( WSNmenuItems, char*, _menu_str); 
    WSMFpropertyDef( WSNvalue,     long,  _value); 
    //menu items = string:value:op name,
    //             string:value:op name,...

    virtual void setWorkWSNemboss(WSCbool);
    virtual void setWorkWSNshadowThickness(WSCuchar);

    virtual long _device_initialize();

    void _menu_popup(WSCpoint*);
    void _menu_popdown();
    void _menu_update();

  public:
    WSCoption(WSCbase*,char*);
    virtual ~WSCoption();

    virtual long initialize();
    virtual long draw();
    virtual long addProcedure(WSCprocedure*);

    virtual void onActivate();
    virtual void onMousePress(WSCpoint*);
    virtual void onMouseMove(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onParentVisibleChange(WSCbool);
    virtual void onVisibleChange(WSCbool);
    virtual void onValueChange(long);


    long setItemSensitive(short no, WSCbool flag);
    long setSelectValue(long value, WSCbool flag);

    long     getValue();
    long     getItemValue(long pos);
    WSCbool* getSelectStatus();
    long     getItemNum();
    long     getItems();

    WSMFguiClassDef(WSCoption,WSCvlabel);
    WSMFversionDef(WSCoption);
};
#endif
