//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCPULLDOWNMENUPOPUP_H
#define WSCPULLDOWNMENUPOPUP_H

#include <WScom.h>
#include <WSCwindow.h>
#include <WSCstring.h>
#include <WSDkeyboard.h>

class WSCpulldownMenuPopup    :public WSCwindow{

  protected:
    WSCpulldownMenuPopup* _popup;
    WSCpulldownMenuPopup* _parent_pld_menu;
    void*            _pld_data;
    char*            _menu_string;
    WSCushort        _item_height;
    WSCstring        _prc_name;
    long             _id_value;
    WSClistData      _child_pld_list;
    signed char             _selected_item;
    char             _items;
    unsigned         _font:4;
    unsigned         _selected:1;
    unsigned         _next_popup:1;
    unsigned         _emboss:1;
    unsigned         _mouse_no_check:1;
    unsigned         _wait_child_popup:1;
    unsigned         _child_popup_waited:1;

    //menu string = string:prcname:short cut key:value,
    //              string:prcname:short cur key;value,
    //              leveldown:{
    //                string:prcname:short cur key;value,
    //                string:prcname:short cur key;value
    //              },
    //              string:prcname:short cur key;value,

    WSMFpropertyDef( WSNfont,           WSCuchar,  _font       );
    WSMFpropertyDef( WSNmenuItems,      char*,     _menu_string); 
    WSMFpropertyDef( WSNmenuItemHeight, WSCushort, _item_height); 

    virtual void setWorkWSNwidth(WSCushort);
    virtual void setWorkWSNheight(WSCushort);
    virtual void setWorkWSNemboss(WSCbool);

    virtual long _device_initialize();

    void popupChildPld(short childno,char* menustr, short x, short y);
    void popdownChildPld(short childno);
    void updateChild();
    WSCbool checkChildStatus();
    WSCpulldownMenuPopup* _check_child_status_no_mouse();

  public:
    WSCpulldownMenuPopup(WSCbase*,char*);
    virtual ~WSCpulldownMenuPopup();

    virtual void onVisibleChange(WSCbool);
    virtual void onResize(WSCrect*);
    virtual void onKeyPress(WSDkeyboard*,WSCbool);

    virtual long initialize();
    virtual long draw();

    void setEmboss(WSCbool);
    long setItemSensitive(short no,WSCbool flag);    
    long setValueSensitive(short id,WSCbool flag);    
    void setParentMenu(WSCpulldownMenuPopup*);

    WSCpulldownMenuPopup* getParentMenu();
    WSCushort getItemHeight();
    WSCuchar  getFontNo();
    long      getItems();
    char*     getProcName();
    WSCbool   getSelected();
    WSCbool   getNextPopup();
    WSCbool   getEmboss();
    WSCbool*  getItemSensitive();
    long      getValue();
    void   setSelected(WSCbool);

    WSMFguiClassDef(WSCpulldownMenuPopup,WSCwindow);
};
#endif
