//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVCSOCKET_H
#define WSCVCSOCKET_H

#include <WScom.h>
#include <WSCngbase.h>
#define WSCvcsocket_VER  1000
#include <WSDsocket.h>

class WSCvcsocket   :public WSCngbase{
  protected:
    WSDsocket*  _socket;
    char*     _addr;
    WSCushort _port; 
    WSCulong _timeout;
    WSCstring _bind_addr;
    WSCstring _error_str;

    WSMFpropertyDef(WSNip,        char*,      _addr);
    WSMFpropertyDef(WSNport,      WSCushort,      _port);
    WSMFpropertyDef(WSNtimeout,   WSCulong,      _timeout);
    void _init();

  public:

    WSCvcsocket(WSCbase* base, char* name);
    virtual ~WSCvcsocket();
    virtual void onActivate();
    long read(WSCuchar* buf,long size);
    long write(WSCuchar* buf,long size);

    long exec();
    WSDsocket* getSocket();

    void setBindAddr(char*);
    WSCstring getBindAddr();

    void getErrorMsg(char* msg,long size);
    WSCstring getErrorMessage();

    WSMFguiClassDef(WSCvcsocket,WSCngbase);
    WSMFversionDef(WSCvcsocket);
};

#endif //WSCVCSOCKET_H
