//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDXDRAW_H
#define WSDXDRAW_H

#include <X11/Xlib.h>
#include <WScom.h>
#include <WSDdraw.h>
#include <WSClistData.h>
#include <WSDdev.h>

class WSCbase;

class WSDxdraw :public WSDdraw{

  protected:
    Window   _window;
    Display* _display;
    GC       _gc;
    WSDdev*  _dev;
    WSCulong _fg_color;
    WSCulong _bg_color;
    short    _line_width;
    signed char     _line_type;
    WSCbool  _clipping;

  public:
    WSDxdraw();
    virtual ~WSDxdraw();

    virtual long setForeColor(short cid);
    virtual long setBackColor(short cid);
    virtual long setForeColor(WSDcolor*);
    virtual long setBackColor(WSDcolor*);
    virtual long setLineWidth(short);
    virtual long setLineDashType(char no);
    virtual long setHatchPattern(char no);
    virtual long setRegion(short x,short y,WSCushort w,WSCushort h);
    virtual long beginDraw(WSDdev*,long prm1,long prm2,long prm3);
    virtual long endDraw();
    virtual long drawArc(short x,short y,WSCushort width,WSCushort height,short a1,short a2);
    virtual long drawFillArc(short x,short y,WSCushort width,WSCushort height,short a1,short a2,char kind);
    virtual long drawLine(short x1,short y1,short x2,short y2);
    virtual long drawLines(WSCpoint*,long num);
    virtual long drawRect(short x,short y,WSCushort w,WSCushort h);
    virtual long drawFillRect(short x,short y,WSCushort w,WSCushort h);
    virtual long drawRects(WSCrect*,long num);
    virtual long drawGradation(long type,short col1,short col2,short col3,
                         short x,short y,WSCushort w,WSCushort h,WSCuchar);
    virtual long drawFillRects(WSCrect*,long num);
    virtual long drawPoly(WSCpoint*,long num);
    virtual long drawFillPoly(WSCpoint*,long num);
    virtual long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
    virtual long drawImage(short x,short y,short sx,short sy,WSCushort,WSCushort,WSDimage*);
    virtual long drawStretchedImage(short x,short y,WSCushort w,WSCushort h,
                                    WSDimage*);

    virtual long drawString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                            char font,char align,long cur,WSCbool inter_cur,
                            long scur1 = 0,long scur2 = 0);

    virtual long drawUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                             char font,char align,long cur,WSCbool inter_cur,
                             long scur1 = 0,long scur2 = 0);

    virtual long drawFillString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                                char font,char align,short cur,WSCbool inter_cur);

    virtual long drawFillUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                                 char font,char align,short cur,WSCbool inter_cur);

     WSMFclassDef(WSDxdraw,WSDdraw);
};
#endif
