#include <WSCstring.h>
#include <WSCodbcDatabase.h>

#include "newwin000.h"

static char dsn[80];
static char uid[80];
static char psw[80];
WSCbool connected = False;
extern WSCvodbc* newvodb_000;

void setChar(char* str, long len, char ch);

void app_init()
{
  memset(dsn, '\0', sizeof(dsn));
  memset(uid, '\0', sizeof(uid));
  memset(psw, '\0', sizeof(psw));
}
long db_connect()
{
  WSCstring cout;
  long ret = newdial_001->popup();
  if(ret == WS_DIALOG_OK){
    strcpy(dsn, (char*)newvifi_003->getProperty(WSNlabelString));
    strcpy(uid, (char*)newvifi_006->getProperty(WSNlabelString));
    strcpy(psw, (char*)newvifi_000->getProperty(WSNlabelString));
    if(newvodb_000->isOpen()) {
      newvodb_000->close();
    }
    if(newvodb_000->open(dsn, uid, psw) == WS_ERR) {
      connected = False;
      dsn[0] = '\0';
      char szErrorMsg[SQL_MAX_MESSAGE_LENGTH + 1];
      newvodb_000->getErrorMsg(szErrorMsg,SQL_MAX_MESSAGE_LENGTH);
      cout << szErrorMsg << "\n";
    } else {
      connected = True;
      cout << "connect ok\n";
    }
  }
  newtext_004->setProperty(WSNlabelString, cout);
  return ret;
}

void db_init()
{
	char buf1[512];
	if(dsn[0] == '\0') {
		if(db_connect() != WS_DIALOG_OK) {
			return;
		}
	}

	strcpy(buf1, "drop table shinamono");
	long ret = newvodb_000->sqlExecute(buf1);
  
	strcpy(buf1, "create table shinamono(code int, hinmei char(20), nedan float)");
	newvodb_000->sqlExecute(buf1);

	newvodb_000->beginTran();
	strcpy(buf1, "insert into shinamono values(1, 'ߤ', 100)");
	newvodb_000->sqlExecute(buf1);
	strcpy(buf1, "insert into shinamono values(2, '', 200)");
	newvodb_000->sqlExecute(buf1);
	strcpy(buf1, "insert into shinamono values(3, 'Хʥ', 300)");
	newvodb_000->sqlExecute(buf1);
	strcpy(buf1, "insert into shinamono values(4, '', 0)");
	newvodb_000->sqlExecute(buf1);

	newvodb_000->commitTran();

    newtext_004->setProperty(WSNlabelString, "create ok\n");
}

void sqltest()
{
	char buf1[512];

	if(dsn[0] == '\0') {
		if(db_connect() != WS_DIALOG_OK) {
			return;
		}
	}
        if(connected == False){
                if(db_connect() != WS_DIALOG_OK) {
                        return;
                }
        }

	WSCodbcRecord rs(newvodb_000);

	WSCvariant var;
	WSCstring cout;
	WSCstring cout1;

	newvodb_000->beginTran();

	cout1 << "select * from shinamono order by code" << "\n";
	
	if(rs.open("select * from shinamono order by code") == WS_NO_ERR) {
		while (!rs.isEOF()) {
			rs.getColValue("code", &var);
			int code = (int)var;
			cout << "code:" << (int)var << " ";
			rs.getColValue("hinmei", &var);
			cout << "hinmei:" << (char*)var << " ";
			rs.getColValue("nedan", &var);
			char buf[80];
			double nedan = (float)var + 10;

			sprintf(buf, "%f", (float)var);
			cout << "nedan:" << buf << "\n";

			if(nedan != 0) {
				sprintf(buf1, "update shinamono set nedan = %f where code = %d", nedan, code);
			} else {
				sprintf(buf1, "delete from shinamono where code = %d", code);
			}

			cout1 << buf1 << "\n";
			
			newvodb_000->sqlExecute(buf1);

			rs.moveNext();
		}
	}
	rs.close();
	
	newvodb_000->commitTran();


	if(cout[0] == '\0') {
      char szErrorMsg[SQL_MAX_MESSAGE_LENGTH + 1];
      newvodb_000->getErrorMsg(szErrorMsg,SQL_MAX_MESSAGE_LENGTH);
      cout << szErrorMsg << "\n";
	}
	newtext_003->setProperty(WSNlabelString, cout1);
	newtext_004->setProperty(WSNlabelString, cout);
}
void sql_execute()
{
	char buf1[512];
	char buf2[256];

	strcpy(buf1, (char*)newtext_003->getProperty(WSNlabelString));
	if(buf1[0] == '\0') {
		return;
	}
	if(dsn[0] == '\0') {
		if(db_connect() != WS_DIALOG_OK) {
			return;
		}
	}
        if(connected == False){
                if(db_connect() != WS_DIALOG_OK) {
                        return;
                }
        }

	WSCodbcRecord rs(newvodb_000);

	char var[256];
	WSCstring cout;

	newvodb_000->beginTran();

	if(rs.open(buf1) == WS_NO_ERR) {
		buf1[6] = '\0';
		if(WSGFstricmp(buf1, "select") != 0) {
			rs.open("select * from shinamono order by code");
		}
		int i;
		memset(buf1, '\0', sizeof(buf1));
		memset(buf2, '\0', sizeof(buf2));
		for(i = 0; i < rs.getColCount(); i++) {
			rs.getColName(i, buf2);
			setChar(buf2, rs.getColLength(i), ' ');
			strcat(buf1, buf2);
			strcat(buf1, " ");
		}
		cout << buf1 << "\n";
		buf1[0] = '\0';
		for(i = 0; i < rs.getColCount(); i++) {
			buf2[0] = '\0';
			setChar(buf2, rs.getColLength(i), '-');
			strcat(buf1, buf2);
			strcat(buf1, "+");
		}
		cout << buf1 << "\n";
		while (!rs.isEOF()) {
			buf1[0] = '\0';
			for(int i = 0; i < rs.getColCount(); i++) {
				rs.getColStringValue((long)i, var);
				setChar(var, rs.getColLength(i), ' ');
				cout << var << " ";
			}
			cout << "\n";

			rs.moveNext();
		}
	}
	rs.close();

	newvodb_000->commitTran();


	if(cout[0] == '\0') {
      char szStat[6];
      char szErrorMsg[SQL_MAX_MESSAGE_LENGTH + 1];
      newvodb_000->getErrorMsg(szErrorMsg,SQL_MAX_MESSAGE_LENGTH);
      cout << szErrorMsg << "\n";
	}

	newtext_004->setProperty(WSNlabelString, cout);
}
void dbclose()
{
	newvodb_000->close();
}
void setChar(char* str, long len, char ch)
{
	for(int i = strlen(str); i < len; i++) {
		str[i] = ch;
	}
	str[len] = '\0';
}
