//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCbase.h>
#include <WSCbaseList.h>
#include <WSCclassInformation.h>
#include <WSCgripHand.h>
#include <WSDdev.h>
#include <WSDappDev.h>
#include <WSCdevice.h>
#include <WSCfunctionList.h>
#include <WSDmouse.h>
#include <WSCvariant.h>
#include <WSCindexVariantData.h>

WSMFclassInit(WSCbase,WSCroot);

//#define TDBG

#ifdef MEMDBG
WSClistData* memlist = NULL;
long memflg = 0;
void* operator new(unsigned int size){
  void* ptr = malloc(size);
//printf("operator ::new %d  ptr=0x%x\n",size,ptr);
  if (memflg == 0){
    memflg = 1;
    memset(ptr,0,size);
    if (memlist == NULL){
      memlist = new WSClistData(64);
    }
    memlist->add(ptr);
//printf("new mem cnt=%d\n",memlist->getNum());
    memflg = 0;
  }
  return ptr;
};

void operator delete(void* ptr){
//printf("operator delete 0x%x\n",ptr);
  if (memflg == 0){
    memflg = 1;
    if (memlist != NULL){
      long ret = memlist->del(ptr);
      if (ret == -1){
assert(0);
fprintf(stderr,"memfree error...\n");
      }
    }
printf("del mem cnt=%d\n",memlist->getNum());
    memflg = 0;
  }
  free(ptr);
};
void operator delete[](void* ptr){
//printf("operator delete 0x%x\n",ptr);
  if (memflg == 0){
    memflg = 1;
    if (memlist != NULL){
      long ret = memlist->del(ptr);
      if (ret == -1){
assert(0);
fprintf(stderr,"memfree error...\n");
      }
    }
printf("del mem cnt=%d\n",memlist->getNum());
    memflg = 0;
  }
  free(ptr);
};


#endif


//speedy strcmp
inline long WSGFstrcmp(char* x,char* y){
  register WSCuchar* str1 = (WSCuchar*)x;
  register WSCuchar* str2 = (WSCuchar*)y;
  register WSCuchar ptr1 = 0;
  register WSCuchar ptr2 = 0;
  do{
    ptr1 = (WSCuchar)*str1++;
    ptr2 = (WSCuchar)*str2++;
    if (ptr1 == 0){
      return ptr1 - ptr2;
    }
  }while(ptr1 == ptr2);
  return ptr1 - ptr2;
}

WSCbase* WSCbase::_focus_instance = NULL;
WSCbase* WSCbase::_special_focus_instance = NULL;
WSCushort WSCbase::_grid_x = 1;
WSCushort WSCbase::_grid_y = 1;
WSClistData* WSCbase::_create_proc_list = NULL;
WSClistData* WSCbase::_cname_list = NULL;

WSCbase::WSCbase(WSCbase* parent,char* object_name){
WSMFtrace("WSCbase::WSCbase object_name=#%s# 0x%x\n",object_name,object_name);
  _variant_list = NULL;
  _own_class_info = NULL;
  _prc_list = NULL;
  _instance_name = WSGFstrdup(object_name);
  _dev = NULL;
  _dev_public = NULL;
  _parent = parent;
  _data_source_server = NULL;
  _data_source_clients = NULL;
  _user_data_name_list = NULL;
  _user_data_list = NULL;
  _scale_ptrs = NULL;
  _event_mask =0;
  _num_of_user_data = 0;
  _name_hash_value = WSGFgetHashValue(object_name);
  _absolute_draw = False;
  _show_grip_hand = False;
  _init_registered = False;
  _update_registered = False;
  _vis = False;
  _vis_bk = False;
  _parent_vis = False;
  _parent_vis_init = False;
  _sensitive = True;
  _parent_sensitive = True;
  _parent_sensitive_init = False;
  _property_edit_mode = False;
  _internal_object = False;
  _geometry_changed = False;
  _expose_op = 0;
  _initialized = 0;
  _use_parent_base_dev = False;
  _dev_is_public_dev = False;
  _no_clear = False;
  _export_ = False;
  _export_bk = False;
}

WSCbase::~WSCbase(){
  if (_export_ != False){
    WSGIappObjectList()->addExportInstanceDeleteList(this);
    _export_ = False;
  }
  if (_special_focus_instance == this){
    _special_focus_instance = NULL;
  }
  setFocus(False);
  _exec_del_procedure();
  if (_own_class_info != NULL){
    WSGIappObjectList()->delClient(this,
                             _own_class_info->getClassInstanceList());
  }
  WSClistData* ghlist = (WSClistData*)getUserData("GH-LIST");
  if (ghlist != NULL){
    delete ghlist;
  }
//  clearGriphand();

  WSCbase* client = NULL;
  WSCbase* prop_editor = WSGIappPropertyEditor();
  if (prop_editor != NULL && prop_editor != this){
    prop_editor->getPropertyV(WSNclient,(void**)&client);
//printf("WSCbase::~WSCbase prope cl=0x%x this=0x%x\n",client,this);
    if (client == (WSCbase*)this){
      client = NULL;
      prop_editor->setUserData("PCLIENT",(void*)NULL);
      prop_editor->setPropertyV(WSNclient,(void*)client);
    }
  }

  WSCbase* parent = getParent();
  if (parent != NULL){
    WSClistData* list = (WSClistData*)parent->getUserData("FOCUS_LIST");
    if (list != NULL){
      list->del(this);
    }
  }
  WSClistData* list = (WSClistData*)getUserData("FOCUS_LIST");
  if (list != NULL){
    delete list;
    setUserData("FOCUS_LIST",(void*)0);
  }
//printf("WSCbase::~WSCbase  delete dev...  %s\n",getInstanceName());
  if (_dev != NULL){
//    delete _dev;
    _dev->deleteInstance();
  }
  if (parent != NULL){
    parent->delChild(this);
    setParent(NULL);
  }
  if( _scale_ptrs != NULL){
    delete _scale_ptrs;
    _scale_ptrs = NULL;
  }
  long i;
  if (_num_of_user_data != 0){
    for(i=0; i< _num_of_user_data; i++){
      delete _user_data_name_list[i];
    }
    delete _user_data_name_list;
    delete _user_data_list;
  }

  if (_data_source_clients != 0){
    long cnum = _data_source_clients->getNum();
    for(i=0; i< cnum; i++){
      WSCbase* client = (WSCbase*)_data_source_clients->getData(i);
      client->setDataSourceServer(NULL);
    }
    delete _data_source_clients;
    _data_source_clients = NULL;
  }
  if ( getDataSourceServer() != NULL){
    getDataSourceServer()->delDataSourceClient(this);
    setDataSourceServer(NULL);
  }

  if (_prc_list != NULL){
    i=0;
    while(_prc_list[i] != NULL){
      WSCprocedure* op = (WSCprocedure*)_prc_list[i];
      delete op;
      i++;
    }
    delete _prc_list;
  }
  if (_variant_list != NULL){
    _variant_list->clear();
    delete _variant_list;
    _variant_list = NULL;
  }
  delete _instance_name;
}
WSClistData* WSCbase::getDataSourceClients(){
  return _data_source_clients;
}
void WSCbase::addDataSourceClient(WSCbase* client){
  if (_data_source_clients == NULL){
    _data_source_clients = new WSClistData();
  }
  long i;
  long num = _data_source_clients->getNum();
  for(i=0; i<num; i++){
    WSCbase* item = (WSCbase*)_data_source_clients->getData(i);
    if (item == client){
      return;
    }
  }
  _data_source_clients->add((void*)client);
}
void WSCbase::delDataSourceClient(WSCbase* client){
  if (_data_source_clients == NULL){
    return;
  }
  _data_source_clients->del((void*)client);
}
WSCbase* WSCbase::getDataSourceServer(){
  return _data_source_server;
}
void WSCbase::setDataSourceServer(WSCbase* dserv){
  _data_source_server = dserv;
}
void WSCbase::setDataToDataSourceClients(WSCvariant* data){
  WSCvariant tmp;
  if (data == NULL){
    data = &tmp;
    data->setValue("");
  }
  if (_data_source_clients == NULL){
    return;
  }
  long i;
  long num = _data_source_clients->getNum();
  for(i=0; i<num; i++){
    WSCbase* client = (WSCbase*)_data_source_clients->getData(i);
    client->setData(data);
  }
}
void WSCbase::setData(WSCvariant* data,long code){
  WSCbase* pchild = getPropertyInheritChild();
  if (pchild != NULL){
    pchild->setData(data,code);
  }
}
long WSCbase::getDataSourceType(){
  WSCbase* pchild = getPropertyInheritChild();
  if (pchild != NULL){
    return pchild->getDataSourceType();
  }
  return WS_DATA_SOURCE_NONE;
}
char* WSCbase::getDataSourcePropertyName(){
  WSCbase* pchild = getPropertyInheritChild();
  if (pchild != NULL){
    return pchild->getDataSourcePropertyName();
  }
  return "";
}
long WSCbase::_property_init(){
  long i,num;
  WSClistData* plist = _own_class_info->getPropertyListForInit();
  num = plist->getNum();

  WSCproperty* prop = NULL;
  WSCproperty* prop_bk = NULL;
  void* class_ptr_bk = NULL;
  char* class_name;
  char* class_name_bk = NULL;
  for(i=0; i< num; i++){
    prop = (WSCproperty*)(*plist)[i];
    class_name = prop->owner_class_name;
    if (prop_bk != NULL && class_name == class_name_bk){
      prop->execSetHandler( class_ptr_bk );                                  
    }else{
      class_ptr_bk = cast(class_name);
      prop->execSetHandler( class_ptr_bk );                                  
    }
    class_name_bk = class_name;
    prop_bk = prop;
  }
  return WS_NO_ERR;
}

WSCbool WSCbase::getInitialized(){
  return _initialized;
}

long WSCbase::initialize(){
static WSCbaseList* blist = NULL;
  _own_class_info = getClassInformation();
  if (blist == NULL){
    blist = WSGIappObjectList();
  }
  blist->addClient(this,_own_class_info->getClassInstanceList());
  _property_init();
  _initialized = True;
  if (_parent != NULL){
    _parent->setChild(this);
    _parent->onChildAdded(this);
  }
  return WS_NO_ERR;
}

WSCbool WSCbase::_get_parent_visible(){
  if (_parent_vis_init == False){
    _parent_vis_init = True;
    if (_parent != NULL){
      _parent_vis = _parent->getVisible();
      return _parent_vis;
    }
    if (getObjectType() & WS_TYPE_WINDOW){
      _parent_vis = True;
      return _parent_vis;
    }
    _parent_vis = False;
    return _parent_vis;
  }else{
    return _parent_vis;
  }
}

WSCbool WSCbase::_get_parent_sensitive(){
  if (_parent_sensitive_init == False){
    _parent_sensitive_init = True;
    if (_parent != NULL){
      _parent_sensitive = getSensitive();
      return _parent_sensitive;
    }
    return True;
  }else{
    return _parent_sensitive;
  }
}

long WSCbase::delAllProcedure(){
  if (_prc_list != NULL){
    _proc_is_changed = 1;
    long num =0;
    long i=0;
    while(_prc_list[i] != NULL){
      WSCprocedure* op = (WSCprocedure*)_prc_list[i];
      if (op->getTrigger() == WSEV_DELETE){
        _prc_list[num] = op;
        num++;
        i++;
      }else{
        delete op;
        i++;
      }
    }
    if (num == 0){
      delete _prc_list;
      _prc_list = NULL;
    }else{
      _prc_list[num] = NULL;
    }
  }
  return WS_NO_ERR;
}

long WSCbase::setPropertyEditExecute(WSCbool fl ){
  if (fl !=  False) {
    setPropertyEditMode(True);
    WSCbase* client = this;
    WSCbase* prop_editor = WSGIappPropertyEditor();
    if (prop_editor != NULL){
      prop_editor->setPropertyV(WSNclient,(void*)client);
    }
    setShowGriphand(True);
  }else{
    WSCbase* client = NULL;
    WSCbase* prop_editor = WSGIappPropertyEditor();
    if (prop_editor != NULL){
      void* tmp;
      prop_editor->getPropertyV(WSNclient,&(tmp));
      client = (WSCbase*)tmp;
      if (client == (WSCbase*)this){
        client = NULL;
        prop_editor->setPropertyV(WSNclient,(void*)client);
      }
    }
    setShowGriphand(False);
  }
  setAbsoluteDraw(True);
  redraw();
  return WS_NO_ERR;
}

long WSCbase::setPropertyEditMode(WSCbool fl ){
//printf("WSCbase::setPropertyEditMode %s %d\n",getInstanceName(),fl);
  if (fl !=  False) {
    if (_property_edit_mode == False){
      _property_edit_mode = True;
      _event_mask |= WSEV_MOUSE_PRESS_BIT;
      if (_dev != NULL){
        _dev->setEnableEventBit(_event_mask);
      }
      onEditModeChange(True);
    }else{
      _property_edit_mode = True;
    }
  }else{
    setPropertyEditExecute(False);
    _property_edit_mode = False;
    onEditModeChange(False);
  }
  return WS_NO_ERR;
}
void WSCbase::_adjust_for_anchors(WSCushort,WSCushort){
}
void WSCbase::update(){
  if ( _show_grip_hand != False && _update_registered != False &&
       _geometry_changed != False){
    drawGriphand();
  }
  _update_registered = False;
  _geometry_changed = False;
}
void WSCbase::needUpdate(){
  if (_update_registered == False && _vis != False){
    _update_registered = True;
    WSGIappObjectList()->addNeedUpdate(this);
  }
}
long WSCbase::delChild(WSCbase* child){
  getChildren().del(child);
  return WS_NO_ERR;
}
void WSCbase::onChildAdded(WSCbase* child){
  execProcedure(WSEV_CHILD_ADDED);
}
void WSCbase::setParent(WSCbase* parent){
  _parent = parent;
  //DEVELOP change dev property data for parent
}
long WSCbase::setChild(WSCbase* child){
  if (child == NULL){
    return WS_ERR;
  }
  getChildren().add((void*)child);
//  onChildAdded(child);
  return WS_NO_ERR;
}
long WSCbase::drawGriphand(){
  if (_show_grip_hand == False){
    return WS_NO_ERR;
  }
  short x,y;
  WSCushort w,h;
  if (existProperty(WSNx) == False ||
      existProperty(WSNy) == False ||
      existProperty(WSNwidth) == False ||
      existProperty(WSNheight) == False ){
    return WS_ERR;
  }

  getPropertyV(WSNx,&x);
  getPropertyV(WSNy,&y);
  getPropertyV(WSNwidth,&w);
  getPropertyV(WSNheight,&h);

  if (getObjectType() & WS_TYPE_MANAGER){
    x = 0;
    y = 0;
  }
  _draw_grip_hand(x,y,w,h);
  return WS_NO_ERR;
}

long WSCbase::clearGriphand(){
  WSClistData* ghlist = (WSClistData*)getUserData("GH-LIST");
  if (ghlist != NULL){
    long i;
    for(i=0; i<9; i++){
      WSCbase* gh = (WSCbase*) (*ghlist)[i];
      if (WSGIappObjectList()->existInstance(gh)){
        delete gh;
      }
    }    
    delete ghlist;
  }
  setUserData("GH-LIST",NULL);
  return WS_NO_ERR;
}

void WSCbase::setGripHandGrid(WSCushort x,WSCushort y){
  _grid_x = x;
  _grid_y = y;
}

void WSCbase::getGripHandGrid(WSCushort* x,WSCushort* y){
  *x = _grid_x;
  *y = _grid_y;
}
void _griph_geom_handler(WSCbase* base,short no,short diff_x,short diff_y){
  if (base->existProperty(WSNx) == False ||
      base->existProperty(WSNy) == False ||
      base->existProperty(WSNwidth) == False ||
      base->existProperty(WSNheight) == False){
    return;
  }
  if ( base->cast("WSCwindow") != NULL ){
    if (no == 0 || no == 1 || no == 2 || no == 6 || no == 7 || no==8){
      return;
    }
  }
  short x,y;
  WSCushort w,h;
  base->getPropertyV(WSNx,&x);
  base->getPropertyV(WSNy,&y);
  base->getPropertyV(WSNwidth,&w);
  base->getPropertyV(WSNheight,&h);
  WSCushort gx,gy;
  WSCbase::getGripHandGrid(&gx,&gy);
#if 0
  short ox = 0;
  short oy = 0;
  if (base->getXOffsetPtr() != NULL){
    ox = *(base->getXOffsetPtr());
  } 
  if (base->getYOffsetPtr() != NULL){
    oy = *(base->getYOffsetPtr());
  } 
#endif
#ifdef MSW
  if ((base->getObjectType() & WS_TYPE_WINDOW)){
    return;
  }
#endif
  WSCushort pw=0xffff;
  WSCushort ph=0xffff;
  WSCbase* parent = base->getParent();
  if (!(base->getObjectType() & WS_TYPE_WINDOW)){
    if (parent != NULL && parent->existProperty(WSNwidth) == True){
      parent->getPropertyV(WSNwidth,&pw);
      if (parent->existProperty(WSNworkWidth) == True){
        parent->getPropertyV(WSNworkWidth,&pw);
      }
    }
    if (parent != NULL && parent->existProperty(WSNheight) == True){
      parent->getPropertyV(WSNheight,&ph);
      if (parent->existProperty(WSNworkHeight) == True){
        parent->getPropertyV(WSNworkHeight,&ph);
      }
    }
  }

  if (diff_x != 0 || diff_y != 0){
    WSCbool refresh = False;
    if (base->getObjectType() & WS_TYPE_FORM){
    }else{
      refresh = True;
    }
    if (refresh != False){
      base->setVisible(False);
    }
    switch(no){
    case 0:
      if (y -diff_y > -1 && h + diff_y > 0 && 
          x -diff_x > -1 && w + diff_x > 0 ){
        short dx = x - WSGFadjustNumber(x - diff_x,gx);
        short dy = y - WSGFadjustNumber(y - diff_y,gy);
        base->setPropertyV(WSNx, (short)(WSGFadjustNumber(x - diff_x,gx)));
        base->setPropertyV(WSNy, (short)(WSGFadjustNumber(y - diff_y,gy)));
        base->setPropertyV(WSNwidth,  (WSCushort)(WSGFadjustNumber(w + dx,gx)));
        base->setPropertyV(WSNheight, (WSCushort)(WSGFadjustNumber(h + dy,gy)));
      }
      break;
    case 1:
      if (y -diff_y > -1 && h + diff_y > 0){
        short dy = y - WSGFadjustNumber(y - diff_y,gy);
        base->setPropertyV(WSNy, (short)(WSGFadjustNumber(y - diff_y,gy)) );
        base->setPropertyV(WSNheight, (WSCushort)(WSGFadjustNumber(h + dy,gy)) );
      }
      break;
    case 2:
      if (y -diff_y > -1 && h + diff_y > 0){
        short dy = y - WSGFadjustNumber(y - diff_y,gy);
        base->setPropertyV(WSNy, (short)(WSGFadjustNumber(y - diff_y,gy)) );
        base->setPropertyV(WSNheight, (WSCushort)(WSGFadjustNumber(h + dy,gy)) );
      }
      if (x + w - diff_x < pw && w - diff_x > 0){ 
        base->setPropertyV(WSNwidth,(WSCushort)(WSGFadjustNumber(w -diff_x,gx)) );
      }
      break;
    case 3:
      if (x + w - diff_x < pw && w - diff_x > 0){ 
        base->setPropertyV(WSNwidth,(WSCushort)(WSGFadjustNumber(w -diff_x,gx)) );
      }
      break;
    case 4:
      if (x + w - diff_x < pw && w - diff_x > 0){ 
        base->setPropertyV(WSNwidth,(WSCushort)(WSGFadjustNumber(w -diff_x,gx)) );
      }
      if (y + h - diff_y < ph && h - diff_y > 0){ 
        base->setPropertyV(WSNheight,(WSCushort)(WSGFadjustNumber(h -diff_y,gy)));
      }
      break;
    case 5:
      if (y + h - diff_y < ph && h - diff_y > 0){ 
        base->setPropertyV(WSNheight,(WSCushort)(WSGFadjustNumber(h -diff_y,gy)));
      }
      break;
    case 6:
      if (x -diff_x > -1 && w + diff_x > 0){
        short dx = x - WSGFadjustNumber(x - diff_x,gx);
        base->setPropertyV(WSNx, (short)(WSGFadjustNumber(x - diff_x,gx)) );
        base->setPropertyV(WSNwidth,  (WSCushort)(WSGFadjustNumber(w + dx,gx)) );
      }
      if (y + h - diff_y < ph && h - diff_y > 0){ 
        base->setPropertyV(WSNheight,(WSCushort)(WSGFadjustNumber(h -diff_y,gy)));
      }
      break;
    case 7:
      if (x -diff_x > -1 && w + diff_x > 0){
        short dx = x - WSGFadjustNumber(x - diff_x,gx);
        base->setPropertyV(WSNx, (short)(WSGFadjustNumber(x - diff_x,gx)) );
        base->setPropertyV(WSNwidth,  (WSCushort)(WSGFadjustNumber(w + dx,gx)) );
      }
      break;
    case 8:
      if (x -diff_x > -1 && x -diff_x + w < pw){
        base->setPropertyV(WSNx, (short)(WSGFadjustNumber(x - diff_x,gx)) );
      }
      if (y -diff_y > -1 && y -diff_y + h < ph){
        base->setPropertyV(WSNy, (short)(WSGFadjustNumber(y - diff_y,gy)) );
      }
      break;
    }
    if (refresh != False){
      base->setVisible(True);
    }
    base->drawGriphand();
    base->update(); 
    WSGFmarkChanged(base);

    //update xy position...
    WSCbase* prop_editor = WSGIappPropertyEditor();
    if (prop_editor != NULL){
      WSGIappPropertyEditor()->setUserData(WS_GEOMETRY_UPDATE,(void*)1); 
      WSGIappPropertyEditor()->update();
    }
  }
}

WSCbool WSCbase::getVisible(){
  if (_parent_vis_init != False){
    return (_vis && _parent_vis);
  }else{
    return (_vis && _get_parent_visible());
  }
}

WSCbool WSCbase::getSensitive(){
  if (_parent_sensitive_init != False){
    return (_sensitive && _parent_sensitive);
  }else{
    return (_sensitive && _get_parent_sensitive());
  }
}
void WSCbase::onResize(WSCrect*){}
void WSCbase::onEditModeChange(WSCbool fl){
  if (fl != False){
    long val = (long)getSensitive();
    setUserData(WS_DET,(void*)val);
  }
#if 0
  WSClistData children = getChildren();
  long num = children.getNum();
  long i;
  WSCbase* base;
  for(i=0; i < num; i++){
    base = (WSCbase*)children[i];
    if (base->getInternalObject() == False){
      base->setPropertyEditMode( fl ); 
    }
  }
#endif
  execProcedure(WSEV_EDIT_MODE_CH);
}

void WSCbase::_draw_grip_hand(short x,short y,WSCushort w,WSCushort h){
  WSClistData* glist = (WSClistData*)getUserData("GH-LIST");
  long i;
  WSCbase* gh = NULL;
  if (glist == NULL){
    glist = new WSClistData();
    setUserData("GH-LIST",glist);

//DEVELOP ////////////////////////////
//to implement settings of mouse shages...

    for(i=0; i<9; i++){
      gh = WSGFgetNewGripHand(this);
      if (i % 2 == 1){
        if (i == 1 || i == 5){
          WSCushort h;
          gh->getPropertyV(WSNheight,&h);
          h = h/2;
          gh->setPropertyV(WSNheight,h);
        }else{
          WSCushort w;
          gh->getPropertyV(WSNwidth,&w);
          w = w/2;
          gh->setPropertyV(WSNwidth,w);
        }
      }
      gh->setUserData(WS_GRIPH_HANDLER,(void*)_griph_geom_handler);
      gh->setUserData("CLIENT",(void*)this);
      gh->setUserData("GH-NO",(void*)i);
      glist->add( gh );
    }    
  }
  gh = (WSCbase*)(*glist)[0];
  gh->setPropertyV(WSNx,x);
  gh->setPropertyV(WSNy,y);
  gh->setPropertyV(WSNmouse,(WSCushort)195);
  gh = (WSCbase*)(*glist)[1];
  gh->setPropertyV(WSNx, (short)(x + w/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNy,y);
  gh->setPropertyV(WSNmouse,(WSCushort)197);
  gh = (WSCbase*)(*glist)[2];
  gh->setPropertyV(WSNx, (short)(x + w - WS_GRIPH_SIZE*2) );
  gh->setPropertyV(WSNy,y);
  gh->setPropertyV(WSNmouse,(WSCushort)196);
  gh = (WSCbase*)(*glist)[3];
  gh->setPropertyV(WSNx, (short)(x + w - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNy, (short)(y + h/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNmouse,(WSCushort)176);
  gh = (WSCbase*)(*glist)[4];
  gh->setPropertyV(WSNx, (short)(x + w - WS_GRIPH_SIZE*2) );
  gh->setPropertyV(WSNy, (short)(y + h - WS_GRIPH_SIZE*2) );
  gh->setPropertyV(WSNmouse,(WSCushort)135);
  gh = (WSCbase*)(*glist)[5];
  gh->setPropertyV(WSNx, (short)(x + w/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNy, (short)(y + h - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNmouse,(WSCushort)136);
  gh = (WSCbase*)(*glist)[6];
  gh->setPropertyV(WSNx, x );
  gh->setPropertyV(WSNy, (short)(y + h - WS_GRIPH_SIZE*2) );
  gh->setPropertyV(WSNmouse,(WSCushort)134);
  gh = (WSCbase*)(*glist)[7];
  gh->setPropertyV(WSNx, x );
  gh->setPropertyV(WSNy, (short)(y + h/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNmouse,(WSCushort)163);
  gh = (WSCbase*)(*glist)[8];
  gh->setPropertyV(WSNx, (short)(x + w/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNy, (short)(y + h/2 - WS_GRIPH_SIZE) );
  gh->setPropertyV(WSNmouse,(WSCushort)154);

  for(i=0; i<9; i++){ 
    gh = (WSCbase*)(*glist)[i];
    gh->setVisible(True);
  }
}

//WSCbool WSCbase::getGriphandOn(){
//  return _show_grip_hand;
//}

long WSCbase::setShowGriphand(WSCbool fl){
  if (fl != False){
    fl = True;
  }
  if ((WSCuchar)fl == _show_grip_hand){
    return WS_NO_ERR;
  }
  if (fl != False){
    WSDdev* dev = _dev;
    if (dev == NULL){
      return WS_ERR;
    }
    dev->setEnableEvent(WSEV_EXPOSE);
    _show_grip_hand = True;
    drawGriphand();
  }else{
    _show_grip_hand = False;
    clearGriphand();
    setAbsoluteDraw(True);
    redraw();
  }
  return WS_NO_ERR;
}
WSCbase* WSCbase::getParent(){
  return _parent;
}
WSCbase* WSCbase::getParentWindow(){
  WSCbase* parent = this;
  while(parent->getParent() != NULL){
    parent = parent->getParent();
  }
  return parent;
}
WSCbase* WSCbase::getPublicDevChild(){
  return _dev_public;
}
WSDdev* WSCbase::getdev(){
  if (_dev_is_public_dev != False){
    if (_dev_public != NULL){
      return _dev_public->getdev();
    }else{
      return NULL;
    }
  }
  return _dev;
}
long WSCbase::setdev(WSDdev* dev){
  _dev = dev;
  if (_dev != NULL){
    _dev->attachClient(this);
    _device_initialize();
  }
  return WS_NO_ERR;
}
WSDdev* WSCbase::getowndev(){
  return _dev;
}
WSDdev* WSCbase::getParentDev(){
  if (_parent == NULL){
    return NULL;
  }
  if (_use_parent_base_dev != False){
    return _parent->getowndev();
  }
  return _parent->getdev();
}
void WSCbase::setUseParentBaseDev(WSCbool fl){
  _use_parent_base_dev = fl;
}
WSCbool WSCbase::getUseParentBaseDev(){
  return _use_parent_base_dev;
}
void WSCbase::setParentSensitive(WSCbool fl){
  if (fl == _parent_sensitive){
    return;
  }
  WSCbool bk = _parent_sensitive;

  if (fl != False){
    _parent_sensitive = True;
  }else{
    _parent_sensitive = False;
  }
  onParentSensitiveChange(_parent_sensitive);
  execProcedure(WSEV_PARENT_SENSITIVE_CH);

  if ((bk && _sensitive) != (_parent_sensitive && _sensitive)){
    WSClistData children = getChildren();
    long num = children.getNum();
    long i;
    long fl = getSensitive();
    WSCbase* base;
    for(i=0; i < num; i++){
      base = (WSCbase*)children[i];
      base->setParentSensitive(fl); 
    }
  }
}

WSCbool WSCbase::getParentSensitive(){
  return _parent_sensitive;
}

void WSCbase::setParentVisible(WSCbool fl){
  if (fl == _parent_vis){
    return;
  }
  WSCbool bk = _parent_vis;

  if (fl != False){
    _parent_vis = True;
  }else{
    _parent_vis = False;
  }
  onParentVisibleChange(_parent_vis);
  execProcedure(WSEV_PARENT_VISIBLE_CH);
  if ((bk && _vis) != (_parent_vis && _vis)){
    WSClistData children = getChildren();
    long num = children.getNum();
    long i;
    long fl = getVisible();
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)children[i];
      base->setParentVisible( fl );
    }
  }
}

WSCbool WSCbase::getParentVisible(){
  if (_parent_vis_init == False){
    return  _get_parent_visible();
  }
  return _parent_vis;
}

void WSCbase::setSensitive(WSCbool fl){
  if (fl == _sensitive){
    return;
  }
  setAbsoluteDraw(True);
  needUpdate();
  long bk = getSensitive();
  if (fl != False){
    _sensitive = True;
  }else{
    _sensitive = False;
  }
  onSensitiveChange(_sensitive);
  execProcedure(WSEV_SENSITIVE_CH);

  long sensitive = getSensitive();
  if (bk != sensitive){
    WSClistData children = getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)children[i];
      base->setParentSensitive( sensitive ); 
    }
  }
  return;
}

long WSCbase::setAbsoluteDraw(WSCbool fl){
  _absolute_draw = fl;
  return WS_NO_ERR;
}

WSCbool WSCbase::getAbsoluteDraw(){
  return _absolute_draw;
}

WSClistData* WSCbase::getProcedureList(){
static WSClistData ops;
  ops.clear();
  if (_prc_list != NULL){
    long i = 0;
    while(_prc_list[i] != NULL){
      ops.add((void*)_prc_list[i]);
      i++;
    }
  }
  return &ops;
}

WSClistData WSCbase::getProcedures(){
  WSClistData ops;
  ops.clear();
  if (_prc_list != NULL){
    long i = 0;
    while(_prc_list[i] != NULL){
      ops.add((void*)_prc_list[i]);
      i++;
    }
  }
  return ops;
}
void WSCbase::setVisible(WSCbool fl){
#ifdef TDBG
printf("WSCbase::setVisible(%d) here1 %d\n",fl,WSGFclocktime());
#endif

  long obj_type = getObjectType();

  WSCbool bk;
  if (_parent_vis_init != False){
    bk = _vis_bk && _parent_vis;
  }else{
    bk = _vis_bk && _get_parent_visible();
  }
  if (_vis == fl && _vis_bk == fl){
    return;
  }
#ifdef TDBG
printf("WSCbase::setVisible(%d) here2 %d\n",fl,WSGFclocktime());
#endif
  if (fl != False){
    _vis = True;
    _vis_bk = True;
  }else{
    _vis = False;
    _vis_bk = False;
    if ((obj_type &  WS_TYPE_FORM) == 0){
      if (_no_clear == False){
        redraw();
      }
    }
  }
#ifdef TDBG
printf("WSCbase::setVisible(%d) here3 %d\n",fl,WSGFclocktime());
#endif
  long vis = getVisible();
  onVisibleChange(_vis);
  execProcedure(WSEV_VISIBLE_CH);
  if (bk != vis){
    WSClistData children = getChildren();
    long num = children.getNum();
    long i;
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)children[i];
      base->setParentVisible( vis ); 
    }
  }
#ifdef TDBG
printf("WSCbase::setVisible(%d) here4 %d\n",fl,WSGFclocktime());
#endif
  if (fl == True){
    if ((obj_type &  WS_TYPE_FORM) == 0){
      setAbsoluteDraw(True);
    }
    needUpdate();
  }
#ifdef TDBG
printf("WSCbase::setVisible(%d) here5 %d\n",fl,WSGFclocktime());
#endif
  return;
}
void WSCbase::setNoClearFlag(WSCbool fl){
  _no_clear = fl;
}
long WSCbase::redraw(){
  return WS_NO_ERR;
}
long WSCbase::clear(){
  return WS_NO_ERR;
}
long WSCbase::_device_initialize(){
  if (_dev == NULL){
    return WS_ERR;
  }
  if (_scale_ptrs != NULL){
    if (_scale_ptrs[2] != NULL){
      _dev->setValue(WSDEV_SCALE_OFFSET,_scale_ptrs[2]);
    }
    if (_scale_ptrs[0] != NULL && !(getObjectType() & WS_TYPE_FORM )){
      _dev->setValue(WSDEV_X_OFFSET,_scale_ptrs[0]);
    }
    if (_scale_ptrs[1] != NULL && !(getObjectType() & WS_TYPE_FORM )){
      _dev->setValue(WSDEV_Y_OFFSET,_scale_ptrs[1]);
    }
  }
  _dev->setEnableEventBit(_event_mask);
  return WS_NO_ERR;
}


WSCclassInformation* WSCbase::WSCbase_info_ptr = NULL;
WSCclassInformation* WSCbase::getClassInformation(){
  if (WSCbase_info_ptr == NULL){
    WSCbase_info_ptr = new WSCclassInformation("WSCbase",NULL);
  }
  return WSCbase_info_ptr;
}
WSClistData* WSCbase::getPropertyList(){
  return _own_class_info->getAllPropertyList();
}
WSCproperty* WSCbase::getPropObj(char* prop_name){
  WSCproperty* prop = NULL;
  WSCbool ret = _own_class_info->getPropObj(prop_name,&prop);
  if (ret == False){
    return NULL;
  }else{
    return prop;
  }
}
long WSCbase::getPropObjArray(WSClistData* list){
  long pnum;
  long i,j;
  WSClistData* hash_table = _own_class_info->getHashTable();
  for(i=0; i < WS_MAX_HASH_VALUE; i++){
    pnum = hash_table[i].getNum();
    WSCproperty* prop;
    for(j=0; j < pnum; j++){
      WSChashData* hdata = (WSChashData*)hash_table[i][j];
      prop = hdata->_property;
      list->add(prop);
    }
  }
  return WS_NO_ERR;
}
long WSCbase::getPropertyArray(WSClistData* list,WSCbool include_defaultv){
  WSCproperty* prop;
  long pnum;

  long j;
  WSClistData* props = _own_class_info->getAllPropertyList();

  pnum = props->getNum();
  for(j=0; j < pnum; j++){
    prop = (WSCproperty*)(*props)[j];
    WSCbool def = prop->isDefaultValue(this);
    if (def != False && include_defaultv == False){
      continue;
    }
    list->add(WSGFstrdup(prop->property_name));
    list->add(WSGFstrdup(_get_property_str_value(prop)));
  }
  return WS_NO_ERR;
}

void WSCbase::_error_output(char* pname,char* tname,char* ptname,WSCbool fl){
if (fl == False){
WSMFtrace("ERROR. %s WSCbase::getProperty property %s invalid value type:%s\n",getClassName(),pname,tname);
}else{
WSMFtrace("ERROR. %s WSCbase::setProperty property %s invalid value type:%s\n",getClassName(),pname,tname);
}
WSMFtrace("object:%s WSN%s type is %s.\n",getInstanceName(),pname,ptname);
}

WSCvariant WSCbase::getProperty(char* prop_name){
  WSCproperty* prop;
  WSCbool fl = _own_class_info->getPropObj(prop_name,&prop);
  if (fl == False){
    if (getPropertyInheritChild() != NULL){
      return getPropertyInheritChild()->getProperty(prop_name);
    } 
WSMFtrace("ERROR. %s WSCbase::getProperty property not exists. %s\n",getClassName(),prop_name);
    return "";
  }
  return _get_property_str_value(prop);
}

char* WSCbase::_get_property_str_value(WSCproperty* prop){
  register long tp = prop->_prop_type;
//DEVELOP hash ...
  switch(tp){
    case WSTshort:{
      if (prop->_is_pixmap != False){
        short val;
        prop->getValue(this,&val);
        return WSGFimageName(val);
      }else if (prop->_is_color != False){
        short val;
        prop->getValue(this,&val);
        if (val > 1023){
          return WSGFcolorName(val);
        }else{
          return WSGFcolorName(val);
        }
      }else{
        short data;
        prop->getValue(this,&data);
        return WSGFltoa((long)data);
      }
    }
    break;
    case WSTushort:{
      WSCushort data;
      prop->getValue(this,&data);
      return WSGFltoa((long)data);
    }
    case WSTbool:{
      char data;
      prop->getValue(this,&data);
      if (data != False){
        return "1";
      }else{
        return "0";
      }
    }
    case WSTcharptr:{
      char* data;
      prop->getValue(this,&data);
      if (data == NULL){
        data ="";
      }
      return data;
    }
    case WSTchar:{
      char data;
      prop->getValue(this,&data);
      return WSGFltoa((long)data);
    }
    case WSTuchar:{
      WSCuchar data;
      prop->getValue(this,&data);
      return WSGFltoa((long)data);
    }
    case WSTlong:{
      long data;
      prop->getValue(this,&data);
      return WSGFltoa((long)data);
    }
    case WSTulong:{
      WSCulong data;
      prop->getValue(this,&data);
      return WSGFultoa(data);
    }
    case WSTfloat:{
      float data;
      prop->getValue(this,&data);
      return WSGFftoa(data);
    }
    case WSTdouble:{
      double data;
      prop->getValue(this,&data);
      return WSGFlftoa(data);
    }
    case WSTvoidptr:{
      void* data;
      prop->getValue(this,&data);
      return WSGFltoa((long)data);
    }
  }
  return "";
}

WSCbool WSCbase::existProperty(char* prop_name){
  WSCproperty* prop;
  if (getPropertyInheritChild() != NULL &&
     _own_class_info->getPropObj(prop_name,&prop) == False){
    return getPropertyInheritChild()->existProperty(prop_name);
  }else{
    return _own_class_info->getPropObj(prop_name,&prop);
  }
}

WSCbool WSCbase::setProperty(char* prop_name,const WSCvariant& value){
  WSCvariant tmp = value;
  return _set_property(prop_name,tmp.getCharPtr());
}

WSCbool WSCbase::_set_property(char* prop_name,char* value){
//DEVELOP use hash table
  WSCproperty* prop;
  WSCbool fl = _own_class_info->getPropObj(prop_name,&prop);
  WSCbool ret = False;
  if (fl == False){
    if (getPropertyInheritChild() != NULL){
      return getPropertyInheritChild()->setProperty(prop_name,value);
    }
    WSMFtrace("ERROR. %s WSCbase::setProperty property not exists. %s\n",
               getClassName(),prop_name);
    return False;
  }
  register long tp = prop->_prop_type;
  if (value == NULL){
    value = "";
  }
  switch(tp){
    case WSTshort:{
      if (prop->_is_pixmap != False){
        short pno = -1;
        if (!WSGFstrcmp(value,"") ||
            !WSGFstrcmp(value,"NULL") ||
            !WSGFstrcmp(value,"NONE") ||
            !WSGFstrcmp(value,"null") ||
            !WSGFstrcmp(value,"None") ){
            //pno = -1; ....
        }else{
          pno = WSGFimage(value);
        }
        prop->setValue(this,&pno);
      }else if (prop->_is_color != False){
        short cno = atoi(value);
        if (cno == 0){
          cno = WSGFcolor(value);
          prop->setValue(this,&cno);
        }else{
          prop->setValue(this,&cno);
        }
      }else{
        short data = atoi(value);
        prop->setValue(this,&data);
      }
      return True;
    }
    break;
    case WSTuchar:{
      WSCuchar data = atoi(value);
      prop->setValue(this,&data);
      return True;
    }
    case WSTushort:{
      WSCushort data = atoi(value);
      prop->setValue(this,&data);
      return True;
    }
    case WSTcharptr:{
      char* diff;
      prop->getValue(this,&diff);
      if (diff != NULL && diff[0] == value[0] && !WSGFstrcmp(diff,value)){
        //do nothing...
      }else{
        char* nstr = WSGFstrdup(value);
        prop->setValue(this,&nstr);
        if (diff != NULL){
          delete diff;
        }
      }
      return True;
    }
    case WSTbool:{
      char data = atoi(value);
      if (data == 0) {
        if (!WSGFstrcmp(value,"True") || !WSGFstrcmp(value,"true")){
          data = True;
        }
      }
      prop->setValue(this,&data);
      return True;
    }
    case WSTchar:{
      char data = atoi(value);
      prop->setValue(this,&data);
      return ret;
    }
    case WSTlong:{
      long data = atoi(value);
      prop->setValue(this,&data);
      return True;
    }
    case WSTulong:{
      WSCulong data = atoi(value);
      prop->setValue(this,&data);
      return True;
    }
    case WSTfloat:{
      float data = (float)atof(value);
      prop->setValue(this,&data);
      return True;
    }
    case WSTvoidptr:{
      void* data = (void*)atoi(value);
      prop->setValue(this,&data);
      return True;
    }
    case WSTdouble:{
      double data = atof(value);
      prop->setValue(this,&data);
      return True;
    }
  }
  return False;
}
WSCbool WSCbase::setDefaultValue(char* prop_name){
  WSCproperty* prop;
  WSCbool fl = _own_class_info->getPropObj(prop_name,&prop);
  if (fl == False){
WSMFtrace("ERROR. WSCbase::setDefaultValue property not exists. %s\n",prop_name);
    return False;
  }
  prop->setDefaultValue(this);
  return True;
} 
long WSCbase::isDefaultValue(char* prop_name,WSCbool* fl){
  WSCproperty* prop;
  WSCbool ret = _own_class_info->getPropObj(prop_name,&prop);
  if (ret == False){
    WSCbase* pchild = getPropertyInheritChild();
    if (pchild != NULL){
      return pchild->isDefaultValue(prop_name,fl);
    }else{
WSMFtrace("ERROR. WSCbase::isDefaultValue property not exists. %s\n",prop_name);
    }
    return WS_ERR;
  }
  *fl = prop->isDefaultValue(this);
  return WS_NO_ERR;
}

void WSCbase::_set_prop_error(char* pname){
  WSMFtrace("ERROR. WSCbase::setPropertyV property not exists. %s  class=%s obj=%s\n",pname,getClassName(),getInstanceName());
//  assert(0);//TEST
}

void WSCbase::_set_prop_error2(char* pname,char* tname,WSCproperty* prop){
  WSMFtrace("ERROR. WSCbase::setPropertyV property %s invalid value type:%s.\n",pname,tname);
  WSMFtrace("object:%s WSN%s type is %s.\n",getInstanceName(),pname,prop->getPropObjTypeName());
//  assert(0);//TEST
}

WSCbool WSCbase::setPropertyV(char* prop_name,WSCvariant value){
  return setProperty(prop_name,value);
}
WSCbool WSCbase::setPropertyV(char* prop_name,char value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTchar || prop->_prop_type == WSTbool  ){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"char",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,WSCuchar value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTuchar || prop->_prop_type == WSTbool){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"unsigned char",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,char* value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (value == NULL){
    value ="";
  }
  if (prop->_is_pixmap != False){
    short pno = -1;
    if (!WSGFstrcmp(value,"") ||
        !WSGFstrcmp(value,"NULL") ||
        !WSGFstrcmp(value,"NONE") ||
        !WSGFstrcmp(value,"null") ||
        !WSGFstrcmp(value,"None") ){
        //pno = -1; ....
    }else{
      pno = WSGFimage(value);
    }
    prop->setValue(this,&pno);
  }else if (prop->_is_color != False){
    short cno = WSGFcolor(value);
    prop->setValue(this,&cno);
  }else if (prop->_prop_type == WSTcharptr){
    char* diff;
    prop->getValue(this,&diff);
    if (diff != NULL && diff[0] == value[0] && !WSGFstrcmp(diff,value)){
      //do nothing...
    }else{
      char* nstr = WSGFstrdup(value);
      prop->setValue(this,&nstr);
      if (diff != NULL){
        delete diff;
      }
    }
  }else{
    _set_prop_error2(prop_name,"char*",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,short value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTshort){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"short",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,WSCushort value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTushort){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"unsigned short",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,int value){
  return setPropertyV(prop_name,(long)value);
}
WSCbool WSCbase::setPropertyV(char* prop_name,long value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTlong){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"long",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,WSCuint value){
  return setPropertyV(prop_name,(WSCulong)value);
}
WSCbool WSCbase::setPropertyV(char* prop_name,WSCulong value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTulong){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"unsigned long",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,float value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTfloat){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"float",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,double value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTdouble){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"double",prop);
    return False;
  }
  return True;
}
WSCbool WSCbase::setPropertyV(char* prop_name,void* value){
WSMFtrace("WSCbase::setPropertyV() prop=%s\n",prop_name);
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->setPropertyV(prop_name,value)){
      return True;
    }
    _set_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTvoidptr){
    prop->setValue(this,&value);
  }else{
    _set_prop_error2(prop_name,"void*",prop);
    return False;
  }
  return True;
}
void WSCbase::_get_prop_error(char* pname){
  WSMFtrace("ERROR. WSCbase::getPropertyV property not exists. %s\n",pname);
}
void WSCbase::_get_prop_error2(char* pname,char* tname,WSCproperty* prop){
  WSMFtrace("ERROR. WSCbase::getPropertyV property %s is not type:%s.\n",pname,tname);
  WSMFtrace("object:%s WSN%s type is %s.\n",getInstanceName(),pname,prop->getPropObjTypeName());
}
WSCbool WSCbase::getPropertyV(char* prop_name,char* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTchar || prop->_prop_type == WSTbool){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"char",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,WSCuchar* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTuchar || prop->_prop_type == WSTbool){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"unsigend char",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,char** value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTcharptr){
    prop->getValue(this,value);
    return True;
  }else if (prop->_prop_type == WSTshort && prop->_is_color != False){
    short val;
    prop->getValue(this,&val);
    if (val > 1023){
      *value = WSGFcolorName(val);
    }else{
      *value = WSGFltoa(val);
    }
    return True;
  }else if (prop->_prop_type == WSTshort && prop->_is_pixmap != False){
    short val;
    prop->getValue(this,&val);
    *value = WSGFimageName(val);
    return True;
  }
  _get_prop_error2(prop_name,"char*",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,short* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTshort){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"short",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,WSCushort* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTushort){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"unsigend short",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,int* value){
  return getPropertyV(prop_name,(long*)value);
}
WSCbool WSCbase::getPropertyV(char* prop_name,WSCuint* value){
  return getPropertyV(prop_name,(WSCulong*)value);
}
WSCbool WSCbase::getPropertyV(char* prop_name,long* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTlong){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"long",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,WSCulong* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTulong){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"unsigned long",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,float* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTfloat){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"float",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,double* value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTdouble){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"double",prop);
  return False;
}
WSCbool WSCbase::getPropertyV(char* prop_name,void** value){
  WSCproperty* prop;
  if (_own_class_info->getPropObj(prop_name,&prop) == False){
    if (getPropertyInheritChild() != NULL &&
      getPropertyInheritChild()->getPropertyV(prop_name,value)){
      return True;
    }
    _get_prop_error(prop_name);
    return False;
  }
  if (prop->_prop_type == WSTvoidptr){
    prop->getValue(this,value);
    return True;
  }
  _get_prop_error2(prop_name,"void*",prop);
  return False;
}
void WSCbase::_exec_del_procedure(){
  if (_prc_list != NULL){
    _exec_procedure(_prc_list,WSEV_DELETE,True);
  }
  return;
}
void WSCbase::execProcedure(long ev){
  if (ev == WSEV_EXPOSE && _expose_op == 0){
    return;
  }
  if (_prc_list != NULL){
    _exec_procedure(_prc_list,ev,False);
  }
  return;
}
void WSCbase::_exec_procedure(WSCprocedure* op){
  if (WSGIappDev()->getTraceMode() != False && op->getInternal() == False){
    char sbuf[1024];
    WSCstring str;
    sprintf(sbuf,"%s %s execute event procedure <%s>\n",getClassName(),getInstanceName(),
                                                  op->getProcName());
    str = sbuf;
    WSGFsendMessage("WS-TRACER",str.getString(WS_EN_UTF8));
    sprintf(sbuf,"function %s() start  ev=%s\n",op->getFunctionName(),
                                                 WSGFeventToName(op->getTrigger()));
    str = sbuf;
    WSGFsendMessage("WS-TRACER",str.getString(WS_EN_UTF8));
  }
  void (*proc)(WSCbase*); 
  proc = (void(*)(WSCbase*))op->getProc();
  if (proc != NULL){
    proc(this);
  }else{
    void(*hd)(char*,WSCbase*) =
                 (void(*)(char*,WSCbase*))WSGFgetProcedureHandler();
    if (hd != NULL){
      hd(op->getFunctionName(),this);
    }
  }
  if (WSGIappDev()->getTraceMode() != False && op->getInternal() == False){
    char sbuf[1024];
    WSCstring str;
    sprintf(sbuf,"function %s() end\n",op->getFunctionName());
    str = sbuf;
    WSGFsendMessage("WS-TRACER",str.getString(WS_EN_UTF8));
  }
}
void WSCbase::_exec_procedure(WSCprocedure** opl,long ev,WSCbool del){
  if (ev == WSEV_INITIALIZE){
    _init_registered = False;
  }
  long i=0;
  _proc_is_changed = 0;
  while(opl[i] != NULL){
    i++;
  }
  WSCprocedure** oplist = new WSCprocedure*[i+1];
  WSCprocedure** oplist2 = new WSCprocedure*[i+1];
  long inum = 0;
  memcpy(oplist,opl,sizeof(WSCprocedure*)*(i+1));
  i=0;
  while(oplist[i] != NULL){
    WSCprocedure* op = (WSCprocedure*)oplist[i];
    if (op->getTrigger()  == ev){
      if (op->getInternal() == False){
        if (_proc_is_changed != 0){
          if (_prc_list == NULL){
            break;
          }
          long cnt = 0;
          long exists = 0;
          while(_prc_list[cnt] != NULL){
            if (_prc_list[cnt] == op){
              exists = 1;
              break;
            }
            cnt++;
          }
          if (exists == 0){
            continue;
          }
        }
        _exec_procedure(op);
        if (del == False){ 
          WSGIappObjectList()->execUpdate();
        }
      }else{
        oplist2[inum] = op;
        inum++;
      }
    }
    i++;
  }
  for(i=0; i<inum; i++){
    WSCprocedure* op = (WSCprocedure*)oplist2[i];
    if (_proc_is_changed != 0){
      if (_prc_list == NULL){
        break;
      }
      long cnt = 0;
      long exists = 0;
      while(_prc_list[cnt] != NULL){
        if (_prc_list[cnt] == op){
          exists = 1;
          break;
        }
        cnt++;
      }
      if (exists == 0){
        continue;
      }
    }
    _exec_procedure(op);
    if (del == False){ 
      WSGIappObjectList()->execUpdate();
    }
  }
  delete oplist;
  delete oplist2;
}
void WSCbase::_exec_procedure(WSCprocedure** opl,char* opname){
  long i = 0;
  while(opl[i] != NULL){
    i++;
  }
  _proc_is_changed = 0;
  WSCprocedure** oplist = new WSCprocedure*[i+1];
  WSCprocedure** oplist2 = new WSCprocedure*[i+1];
  long inum = 0;
  memcpy(oplist,opl,sizeof(WSCprocedure*)*i);
  oplist[i] = NULL;
  i=0;
  while(oplist[i] != NULL){
    WSCprocedure* op = (WSCprocedure*)oplist[i];
    if ( !WSGFstrcmp(op->getProcName(),opname) ){
      if (op->getInternal() == False){
        if (_proc_is_changed != 0){
          if (_prc_list == NULL){
            break;
          }
          long cnt = 0;
          long exists = 0;
          while(_prc_list[cnt] != NULL){
            if (_prc_list[cnt] == op){
              exists = 1;
              break;
            }
            cnt++;
          }
          if (exists == 0){
            continue;
          }
        }
        _exec_procedure(op);
      }else{
        oplist2[inum] = op;
        inum++;
      }
    }
    i++;
  }
  for(i=0; i<inum; i++){
    WSCprocedure* op = (WSCprocedure*)oplist2[i];
    if (_proc_is_changed != 0){
      if (_prc_list == NULL){
        break;
      }
      long cnt = 0;
      long exists = 0;
      while(_prc_list[cnt] != NULL){
        if (_prc_list[cnt] == op){
          exists = 1;
          break;
        }
        cnt++;
      }
      if (exists == 0){
        continue;
      }
    }
    _exec_procedure(op);
    _exec_procedure(op);
  }
  delete oplist;
  delete oplist2;
}
void WSCbase::execProcedure(char* opname){
  if (_prc_list != NULL){
    _exec_procedure(_prc_list,opname);
  }
  return;
}
long WSCbase::addProcedure(WSCprocedure* op){
  if (existTrigger(op->getTrigger()) == False && op->getInternal() == False){
//assert(0);
WSMFtrace("WSCbase::addProcedure trigger=%d not supported.\n",(int)op->getTrigger());
     return WS_ERR;
  }
  _event_mask |= op->getEffectiveTriggerMask();
  if (op->getTrigger() == WSEV_INITIALIZE && _init_registered == False){
    _init_registered = True;
    WSGIappObjectList()->addNeedInitialize(this);
    _add_prcs( &_prc_list, op );
    return WS_NO_ERR;
  }
  op->setEffectiveTriggerMask( op->getEffectiveTriggerMask()  );
  if (op->getTrigger() == WSEV_EXPOSE){
    _expose_op = 1;
  }
  _add_prcs(&_prc_list, op);
  WSDdev* dev = _dev;
  if (dev != NULL && op->getEffectiveTriggerMask() != 0){
    dev->setEnableEvent( op->getTrigger() );
  }
  return WS_NO_ERR;
}
void WSCbase::_add_prcs(WSCprocedure*** list,WSCprocedure* op){
  WSCprocedure** ilist = *list;
  if (ilist == NULL){
    *list = new WSCprocedure*[2];
    ilist = *list;
    ilist[0] = op;
    ilist[1] = NULL;
    return;
  }
  WSCprocedure* tlist[256];
  long i=0;
  while( ilist[i] != NULL){
    if (i > 254){
      break;
    }
    tlist[i] = ilist[i];
    i++;
  }
  delete ilist;
  ilist = new WSCprocedure*[i+2];
  *list = ilist;
  memcpy(ilist,tlist,sizeof(WSCprocedure*)*i);
  ilist[i] = op;
  ilist[i+1] = NULL;
}
long WSCbase::delProcedure(WSCprocedure* proc){
  if (_prc_list != NULL){
    long i=0;
    while(_prc_list[i] != NULL){
      WSCprocedure* op = (WSCprocedure*)_prc_list[i];
      if (op == proc){
        _proc_is_changed = 1;
        while(_prc_list[i+1] != NULL){
          _prc_list[i] = _prc_list[i+1];
          i++;
        }
        _prc_list[i] = NULL;
        return WS_NO_ERR;
      }
      i++;
    }
  }
  return WS_ERR;
}
long WSCbase::execEventProc(long ev,void* data){
//DEVELOP///
// makeing this procedure to use hash table
  if (ev == WSEV_EXPOSE){
    if (data != NULL){
      WSCrect* area = (WSCrect*)data;
      onExpose(area);
      draw();
      if (_expose_op == 1){
        execProcedure(ev);
      }
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_PRESS){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMousePress(point);
      execProcedure(ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_DOUBLE_CLICK){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMouseDoubleClick(point);
      execProcedure(ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_RELEASE){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMouseRelease(point);
      execProcedure(ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_IN){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMouseIn(point);
      execProcedure(ev);
      return WS_NO_ERR;
    }
  }else if (ev == WSEV_MOUSE_OUT){
    onMouseOut();
    execProcedure(ev);
    return WS_NO_ERR;
  }else if (ev == WSEV_MOUSE_MOVE){
    if (data != NULL){
      WSCpoint* point = (WSCpoint*)data;
      onMouseMove(point);
      execProcedure(ev);
      return WS_ERR;
    }
  }else if (ev == WSEV_RESIZE){
    WSCrect* rect = (WSCrect*)data;
    onResize(rect);
    execProcedure(ev);
    return WS_NO_ERR;
  }else if (ev == WSEV_GUI_POLICY_CH){
    long policy = (long)data;
    onGuiPolicyChange(policy);
    return WS_NO_ERR;
  } 
  execProcedure(ev);
  return WS_ERR;
}
void WSCbase::onMouseIn(WSCpoint*){}
void WSCbase::onMouseOut(){}
void WSCbase::onMouseMove(WSCpoint*){}
void WSCbase::onFocusChange(WSCbool){}
void WSCbase::onSpecialFocusChange(WSCbool){
  execProcedure(WSEV_SPECIAL_FOCUS_CH);
}

void WSCbase::onMousePress(WSCpoint* point){
  if (_internal_object != False){
    WSCbase* parent = _parent;
    while(parent != NULL){
      if (parent->_internal_object != False){
        parent = parent->_parent;
        continue;
      }else if (parent->_property_edit_mode != False){
        short px;
        short py;
        getMouseAddr(&px,&py);
        WSClistData children = parent->getChildren();
        long num = children.getNum();
        if (num != 0){
          long i;
          for(i=0; i<num; i++){
            WSCbase* child = (WSCbase*)children[i];
            if (child->_dev == NULL){
              continue;
            }else if (child->_dev->getParentDev() == NULL){
              continue;
            }
            if (child->getInternalObject() != False){
              continue;
            }
            if (child->existProperty(WSNx)      != False && 
                child->existProperty(WSNy)      != False &&
                child->existProperty(WSNwidth)  != False &&
                child->existProperty(WSNheight) != False ){
              short x,y;
              WSCushort w,h;
              child->getPropertyV(WSNx,&x); 
              child->getPropertyV(WSNy,&y); 
              child->getPropertyV(WSNwidth,&w); 
              child->getPropertyV(WSNheight,&h); 
              if ( px >= x   && py >= y  &&
                   px < x + w && py <= y + h &&
                   child->getVisible() != False ){
                return;
              }
            }
          }
        }
        parent->setPropertyEditExecute(True); 
        return;
      }else{
        return;
      }
    }
  }else if (_property_edit_mode != False){
    if (!WSGFstrcmp(getUseDevName(),"nwDev")){
      WSCbase* parent = _parent;
      if (parent == NULL){
        setPropertyEditExecute(True); 
      }else{
        WSClistData children = parent->getChildren();
        long num = children.getNum();
        long i,j=0;
        for(i=0; i<num; i++){
          WSCbase* base = (WSCbase*)children[i];
          if (base == this){
            j = i;
            break;
          }
        }
        if (i == num -1){
          setPropertyEditExecute(True); 
        }else{
          short mx=0,my=0;
          if (existProperty(WSNx) != False){
            getPropertyV(WSNx,&mx);
          }
          if (existProperty(WSNy) != False){
            getPropertyV(WSNy,&my);
          }
          long px = point->x + mx;
          long py = point->y + my;
          for(i=j+1; i<num; i++){
            WSCbase* child = (WSCbase*)children[i];
            if (child->_dev == NULL){
              continue;
            }else if (child->_dev->getParentDev() == NULL){
              continue;
            }
            if (child->existProperty(WSNx)      != False && 
                child->existProperty(WSNy)      != False &&
                child->existProperty(WSNwidth)  != False &&
                child->existProperty(WSNheight) != False ){
              short x,y;
              WSCushort w,h;
              child->getPropertyV(WSNx,&x); 
              child->getPropertyV(WSNy,&y); 
              child->getPropertyV(WSNwidth,&w); 
              child->getPropertyV(WSNheight,&h); 
              if ( px >= x   && py >= y   &&
                   px < x + w && py <= y + h &&
                   child->getVisible() != False ){
                return;
              }
            }
          }
          setPropertyEditExecute(True); 
        }
      }
    }else{
      WSClistData children = getChildren();
      long num = children.getNum();
      if (num != 0){
        long i;
        for(i=0; i<num; i++){
          WSCbase* child = (WSCbase*)children[i];
          if (child->_dev == NULL){
            continue;
          }else if (child->_dev->getParentDev() == NULL){
            continue;
          }
          if (child->existProperty(WSNx)      != False && 
              child->existProperty(WSNy)      != False &&
              child->existProperty(WSNwidth)  != False &&
              child->existProperty(WSNheight) != False ){
            short x,y;
            WSCushort w,h;
            child->getPropertyV(WSNx,&x); 
            child->getPropertyV(WSNy,&y); 
            child->getPropertyV(WSNwidth,&w); 
            child->getPropertyV(WSNheight,&h); 
            if ( point->x >= x   && point->y >= y  &&
                 point->x < x + w && point->y <= y + h &&
                 child->getVisible() != False ){
              return;
            }
          }
        }
      }
      setPropertyEditExecute(True); 
    }
  }
}
void WSCbase::onMouseDoubleClick(WSCpoint*){ }

void WSCbase::onMouseRelease(WSCpoint*){}
void WSCbase::onExpose(WSCrect*){}
void WSCbase::onDataSave(WSDserialize* ){}
void WSCbase::onDataLoad(WSDserialize* ){}
void WSCbase::onGuiPolicyChange(long policy){
  execProcedure(WSEV_GUI_POLICY_CH);
}
void WSCbase::onDefaultColorChange(){}

void WSCbase::onVisibleChange(WSCbool fl){
  WSDdev* dev = getowndev();
  if (fl != False){
    if (dev == NULL){
      if (getParentVisible() == True){
        WSDdev* new_dev = attachdev();
        if (new_dev != NULL){
          new_dev->setEnableEventBit(_event_mask);
          new_dev->setVisible(True);
          setAbsoluteDraw(True);
          needUpdate();
        }
      }
    }else{
      dev->setVisible(True);
    }
  }else{
    if (dev != NULL){
      dev->setVisible(False);
    }
  }
}
void WSCbase::onSensitiveChange(WSCbool){
  setAbsoluteDraw(True);
  needUpdate();
}
void WSCbase::onParentVisibleChange(WSCbool fl){
  if (fl != False && _vis != False){
    WSDdev* dev = getowndev();
    if (dev == NULL){ 
      dev = attachdev();
    }
    if (dev != NULL){
      dev->setEnableEventBit(_event_mask);
      dev->setVisible(True);
      setAbsoluteDraw(True);
      needUpdate();
    }
  }
}
void WSCbase::onParentSensitiveChange(WSCbool){}
void WSCbase::setUserData(char* name,void* data){
  long i;
  for(i= 0; i < _num_of_user_data; i++){
    if (name[0] == _user_data_name_list[i][0] &&
        !WSGFstrcmp(name,_user_data_name_list[i])){
       _user_data_list[i] = data;
       return;
    }
  }

  char** newnames = new char*[_num_of_user_data+1];
  void** newlist  = new void*[_num_of_user_data+1];

  if (_num_of_user_data != 0){
    memcpy( newnames,_user_data_name_list,
            (size_t)(sizeof(char*)*_num_of_user_data));
    memcpy( newlist, _user_data_list, (size_t)(sizeof(void*) * _num_of_user_data) );
    delete[] _user_data_name_list;
    delete[] _user_data_list;
  }
  _user_data_list      = newlist;
  _user_data_list[_num_of_user_data] = data;
  _user_data_name_list = newnames;
  _user_data_name_list[_num_of_user_data] = WSGFstrdup(name);
  _num_of_user_data++;
  return;
}
void* WSCbase::getUserData(char* name){
  if (name == NULL){
    return NULL;
  }
  for(int i= 0; i < _num_of_user_data; i++){
    if (name[0] == _user_data_name_list[i][0] &&
        !WSGFstrcmp(name,_user_data_name_list[i])){
      return _user_data_list[i];
    }
  }
  return NULL;
}
void WSCbase::setVariantData(char* name,WSCvariant data){
  if (_variant_list == NULL){
    _variant_list = new WSCindexVariantData;
  }
  _variant_list->setData(name,data);
}
WSCvariant& WSCbase::getVariantData(char* name){
  if (_variant_list == NULL){
    _variant_list = new WSCindexVariantData;
  }
  return _variant_list->getData(name);
}
WSCbase* WSCbase::getFocusMoveInstance(long direction){
  WSCbase* target = _get_focus_move_instance(direction);
  if (target == NULL){
    return NULL;
  }
  if (target->getSensitive() == False){
    return NULL;
  }
  return target;
}
WSCbase* WSCbase::_get_focus_move_instance(long direction){
  if (getParent() == NULL){
    return NULL;
  }

  short     x=0,y=0;
  WSCushort w=0,h=0;
  short     dx,dy;
  WSCushort dw,dh;
  long work1,work2,hit_work,tmp_distance;

  if (existProperty(WSNx) != False){
    getPropertyV(WSNx,&x);
  }
  if (existProperty(WSNy) != False){
    getPropertyV(WSNy,&y);
  }
  if (existProperty(WSNwidth) != False){
    getPropertyV(WSNwidth,&w);
  }
  if (existProperty(WSNheight) != False){
    getPropertyV(WSNheight,&h);
  }

  WSCbase* target = NULL;
  char* prop = WSNupward;
  if (direction == WS_DOWN){
    prop = WSNdownward;
  }else if (direction == WS_RET){
    prop = WSNreturn;
  }else if (direction == WS_LEFT){
    prop = WSNleftward;
  }else if (direction == WS_RIGHT){
    prop = WSNrightward;
  }else if (direction == WS_TAB){
    prop = WSNtab;
  }else if (direction == WS_STAB){
    prop = WSNbacktab;
  }
  if (existProperty(prop) != False){
    char* dest;
    WSCbool fl = getPropertyV(prop,&dest);
    if ( fl != False && dest != 0 && dest[0] != 0){
      target =  WSGIappObjectList()->getInstance("WSCbase",dest);
      if (target != NULL){
        return target;
      }
    }
  }

  long i;
  WSClistData* list = (WSClistData*)getParent()->getUserData("FOCUS_LIST");
  if (list == NULL){
    return NULL;
  }
  long num = list->getNum();
  if (num < 2){
    return NULL;
  }
  long distance = -1;
  if (direction == WS_UP){
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)(*list)[i];
      if (base == this || base->getVisible() == False){
	    continue;
	  }
      base->getPropertyV(WSNy,&dy);
      base->getPropertyV(WSNheight,&dh);
      if (dy + dh  > y ){
	    continue;
      }
      base->getPropertyV(WSNx,&dx);
      base->getPropertyV(WSNwidth,&dw);
      if (dx > x) {
        work1 = (long)dx;
      }else{
        work1 = (long)x;
      }
      if (dx + dw  > x + w) {
        work2 = (long)x +w;
      }else{
        work2 = (long)dx +dw;
      }
      hit_work = work2 - work1; 
      tmp_distance = y - dy - dh;
      if (hit_work > 0){
        if (tmp_distance < distance || tmp_distance == 0 || distance == -1){
          target = base;
          distance = tmp_distance;
        }
      }
    }
  }else if (direction == WS_DOWN || direction == WS_RET){
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)(*list)[i];
      if (base == this || base->getVisible() == False){
	    continue;
      }
      base->getPropertyV(WSNy,&dy);
      if (dy  < y +h){
	    continue;
      }
      base->getPropertyV(WSNx,&dx);
      base->getPropertyV(WSNwidth,&dw);
      if (dx > x) {
        work1 = (long)dx;
      }else{
        work1 = (long)x;
      }
      if (dx + dw  > x + w) {
        work2 = (long)x +w;
      }else{
        work2 = (long)dx +dw;
      }
      hit_work = work2 - work1; 
      tmp_distance = dy - y - h;
      if (hit_work > 0){
        if (tmp_distance < distance || tmp_distance == 0 || distance == -1){
          target = base;
          distance = tmp_distance;
        }
      }
    }
  }else if (direction == WS_LEFT || direction == WS_STAB){
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)(*list)[i];
      if (base == this || base->getVisible() == False){
        continue;
      }
      base->getPropertyV(WSNx,&dx);
      base->getPropertyV(WSNwidth,&dw);
      if (dx + dw > x +1){
        continue;
      }
      base->getPropertyV(WSNy,&dy);
      base->getPropertyV(WSNheight,&dh);
      if (dy > y) {
        work1 = (long)dy;
      }else{
        work1 = (long)y;
      }
      if (dy + dh  > y + h) {
        work2 = (long)y +h;
      }else{
        work2 = (long)dy +dh;
      }
      hit_work = work2 - work1; 
      tmp_distance = x - dx - dw;
      if (hit_work > 0){
        if (tmp_distance < distance || tmp_distance == 0 || distance == -1){
          target = base;
          distance = tmp_distance;
        }
      }
    }
  }else if (direction == WS_RIGHT || direction == WS_TAB){
    for(i=0; i < num; i++){
      WSCbase* base = (WSCbase*)(*list)[i];
      if (base == this || base->getVisible() == False){
        continue;
      }
      base->getPropertyV(WSNx,&dx);
      if ( x +w > dx){
        continue;
      }
      base->getPropertyV(WSNy,&dy);
      base->getPropertyV(WSNheight,&dh);
      if (dy > y) {
        work1 = (long)dy;
      }else{
        work1 = (long)y;
      }
      if (dy + dh  > y + h) {
        work2 = (long)y +h;
      }else{
        work2 = (long)dy +dh;
      }
      hit_work = work2 - work1; 
      tmp_distance = dx - x - w;
      if (hit_work > 0){
        if (tmp_distance < distance || tmp_distance == 0 || distance == -1){
          target = base;
          distance = tmp_distance;
        }
      }
    }
  }
  if (direction == WS_TAB && target == NULL){
    return _get_focus_move_instance(WS_DOWN);
  }
  if (direction == WS_STAB && target == NULL){
    return _get_focus_move_instance(WS_UP);
  }
  return target;
}

void WSCbase::setCreateHandler(char* cname,WSCbase* (*hd)(WSCbase*,char* )){
  if (_create_proc_list == NULL){
    _create_proc_list = new WSClistData();
    _cname_list = new WSClistData();
  }
  long num = _cname_list->getNum();
  long i;
  for(i=0; i<num; i++){
    char* str = (char*)(*_cname_list)[i];
    if (!WSGFstrcmp(str,cname)){
       _create_proc_list->setData(i,(void*)hd);
       return;
    }
  }
  _create_proc_list->add((void*)hd);
  _cname_list->add((void*)WSGFstrdup(cname));
}

WSClistData* WSCbase::getSupportedClassList(){
  static WSClistData _ret;
  _ret.clear();
  long i;
  long num = _cname_list->getNum();
  for(i=0; i<num; i++){
    WSCbase* (*hd)(WSCbase*,char*);
    hd = (WSCbase*(*)(WSCbase*,char*))(*_create_proc_list)[i];
    if (hd != NULL){
      _ret.add( (*_cname_list)[i] );
    }
  }
  return &_ret;
}
WSCbase* WSCbase::getNewInstance(char* cname,WSCbase* parent,char* name){
  if (_create_proc_list == NULL){
    return NULL;
  }
  long i;
  long num = _create_proc_list->getNum();
  for(i=0; i<num; i++){
    if (!WSGFstrcmp( (char*)(*_cname_list)[i],cname)){
      WSCbase* (*hd)(WSCbase*,char*);
      hd = (WSCbase*(*)(WSCbase*,char*))(*_create_proc_list)[i];
      if (hd != NULL){
        return hd(parent,name);
      }else{
        return NULL;
      }
    }
  }
  if (_create_instance_handler != NULL){
    return _create_instance_handler(cname,parent,name);
  }

  return NULL;
}
long WSCbase::setOrder(char direct){
  WSCbase* parent = getParent();
  if (parent == NULL){
    return WS_ERR;
  }
  WSClistData children = getParent()->getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num ; i++){
    WSCbase* child = (WSCbase*)children[i];
    if (child == this){
      if (direct != WS_TOP){
        getParent()->getChildren().delPos(i);
        getParent()->getChildren().add((void*)this);
      }else{
        getParent()->getChildren().delPos(i);
        getParent()->getChildren().add((void*)this,0);
      }
      break;
    }
  }
  WSDdev* dev = _dev;
  if (dev != NULL){
    dev->setEventOrder(dev,direct);
  }
  return WS_NO_ERR;
}
WSCbase* WSCbase::getChildInstance(char* oname){
  if (oname[0] == _instance_name[0] && !strcmp(oname,_instance_name)){
    return this;
  }
  WSClistData children = getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i < num; i++){
    WSCbase* child = (WSCbase*)children[i];
    WSCbase* ret = child->getChildInstance(oname);
    if (ret != NULL){
      return ret;
    }
  }
  return NULL;
}
long WSCbase::getAllChildren(WSClistData& list){
  WSClistData children = getChildren();
  long num = children.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCbase* child =(WSCbase*)children[i];
    list.add((void*)child);
    WSClistData tmplist;
    child->getAllChildren(tmplist);
    long j;
    long cnum = tmplist.getNum();
    for(j=0; j<cnum; j++){
      list.add(tmplist[j]);
    }
  }
  return WS_NO_ERR;
}
WSCbool WSCbase::getMouseAddr(short* x,short* y){
  return WSGIappMouse()->getMousePosition(x,y,this);
}
long WSCbase::getInstanceNameHashValue(){
  return _name_hash_value;
}
char* WSCbase::getUseDevName(){
  return NULL;
}

WSCbase* WSCbase::getFocusInstance(){
  return _focus_instance;
}
WSCbase* WSCbase::getSpecialFocusInstance(){
  return _special_focus_instance;
}

long WSCbase::setFocus(WSCbool fl){
  if (fl != False){
    WSCbase* focus_lost_instance = NULL;
    if (_focus_instance != NULL){
      if (_focus_instance != this){
        focus_lost_instance = _focus_instance;
        _focus_instance = NULL;
        focus_lost_instance->onFocusChange(False);
        focus_lost_instance->execProcedure(WSEV_FOCUS_CH);
      }
    }
    if (_focus_instance != this){
      _focus_instance = this;
      onFocusChange(fl);
      execProcedure(WSEV_FOCUS_CH);
      if (focus_lost_instance != NULL && getObjectType() & WS_TYPE_MANAGER){
        WSClistData children;
        getAllChildren(children);
        long num = children.getNum();
        long i;
        for(i=0; i<num; i++){
          WSCbase* child = (WSCbase*)children[i];
          if (child == focus_lost_instance){
            focus_lost_instance->setFocus(True);
            break;
          }
        }
      }
      return WS_NO_ERR;
    }
 
  }else{
    if (_focus_instance == this){
      _focus_instance = NULL;
      onFocusChange(fl);
      execProcedure(WSEV_FOCUS_CH);
    }
  }
  return WS_NO_ERR;
}

long WSCbase::setSpecialFocus(WSCbool fl){
  if (fl != False){
    WSCbase* focus_lost_instance = NULL;
    if (_special_focus_instance != NULL){
      if (_special_focus_instance != this){
        focus_lost_instance = _special_focus_instance;
        _special_focus_instance = NULL;
        focus_lost_instance->onSpecialFocusChange(False);
//        focus_lost_instance->execProcedure(WSEV_FOCUS_CH);
      }
    }
    if (_special_focus_instance != this){
      _special_focus_instance = this;
      onSpecialFocusChange(fl);
//      execProcedure(WSEV_FOCUS_CH);
      if (focus_lost_instance != NULL && getObjectType() & WS_TYPE_MANAGER){
        WSClistData children;
        getAllChildren(children);
        long num = children.getNum();
        long i;
        for(i=0; i<num; i++){
          WSCbase* child = (WSCbase*)children[i];
          if (child == focus_lost_instance){
            focus_lost_instance->setSpecialFocus(True);
            break;
          }
        }
      }
      return WS_NO_ERR;
    }
 
  }else{
    if (_special_focus_instance == this){
      _special_focus_instance = NULL;
      onSpecialFocusChange(fl);
//      execProcedure(WSEV_FOCUS_CH);
    }
  }
  return WS_NO_ERR;
}



WSCbool WSCbase::getFocus(){
  if (_focus_instance == this){
    return True;
  }else{
    return False;
  }
  return False;
}
WSCbool WSCbase::getSpecialFocus(){
  if (_special_focus_instance == this){
    return True;
  }else{
    return False;
  }
  return False;
}

void WSCbase::setChildren(WSClistData&){
}
WSCbase* WSCbase::getPropertyInheritChild(){
  return NULL;
}
WSClistData& WSCbase::getChildren(){
static WSClistData tmp;
  tmp.clear();
  return tmp;
}
WSCbool WSCbase::existTrigger(long trg){
  return _own_class_info->existTrigger(trg);
}
WSCindexData* WSCbase::getExtTriggerList(){
  return _own_class_info->getAllExtTriggerList();
}
void WSCbase::setInstanceName(char* name){
  if (_instance_name != NULL){
    delete _instance_name;
  }
  if (name == NULL){
    name = "none";
  }
  _instance_name = WSGFstrdup(name);
  _name_hash_value = WSGFgetHashValue(name);
}
char* WSCbase::getInstanceName(){
  return _instance_name;
}
long WSCbase::draw(){
  return WS_NO_ERR;
}

long WSCbase::cdraw(){
  return WS_NO_ERR;
}

WSCbool WSCbase::getDotMode(){
  return _property_edit_mode;
}
void WSCbase::setScaleOffsetPtr(double* ptr){
  if (_scale_ptrs == NULL){
    _scale_ptrs = new void*[3];
    _scale_ptrs[0] = NULL;
    _scale_ptrs[1] = NULL;
    _scale_ptrs[2] = NULL;
  }
  _scale_ptrs[2] = ptr;
  if (_dev != NULL){
    _dev->setValue(WSDEV_SCALE_OFFSET,_scale_ptrs[2]);
  }
}
void WSCbase::setXOffsetPtr(short* ptr){
  if (_scale_ptrs == NULL){
    _scale_ptrs = new void*[3];
    _scale_ptrs[0] = NULL;
    _scale_ptrs[1] = NULL;
    _scale_ptrs[2] = NULL;
  }
  _scale_ptrs[0] = ptr;
  if (_dev != NULL){
    if( !(getObjectType() &WS_TYPE_WINDOW )){
      _dev->setValue(WSDEV_X_OFFSET,_scale_ptrs[0]);
    }
  }
}
void WSCbase::setYOffsetPtr(short* ptr){
  if (_scale_ptrs == NULL){
    _scale_ptrs = new void*[3];
    _scale_ptrs[0] = NULL;
    _scale_ptrs[1] = NULL;
    _scale_ptrs[2] = NULL;
  }
  _scale_ptrs[1] = ptr;
  if (_dev != NULL){
    if( !(getObjectType() &WS_TYPE_WINDOW )){
      _dev->setValue(WSDEV_Y_OFFSET,_scale_ptrs[1]);
    }
  }
}
double* WSCbase::getScaleOffsetPtr(){
  if (_scale_ptrs != NULL){
    return (double*)_scale_ptrs[2];
  }
  return NULL;
}
short* WSCbase::getXOffsetPtr(){
  if (_scale_ptrs != NULL){
    return (short*)_scale_ptrs[0];
  }
  return NULL;
}
short* WSCbase::getYOffsetPtr(){
  if (_scale_ptrs != NULL){
    return (short*)_scale_ptrs[1];
  }
  return NULL;
}
WSCbool WSCbase::getPropertyEditMode(){
  return _property_edit_mode;
}
WSCbool WSCbase::isNeedUpdate(){
  return _update_registered;
}
void WSCbase::_register_focus_move(){
  if (_parent == NULL){
    return;
  }
  WSClistData* list = (WSClistData*)_parent->getUserData("FOCUS_LIST");
  if (list == NULL){
    list = new WSClistData();
    _parent->setUserData("FOCUS_LIST",list);
  }
  list->add(this);
}
void WSCbase::setInternalObject(WSCbool fl){
  _internal_object = fl;
}
WSCbool WSCbase::getInternalObject(){
  return _internal_object;
}
long WSCbase::getObjectType(){
  return 0;
}
long WSCbase::getVer(long ver){
  return ver;
}
long WSCbase::checkVersion(long ver){
  if (ver/10 == getVer()/10){
    return 1;
  }
WSMFtrace("VERSION error. WSCbase object_version=%d, This WSCbase object_version=%d\n",WSCbase_VER,ver);
fprintf(stderr,"VERSION error. WSCbase object_version=%d, This WSCbase object_version=%d\n",WSCbase_VER,ver);
  return 0;
}
WSDdev* WSCbase::attachdev(){
  if(_dev == NULL){
    WSDdev* dev = WSGIappDevice()->getDevObject(getUseDevName());
    if (dev != NULL){
      setdev(dev);
    }
  }
  return _dev;
}

void WSCbase::onSelectionChange(WSCbool fl){
  execProcedure(WSEV_SELECTION_CH);
}
char* WSCbase::getDefaultProperty(){
  return "";
}
void WSCbase::setGeometryChanged(WSCbool fl){
  _geometry_changed = fl;
}
WSCbool WSCbase::isParent(WSCbase* inst){
  WSCbase* parent = getParent();
  while(1){
    if (parent == NULL){
      return False;
    }
    if (parent == inst){
      return True;
    }
    parent = parent->getParent();
  }
}

void WSCbase::setExported(WSCbool fl){
  if (_export_bk == False){
    if (fl != False){
      WSGIappObjectList()->addExportInstanceUpdateList(this);
    }
  }else{
    if (fl == False){
      WSGIappObjectList()->addExportInstanceDeleteList(this);
    }
  }
  _export_ = fl;
  _export_bk = fl;
}
WSCbool WSCbase::getExported(){
  return _export_;
}

void WSCbase::setExportName(char* name){
  char* ename = (char*)getUserData("export-name");
  if (ename != NULL){
    delete ename;
  }
  setUserData("export-name",WSGFstrdup(name));
}
char* WSCbase::getExportName(){
  char* ename = (char*)getUserData("export-name");
  if (ename != NULL){
    return ename;
  }
  return "";
}
WSCbase* (*WSCbase::_create_instance_handler)(char*,WSCbase*,char*) = NULL;
void WSCbase::setCreateInstanceHandler(WSCbase* (*hd)(char*,WSCbase*,char*)){
  _create_instance_handler = hd;
}
WSCbool WSCbase::adjustAnchor(){
  return True;
}

long WSCbase::addProcedure(char* pname,char* fname,long ev){
  WSCprocedure* op = new WSCprocedure(pname,ev);
  op->setFunction(NULL,fname);
  addProcedure(op); 
  return WS_NO_ERR;
}

