//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCfileSelect.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCscrForm.h>
#include <WSCvkflabel.h>
#include <WSCoption.h>
#include <WSCvtoggle.h>
#include <WSCvifield.h>
#include <WSCvbtn.h>
#include <WSDkeyboard.h>
#include <WSCimageSet.h>
#include <WSCbaseList.h>
#include <WSDfileSystem.h>
#include <WSCvlabel.h>
#include <WSCinputDialog.h>
#include <WSCmessageDialog.h>
#include <WSDappDev.h>

#ifndef MSW
#define GETCWD getcwd
#include <unistd.h>
#include <sys/stat.h>
#else
#define GETCWD _getcwd
#include <direct.h>
#endif

#define WS_MYCOMPUTER "My Computer"
#define WS_MYNETWORK  "My Network"

#define WS_FS_MAX_FILE_COUNTS 1024

#define WS_UP_PIX     WS_PIXMAP_DIR "bi18.xpm"
#define WS_UP2_PIX    WS_PIXMAP_DIR "bi15.xpm"
#define WS_MKDIR_PIX  WS_PIXMAP_DIR "bi19.xpm"
#define WS_DIR_PIX    WS_PIXMAP_DIR "bi16.xpm"
#define WS_FILE_PIX   WS_PIXMAP_DIR "bi17.xpm"
#define WS_FILES_PIX  WS_PIXMAP_DIR "bi13.xpm"
//#define WS_FS_BGCOLOR1  "gray85"
//#define WS_FS_BGCOLOR2  "gray80"
//#define WS_FS_SLBARBG1  "gray75"
//#define WS_FS_SELECTBG  "slategray2"
#define WS_FS_BGCOLOR1  WS_DF_WORKBACKCOLOR
#define WS_FS_BGCOLOR2  WS_DF_DARKBACKCOLOR
#define WS_FS_SLBARBG1  WS_DF_BARSHADOWCOLOR
#define WS_FS_SELECTBG  WS_DF_MENUSELECTCOLOR
#define WS_FS_T         18
#define WS_FS_H         18
#define WS_FS_W1        21
#define WS_FS_W2        1000
#define WS_FS_X1        5
#define WS_FS_X2        25

WSMFguiClassInitialize(WSCfileSelect,WSCbaseDialog);
WSMFversion(WSCfileSelect,WSCbaseDialog);

static WSCfileSelect* _the_app_file_select = NULL;

WSCfileSelect* WSGIappFileSelect(){
  if (_the_app_file_select == NULL){
    _the_app_file_select = new WSCfileSelect(NULL,"app-fselect");
    if (_the_app_file_select == NULL){
//      assert(0);
      return NULL;
    }else{
      _the_app_file_select->initialize();
      _the_app_file_select->setPropertyV(WSNwidth,(WSCushort)(300));
      _the_app_file_select->setPropertyV(WSNheight,(WSCushort)(400));
    }
  }
  return _the_app_file_select;
};




WSCfileSelect::WSCfileSelect(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){
  _form = NULL;
  _dir_if = NULL;
  _file_if = NULL;
  _mask_if = NULL;
  _scr_form = NULL;
  _form2 = NULL;
//  _scr_form2 = NULL;
  _dir_name = WSGFstrdup("");
  _file_name = WSGFstrdup("");
  _mask_name = WSGFstrdup("");
  _mkdir_dlg = NULL;
  _no = False;
  _w = 250;
  _h = 300;
  _select_dir = False;
  _wbg_no = WS_DF_DARKBACKCOLOR;
  _need_update_fl = True;
  _desktop = False;
  _network = False;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCfileSelect);
    WSMFpropertyCreate(WSNdirName,      char*, _dir_name,WSSdirName );
    WSMFpropertyCreate(WSNfileName,     char*, _file_name,WSSfileName  );
    WSMFpropertyCreate(WSNmaskFileName, char*, _mask_name,WSSmaskFileName );
    WSMFpropertyCreate(WSNselectDir, WSCbool, _select_dir,WSSselectDir );
      WSMFpropertySetSelection(WSRbool3,WSRbool3D);
    WSMFpropertyCreate(WSNworkBackColor,  short, _wbg_no,WSSworkBackColor );

    WSMFpropertyDelete(WSNno);
    WSMFpropertyDelete(WSNnoString);
    WSMFpropertyDelete(WSNshadowThickness);

  WSMFpropertyCreateEnd

}
WSMFproperty( WSCfileSelect, WSNdirName,  char*, _dir_name,  WSGFstrdup(""));
WSMFproperty( WSCfileSelect, WSNfileName, char*, _file_name, WSGFstrdup(""));
WSMFproperty( WSCfileSelect, WSNmaskFileName, char*, _mask_name, WSGFstrdup(""));
WSMFproperty( WSCfileSelect, WSNselectDir, WSCbool, _select_dir, False);
WSMFproperty( WSCfileSelect, WSNworkBackColor,short, _wbg_no ,WS_DF_DARKBACKCOLOR);


void WSCfileSelect::setWorkWSNselectDir(WSCbool data){
   if (data == False){
     _file_if->setProperty(WSNdet,True);
//     _file_if->setProperty(WSNbackColor,"gray85");
     _file_if->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
   }else{
     _file_if->setProperty(WSNdet,False);
//     _file_if->setProperty(WSNbackColor,"gray80");
     _file_if->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
   }
}
void WSCfileSelect::getWorkWSNselectDir(WSCbool* data){ }

void WSCfileSelect::setWorkWSNdirName(char* data){
  char buf[2048];
  char buf2[2048];
  if (_dir_if != NULL){
    if (data[0] == '.' && data[1] !=  '.'){
      GETCWD(buf,2048);
      sprintf(buf2,"%s%s",buf,&data[1]);
      data = buf2;
    }else if (data[0] == '.' && data[1] ==  '.'){
      GETCWD(buf,2048);
      sprintf(buf2,"%s/%s",buf,data);
      data = buf2;
    }
    WSCstring tmp(data);
    tmp.replaceString("\\","/",0);
    _dir_if->setPropertyV(WSNlabelString,tmp.getString());
    if (getVisible() != False){
      _update_list();
    }
  }
}
void WSCfileSelect::getWorkWSNdirName(char** data){
  if (_dir_if != NULL){
    delete _dir_name;
    char* dt;
    _dir_if->getPropertyV(WSNlabelString,&dt);
    WSCstring str(dt);
    str.delHeadSpace();
    str.delTailSpace();
    str.replaceString("\\","/",0);
    _dir_name = WSGFstrdup(str.getString());
    *data = _dir_name;
  }
}
void WSCfileSelect::setWorkWSNfileName(char* data){
  if (_file_if != NULL){
    WSCstring tmp(data);
    tmp.replaceString("\\","/",0);
    _file_if->setPropertyV(WSNlabelString,data);
  }
}
void WSCfileSelect::getWorkWSNfileName(char** data){
  if (_file_if != NULL){
    delete _file_name;
    char* dt;
    _file_if->getPropertyV(WSNlabelString,&dt);
    WSCstring str(dt);
    str.delHeadSpace();
    str.delTailSpace();
    str.replaceString("\\","/",0);
    _file_name = WSGFstrdup(str.getString());
    *data = _file_name;
  }
}
void WSCfileSelect::setWorkWSNmaskFileName(char* data){
  if (_mask_if != NULL){
    _mask_if->setPropertyV(WSNlabelString,data);
    if (getVisible() != False){
      _update_list();
    }
  }
}
void WSCfileSelect::getWorkWSNmaskFileName(char** data){
  if (_mask_if != NULL){
    delete _mask_name;
    char* dt;
    _mask_if->getPropertyV(WSNlabelString,&dt);
    _mask_name = WSGFstrdup(dt);
    *data = _mask_name;
  }
}
void WSCfileSelect::setWorkWSNworkBackColor(short no){
  if (_form2 != NULL){
    _form2->setProperty(WSNbackColor,no);
  }
  if (_scr_form != NULL){
    _scr_form->setProperty(WSNbackColor,no);
  }
}
void WSCfileSelect::getWorkWSNworkBackColor(short* ){}

void WSCfileSelect::update(){
  if (_need_update_fl != False){
    _update_list();
    _need_update_fl = False;
  }
  WSCbaseDialog::update();
}

void WSCfileSelect::_update_list(){
  if (getVisible() == False){
    return;
  }
//  _scr_form2->setVisible(False);    
  long i;
  long dnum = 0;
  long num = _icon_list.getNum();
  for(i=0; i<num; i++){
    WSCbase* icon  = (WSCbase*)_icon_list.getData(i);
    icon->setVisible(False);
    WSCbase* label = (WSCbase*)_label_list.getData(i);
    label->setVisible(False);
  }
  long cnt = 0;
  if (_dir_if != NULL ){
    WSClistData* dir_list = NULL;
#ifdef MSW
    if (_desktop == False && _network == False){
#endif //MSW
      dir_list = WSGIappFileSystem()->
             showDir(_dir_if->getProperty(WSNlabelString));
      if (dir_list == NULL){
        dir_list = new WSClistData;
      }
#ifdef MSW
    }else if (_network != False){
      WSCstring dirn =_dir_if->getProperty(WSNlabelString);
      if (strcmp("",dirn)){
        long ndirs = dirn.getWords("/");
        if (!strncmp("//",dirn.getString(),2) && ndirs == 3){
          dir_list = WSGIappFileSystem()->
             showNetDir(dirn,_provider_name);
        }else{
          dir_list = WSGIappFileSystem()->
             showDir(_dir_if->getProperty(WSNlabelString));
        }
      }else{
        dir_list = WSGIappFileSystem()->
             showNetDir(_workgroup_name,_provider_name);
      }
      if (dir_list == NULL){
        dir_list = new WSClistData;
      }

    }else{
      dir_list = new WSClistData;
      dir_list->add(WSGFstrdup(WS_MYCOMPUTER));
      dir_list->add(WSGFstrdup(WS_MYNETWORK));
    }
#endif //MSW
    dir_list->add(WSGFstrdup("parent directory"),0);

    if (dir_list != NULL){
      num = dir_list->getNum();
      dnum = num;
      for(i=0; i<num; i++){
        if (i >= WS_FS_MAX_FILE_COUNTS){
          dnum = WS_FS_MAX_FILE_COUNTS;
          delete (char*)dir_list->getData(i);
          continue;
        }
        WSCbase* icon  = (WSCbase*)_icon_list.getData(i);
        WSCbase* flabel = (WSCbase*)_label_list.getData(i);
        if (icon == NULL){
          icon = new WSCvlabel(_scr_form,"fs-icon");
//          icon = new WSCvlabel(_scr_form2,"fs-icon");
          icon->initialize();
          icon->setInternalObject(True);
          icon->setVisible(False);
          icon->setPropertyV(WSNx,(short)WS_FS_X1);
          icon->setPropertyV(WSNwidth,(WSCushort)WS_FS_W1);
          icon->setPropertyV(WSNheight,(WSCushort)WS_FS_H);
          icon->setPropertyV(WSNshadowThickness,(WSCuchar)0);
          _icon_list.add((void*)icon);
          WSCprocedure* lbop1 = new WSCprocedure("lbop",WSEV_MOUSE_PRESS);
          lbop1->setInternal(True);
          lbop1->setFunction(_label_btn_work,"_label_btn_work");
          icon->addProcedure(lbop1);

          flabel = new WSCvkflabel(_scr_form,"fs-label");
//          flabel = new WSCvlabel(_scr_form2,"fs-label");
          flabel->initialize();
          flabel->setInternalObject(True);
          flabel->setVisible(False);
          flabel->setPropertyV(WSNx,(short)WS_FS_X2);
          flabel->setPropertyV(WSNwidth,(WSCushort)WS_FS_W2);
          flabel->setPropertyV(WSNheight,(WSCushort)WS_FS_H);
          flabel->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
          flabel->setPropertyV(WSNshadowThickness,(WSCuchar)0);
          flabel->setUserData("FS EDIT",(void*)this);
          flabel->setUserData("this",(void*)((WSCbase*)flabel));
          icon->setUserData("this",(void*)((WSCbase*)flabel));
          _label_list.add((void*)flabel);

          WSCprocedure* lbop = new WSCprocedure("lbop",WSEV_MOUSE_PRESS);
          lbop->setInternal(True);
          lbop->setFunction(_label_btn_work,"_label_btn_work");
          flabel->addProcedure(lbop);

          WSCprocedure* lbop2 = new WSCprocedure("lbop",WSEV_KEY_PRESS);
          lbop2->setInternal(True);
          lbop2->setFunction(_label_btn_key_work,"_label_btn_key_work");
          flabel->addProcedure(lbop2);

        }
        icon->setPropertyV(WSNy,(short)(i*WS_FS_T));
        if (i== 0){
          icon->setPropertyV(WSNlabelPixmap,WS_UP_PIX);
        }else{
          icon->setPropertyV(WSNlabelPixmap,WS_DIR_PIX);
        }
        icon->setVisible(True);
//        icon->redraw();
        long flg = (long)False;
        flabel->setPropertyV(WSNy,(short)(i*WS_FS_T));
        flabel->setPropertyV(WSNlabelString,(char*)dir_list->getData(i));
        icon->setProperty(WSNbackColor,WS_FS_BGCOLOR1);
        flabel->setProperty(WSNbackColor,WS_FS_BGCOLOR1);
        flabel->setProperty(WSNforeColor,WS_DF_NWFORECOLOR);
        flabel->setUserData("FILE",(void*)flg);
        flabel->setVisible(True);
//        flabel->redraw();
        delete (char*)dir_list->getData(i);
      }
      delete dir_list;
    }
    if (_select_dir == False){
      WSClistData* file_list = NULL;
#ifdef MSW
      if (_network != False){
        if (strcmp("",_provider_name) && strcmp("",_workgroup_name)){
          file_list = WSGIappFileSystem()->
             showFile(_dir_if->getProperty(WSNlabelString));
        }
      }else{
#endif
        file_list = WSGIappFileSystem()->
             showFile(_dir_if->getProperty(WSNlabelString));
#ifdef MSW
      }
#endif
      if (file_list != NULL){
        num = file_list->getNum();
        WSCstring tmp(getProperty(WSNmaskFileName));
        tmp.delHeadSpace();
        tmp.delTailSpace();
        tmp.delLineFeed();
        WSCstring mask(".");
        mask.addString(tmp);
        num = file_list->getNum();
        for(i=0; i<num; i++){
          if (i+dnum > WS_FS_MAX_FILE_COUNTS){
            continue;
          }
          char* filename = (char*)file_list->getData(i);
          WSCstring tmp2(filename);
          long pos = tmp2.isExist(mask.getString());
          if (strcmp(tmp.getString(),"")){
#ifdef MSW
            if ( pos == -1){
              WSCstring mask2(mask);
              mask2.to_upper();
              pos = tmp2.isExist(mask2.getString());
            }
#endif
            if ( pos == -1){
              continue;
            }else{
              WSCstring mask2(mask.getString());
              mask2.addString(".");
              // except for back files as XXX.mask.bk,etc..
              if (tmp2.isExist(mask2.getString()) != -1){
                continue;
              }
            }
          }
          WSCbase* icon  = (WSCbase*)_icon_list.getData(cnt+dnum);
          WSCbase* flabel = (WSCbase*)_label_list.getData(cnt+dnum);
          if (icon == NULL){
            icon = new WSCvlabel(_scr_form,"fs-icon");
//            icon = new WSCvlabel(_scr_form2,"fs-icon");
            icon->initialize();
            icon->setInternalObject(True);
            icon->setVisible(False);
            icon->setPropertyV(WSNx,(short)WS_FS_X1);
            icon->setPropertyV(WSNwidth,(WSCushort)WS_FS_W1);
            icon->setPropertyV(WSNheight,(WSCushort)WS_FS_H);
            icon->setPropertyV(WSNshadowThickness,(WSCuchar)0);
            _icon_list.add((void*)icon);
 
            flabel = new WSCvkflabel(_scr_form,"fs-label");
//            flabel = new WSCvlabel(_scr_form2,"fs-label");
            flabel->initialize();
            flabel->setInternalObject(True);
            flabel->setVisible(False);
            flabel->setPropertyV(WSNx,(short)WS_FS_X2);
            flabel->setPropertyV(WSNwidth,(WSCushort)WS_FS_W2);
            flabel->setPropertyV(WSNheight,(WSCushort)WS_FS_H);
            flabel->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
            flabel->setPropertyV(WSNshadowThickness,(WSCuchar)0);
            flabel->setUserData("FS EDIT",(void*)this);
            flabel->setUserData("this",(void*)((WSCbase*)flabel));
            icon->setUserData("this",(void*)((WSCbase*)flabel));
            _label_list.add((void*)flabel);
 
            WSCprocedure* lbop = new WSCprocedure("lbop",WSEV_MOUSE_PRESS);
            lbop->setInternal(True);
            lbop->setFunction(_label_btn_work,"_label_btn_work");
            flabel->addProcedure(lbop);

            WSCprocedure* lbop2 = new WSCprocedure("lbop",WSEV_KEY_PRESS);
            lbop2->setInternal(True);
            lbop2->setFunction(_label_btn_key_work,"_label_btn_key_work");
            flabel->addProcedure(lbop2);

          }
          icon->setPropertyV(WSNy,(short)((cnt +dnum)*WS_FS_T));
          icon->setPropertyV(WSNlabelPixmap,WS_FILE_PIX);
          icon->setVisible(True);
//          icon->redraw();

          long flg = (long)True;
          flabel->setPropertyV(WSNy,(short)((cnt +dnum)*WS_FS_T));
          flabel->setPropertyV(WSNlabelString,(char*)file_list->getData(i));
          icon->setProperty(WSNbackColor,WS_FS_BGCOLOR1);
          flabel->setProperty(WSNbackColor,WS_FS_BGCOLOR1);
          flabel->setProperty(WSNforeColor,WS_DF_NWFORECOLOR);
          flabel->setUserData("FILE",(void*)flg);
          flabel->setVisible(True);
//          flabel->redraw();
          cnt++;
        }
        for(i=0; i<num; i++){
          delete (char*)file_list->getData(i);
        }
        delete file_list;
      }
    }
  }
  _scr_form->setPropertyV(WSNvbarValue,(WSCushort)0);
  _scr_form->setPropertyV(WSNworkHeight,(WSCushort) ((cnt +dnum + 5)*WS_FS_T ));
//  _scr_form2->setVisible(True);    
  _scr_form->getScrFrame()->redraw();  
}

WSCfileSelect::~WSCfileSelect(){
  delete _dir_name;
  delete _file_name;
  delete _mask_name;
}

void WSCfileSelect::_dir_if_work(WSCbase* obj){
  WSCfileSelect* fs = (WSCfileSelect*)obj->getUserData("FS EDIT");
  fs->_update_list();
}
void WSCfileSelect::_label_btn_key_work(WSCbase* obj1){
  long key = WSGIappKeyboard()->getKey();
//printf("WSCfileSelect::_label_btn_key_work..\n");
  if (key != WSK_Up && key != WSK_Down){
    return;
  }

  WSCbase* obj = (WSCbase*)obj1->getUserData("this");
  WSCfileSelect* fs = (WSCfileSelect*)obj->getUserData("FS EDIT");

  long i;
  long num = fs->_label_list.getNum();
  WSCbase* pre = NULL;
  WSCbase* target = NULL;
  WSCbase* next = NULL;
  for(i=0; i<num; i++){
    WSCbase* lb = (WSCbase*)(fs->_label_list[i]);
    if (lb == obj1){
      if ( i > 0){
        WSCbase* plb = (WSCbase*)fs->_label_list[i-1];
        pre = plb;
      }
      WSCbase* nlb = (WSCbase*)fs->_label_list[i+1];
      if (nlb != NULL && nlb->getVisible() == True){
        next = nlb;
      }else{
        next = NULL;
      }
      target = obj1;
      break;
    }
  }

  if (key == WSK_Up && target != NULL){
    if (pre != NULL){
      _label_btn_work(pre);
      return;
    }
  }

  if (key == WSK_Down && target != NULL){
    if (next != NULL){
      _label_btn_work(next);
      return;
    }
  }
}

void WSCfileSelect::_label_btn_work(WSCbase* obj1){
//  if (obj1->getFocus() == False){
//    return;
//  }
  WSCbase* obj = (WSCbase*)obj1->getUserData("this");
  WSCfileSelect* fs = (WSCfileSelect*)obj->getUserData("FS EDIT");
  WSCbool fl = (WSCbool)((long)obj->getUserData("FILE"));

  long posy = obj1->getProperty(WSNy);
  long scrpos = fs->_scr_form->getProperty(WSNvbarValue);
  long scrh = fs->_scr_form->getProperty(WSNheight);
  if (posy < scrpos){
    fs->_scr_form->setProperty(WSNvbarValue,posy);
  }
  if (posy + 40 > scrh + scrpos){
    long val = posy + 40 - scrh;
    if (val < 0){
      val =0;
    }
    fs->_scr_form->setProperty(WSNvbarValue,val);
  }



  if (fl != False){
static WSCbase* bk_obj = NULL; //double click flag...
static long      bk_time = 0;
    long clk = WSGFclocktime();
    if ( bk_obj == obj && clk - bk_time < 250){ //double clicked?
       bk_obj = NULL;
       bk_time = 0;
       void (*hd)(WSCfileSelect*);
       void* hdp;
       fs->getPropertyV(WSNreplyHandler,&hdp);
       hd = (void(*)(WSCfileSelect*))hdp;
       if (fs->getPropertyEditMode() == False){
         fs->setVisible(False);
       }
       fs->_status = WS_DIALOG_OK;
       if (hd != NULL){
         hd(fs);
         WSGIappObjectList()->execUpdate();
       }
       return;
    }
    bk_obj = obj;
    bk_time = clk;
    if (fs->_select_dir == False){
      fs->_file_if->setPropertyV(WSNlabelString,obj->getProperty(WSNlabelString));
    }
    long num = fs->_label_list.getNum();
    long i;
    for(i=0; i < num; i++){
      WSCbase* target = (WSCbase*)fs->_label_list[i];
      if (target != obj){
        target->setProperty(WSNbackColor,WS_FS_BGCOLOR1);
        target->setProperty(WSNforeColor,WS_DF_NWFORECOLOR);
      }else{
        target->setProperty(WSNbackColor,WS_FS_SELECTBG);
        target->setProperty(WSNforeColor,WS_DF_MENUSELECTFORECOLOR);
        target->setFocus();
      }
      target->update();
    }
    fs->_ok_btn->setSpecialFocus();
  }else{
    WSCstring str(obj->getProperty(WSNlabelString));
    WSCstring str2;
    long num = fs->_label_list.getNum();
    long i;
    for(i=0; i < num; i++){
      WSCbase* target = (WSCbase*)fs->_label_list[i];
      if (target != obj){
        target->setProperty(WSNbackColor,WS_FS_BGCOLOR1);
        target->setProperty(WSNforeColor,WS_DF_NWFORECOLOR);
      }else{
        target->setProperty(WSNbackColor,WS_FS_SELECTBG);
        target->setProperty(WSNforeColor,WS_DF_MENUSELECTFORECOLOR);
        target->setFocus();
      }
      target->update();
    }
    if (strcmp(str.getString(),"parent directory")){
      if (fs->_select_dir != False){
#if 0 //deleted 00/11/05
        fs->_file_if->setPropertyV(WSNlabelString,obj->getProperty(WSNlabelString));
#endif //deleted 00/11/05
      }
    }
 
static WSCbase* bk_obj = NULL; //double click flag...
static long      bk_time = 0;
    long clk = WSGFclocktime();
    if ( bk_obj == obj && clk - bk_time < 250){ //double clicked?
      bk_obj = NULL;
      bk_time = 0;
      if (!strcmp(str.getString(),"parent directory")){
        str2.setString( fs->_dir_if->getProperty(WSNlabelString) );
        str2.delTailSpace();
#ifdef MSW
//        while( str2.replaceString("\\\\","\\",0) );
        str2.replaceString("\\","/",0);
        long ndirs = str2.getWords("/");
        if (!strncmp("//",str2.getString(),2) && ndirs == 3){
          str2 = "";
          if (strcmp(fs->_workgroup_name,"") && strcmp(fs->_provider_name,"")){
          }else{
            fs->_network = False;
            fs->_provider_name ="";
            fs->_workgroup_name ="";
          }
        }
#else
        while( str2.replaceString("//","/",0) );
#endif
        char* dir = str2.getString();
        if ( strlen(dir) != 0 && !strcmp(&dir[strlen(dir)-1],"/")){
           str2.cutString( str2.getChars()-1 );
        }
        long dirs = str2.getWords("/");
        long pos = str2.getWordCharPos(dirs-1,"/");
        if (pos >0){
          str2.cutString(pos-1);
        }else{
          str2.cutString(pos);
        }
        fs->_desktop = False;
        if (!strcmp(str2.getString(),"")){
#ifdef MSW
//          str2.setString("C:/");
          WSCstring tmp;
          tmp = fs->_dir_if->getProperty(WSNlabelString);
          if (strcmp(fs->_workgroup_name,"")){
            fs->_workgroup_name ="";
          }else
          if (strcmp(fs->_provider_name,"")){
            fs->_provider_name ="";
          }else
          if (!strcmp(tmp.getString(),"")){
            fs->_desktop = True;
            fs->_network = False;
            fs->_provider_name ="";
            fs->_workgroup_name ="";
          }
#else
          str2.setString("/");
#endif
        }
        fs->_dir_if->setPropertyV(WSNlabelString,str2.getString());
        if (fs->_select_dir != False){
          long dirs = str2.getWords("/");
          long pos = str2.getWordCharPos(dirs-1,"/");
          if (pos >0){
            str2.delString(0,pos);
          }
          if (!strcmp(str2.getString(),"")){
#ifdef MSW
//            str2.setString("C:/");
#else
            str2.setString("/");
#endif
          }
#if 0 //deleted 00/11/05
          fs->_file_if->setPropertyV(WSNlabelString,str2.getString());
#endif //deleted 00/11/05
        }
        fs->_update_list();
      }else{
        WSCstring dir2(fs->_dir_if->getProperty(WSNlabelString));
#ifdef MSW
        if (strcmp(dir2,"")){
          str2.setString(dir2);
          str2.addString("/");
        }
//        while( str2.replaceString("\\\\","\\",0) ){};
        str2.replaceString("\\","/",0);
#else
        str2.setString(dir2);
        str2.addString("/");
        while( str2.replaceString("//","/",0) ){};
#endif
#ifdef MSW
        if (!strcmp((char*)str,WS_MYCOMPUTER)){
          fs->_desktop = False;
          fs->_network = False;
          fs->_provider_name ="";
          fs->_workgroup_name ="";
          str2.setString("");
        }else
        if (!strcmp((char*)str,WS_MYNETWORK)){
          fs->_desktop = False;
          fs->_network = True;
          fs->_provider_name ="";
          fs->_workgroup_name ="";
          str2.setString("");
        }else
        if (fs->_network == True && !strcmp(fs->_provider_name,"")){
          fs->_provider_name = str;
          fs->_workgroup_name ="";
          str2.setString("");
        }else
        if (fs->_network == True && strcmp(fs->_provider_name,"") &&
            !strcmp(fs->_workgroup_name,"")){
          fs->_workgroup_name = str;
          str2.setString("");
        }else{
          str2.addString(str);
        }
#else
        str2.addString(str);
#endif
        fs->_dir_if->setPropertyV(WSNlabelString,str2.getString());
        fs->_update_list();
      }
    }
    bk_obj = obj;
    bk_time = clk;
  }
}

void WSCfileSelect::_mkdir_btn_work(WSCbase* obj){
  WSCfileSelect* fs = (WSCfileSelect*)obj->getUserData("FS EDIT");
  if (fs->_mkdir_dlg == NULL){
    fs->_mkdir_dlg = new WSCinputDialog(fs,"fs-mkdir-dlg");
    fs->_mkdir_dlg->initialize();
    fs->_mkdir_dlg->setInternalObject(True);
    fs->_mkdir_dlg->setProperty(WSNdefaultPosition,True);
    fs->_mkdir_dlg->setProperty(WSNtitleString,"Input new directory name");
    fs->_mkdir_dlg->setProperty(WSNlabelString,"");
    fs->_mkdir_dlg->setProperty(WSNwidth,500);
    fs->_mkdir_dlg->setProperty(WSNheight,120);
  }
  long modal = fs->_modal;
  if (modal != False){
    fs->setProperty(WSNmodal,False);
  }
  fs->_mkdir_dlg->setProperty(WSNmodal,True);
  long ret = fs->_mkdir_dlg->popup();
  fs->_mkdir_dlg->setProperty(WSNmodal,False);
  if (ret == WS_DIALOG_OK){
    WSCstring str2( fs->_dir_if->getProperty(WSNlabelString) );
    str2.delHeadSpace();
    str2.delTailSpace();
#ifdef MSW
//    while(str2.replaceString("\\\\","\\",0)){};
    str2.replaceString("\\","/",0);
#else
    while(str2.replaceString("//","/",0)){};
#endif
    WSCstring str3( fs->_mkdir_dlg->getProperty(WSNlabelString) );
    str3.delHeadSpace();
    str3.delTailSpace();
#ifdef MSW
    str2.replaceString("/","\\",0);
    str2 << "\\" << str3;
#else
    str2 << "/" << str3;
#endif
    char* dir = str2.getString();
    long fstat = WSGIappFileSystem()->check(dir);
    ret = WS_NO_ERR;
    if (fstat == 0){
      ret = WSGIappFileSystem()->createDir(dir);
      fstat = WSGIappFileSystem()->check(dir);
    }
    if (!(fstat & WS_FS_DIR) && (fstat & WS_FS_READONLY)){
      ret = WS_ERR;
    }

    if (ret != WS_NO_ERR){
      WSCstring message;
      message << WSGFgettext("F:WSSTRCannot create directory:\n");
      message << fs->_mkdir_dlg->getProperty(WSNlabelString);
      message << WSGFgettext("G:WSSTRCannot create directory:\n");

      if (modal != False){
        fs->setProperty(WSNmodal,False);
      }
      WSCmessageDialog* msg = WSGIappMessageDialog();
      msg->setProperty(WSNwidth,500);
      msg->setProperty(WSNheight,135);
      msg->setProperty(WSNlabelString,message);
      msg->setProperty(WSNmodal,True);
      msg->setProperty(WSNdefaultPosition,True);
      msg->popup();
      msg->setProperty(WSNmodal,False);
      if (modal != False){
        fs->setProperty(WSNmodal,True);
      }
    }else{
      fs->_update_list();
    }
  }
  if (modal != False){
    fs->setProperty(WSNmodal,True);
  }
}
void WSCfileSelect::_up_btn_work(WSCbase* obj){
  WSCfileSelect* fs = (WSCfileSelect*)obj->getUserData("FS EDIT");

  WSCstring str2( fs->_dir_if->getProperty(WSNlabelString) );
  str2.delTailSpace();

#ifdef MSW
//  while(str2.replaceString("\\\\","\\",0)){};
  str2.replaceString("\\","/",0);
#else
  while(str2.replaceString("//","/",0)){};
#endif
  char* dir = str2.getString();
  if ( strlen(dir) != 0 && !strcmp(&dir[strlen(dir)-1],"/")){
    str2.cutString( str2.getChars()-1 );
  }
  long dirs = str2.getWords("/");
  long pos = str2.getWordCharPos(dirs-1,"/");
  if (pos >0){
    str2.cutString(pos-1);
  }else{
    str2.cutString(pos);
  }
  fs->_desktop = False;
  if (!strcmp(str2.getString(),"")){
#ifdef MSW
//    str2.setString("C:/");
    WSCstring tmp;
    tmp = fs->_dir_if->getProperty(WSNlabelString);
    if (strcmp(fs->_workgroup_name,"")){
      fs->_workgroup_name ="";
    }else
    if (strcmp(fs->_provider_name,"")){
      fs->_provider_name ="";
    }else
    if (!strcmp(tmp.getString(),"")){
      fs->_desktop = True;
      fs->_network = False;
      fs->_provider_name ="";
      fs->_workgroup_name ="";
    }
#else
    str2.setString("/");
#endif
  }
  fs->_dir_if->setPropertyV(WSNlabelString,str2.getString());
  fs->_update_list();
}
void WSCfileSelect::_set_btn_work(WSCbase* obj){
  WSCfileSelect* fs = (WSCfileSelect*)obj->getUserData("FS EDIT");
  fs->onActivate();
}
void WSCfileSelect::onActivate(){
  if (getStatus() != WS_DIALOG_OK){ 
    return;
  }
  if (_select_dir != False){
    setVisible(False);
    WSCbaseDialog::onActivate();
    return;
  }
  if (_dir_if->getFocus() != False){
    WSCstring tmp( _dir_if->getProperty(WSNlabelString) );
    tmp.delTailSpace();
#ifdef MSW
    tmp.replaceString("\\","/",0);
#else
    while( tmp.replaceString("//","/",0) );
#endif
    _dir_if->setProperty(WSNlabelString ,tmp);
    _update_list();
    return;
  }
  long num = _label_list.getNum();
  long i;
  //directory?
  for(i=0; i<num; i++){
    WSCbase* flabel = (WSCbase*)_label_list[i];
    if (flabel->getVisible() == True){
      WSCbool flg = (WSCbool)((long)flabel->getUserData("FILE"));
      //DEF7 : WS_DF_MENUSELECTCOLOR
      if (flg == False && !strcmp(flabel->getProperty(WSNbackColor),"DEF7" )){
        WSCstring str( flabel->getProperty(WSNlabelString));
        WSCstring str2;
        if (!strcmp(str.getString(),"parent directory")){
          str2.setString( _dir_if->getProperty(WSNlabelString) );
          str2.delTailSpace();
#ifdef MSW
//          while( str2.replaceString("\\\\","\\",0) );
          str2.replaceString("\\","/",0);
          long ndirs = str2.getWords("/");
          if (!strncmp("//",str2.getString(),2) && ndirs == 3){
            str2 = "";
            _network = False;
            _provider_name ="";
            _workgroup_name ="";
          }
#else
          while( str2.replaceString("//","/",0) );
#endif
          char* dir = str2.getString();
          if ( strlen(dir) != 0 && !strcmp(&dir[strlen(dir)-1],"/")){
             str2.cutString( str2.getChars()-1 );
          }
          long dirs = str2.getWords("/");
          long pos = str2.getWordCharPos(dirs-1,"/");
          if (pos >0){
            str2.cutString(pos-1);
          }else{
            str2.cutString(pos);
          }
          _desktop = False;
          if (!strcmp(str2.getString(),"")){
#ifdef MSW
//           str2.setString("C:/");
             WSCstring tmp;
             tmp = _dir_if->getProperty(WSNlabelString);
             if (!strcmp(tmp.getString(),"")){
               _desktop = True;
             }
#else
           str2.setString("/");
#endif
          }
          _dir_if->setPropertyV(WSNlabelString,str2.getString());
          _update_list();
        }else{
          str2.setString(_dir_if->getProperty(WSNlabelString));
#ifdef MSW
          str2.addString("\\");
//          while( str2.replaceString("\\\\","\\",0) ){};
          str2.replaceString("\\","/",0);
#else
          str2.addString("/");
          while( str2.replaceString("//","/",0) ){};
#endif

#ifdef MSW
          if (!strcmp((char*)str,WS_MYCOMPUTER)){
            _desktop = False;
            _network = False;
            _provider_name ="";
            _workgroup_name ="";
            str2.setString("");
          }else
          if (!strcmp((char*)str,WS_MYNETWORK)){
            _desktop = False;
            _network = True;
            _provider_name ="";
            _workgroup_name ="";
            str2.setString("");
          }else
          if (_network == True && !strcmp(_provider_name,"")){
            _provider_name = str;
            _workgroup_name ="";
            str2.setString("");
          }else
          if (_network == True && strcmp(_provider_name,"") &&
              !strcmp(_workgroup_name,"")){
            _workgroup_name = str;
            str2.setString("");
          }else{
            str2.addString(str);
          }
#else
          str2.addString(str);
#endif
          _dir_if->setPropertyV(WSNlabelString,str2.getString());
          _update_list();
        }
        WSCbase* tlb = (WSCbase*)_label_list[0];
        if (tlb != NULL && tlb->getVisible() != False){
          _label_btn_work(tlb);
        }
        return;
      }
    }
  }
  char* filename;
  getPropertyV(WSNfileName,&filename);
  if (!strcmp(filename,"")){
    _update_list();
    return;
  }
  setVisible(False);
  WSCbaseDialog::onActivate();
}

long WSCfileSelect::initialize(){
  WSCbaseDialog::initialize();
  _form2 = new WSCform(this,"FS-area");
  _form2->initialize();
  _form2->setInternalObject(True);
  WSGFsetGeometry(_form2,0,5,_w,_h -45);
//  _form2->setPropertyV(WSNx,(short)1);
//  _form2->setPropertyV(WSNy,(short)5);
//  _form2->setPropertyV(WSNwidth, (WSCushort)(_w -2));
//  _form2->setPropertyV(WSNheight,(WSCushort)(_h -45));
//  _form2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
//  _form2->setPropertyV(WSNbackColor,"gray80");
//  _form2->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _form2->setProperty(WSNbackColor,_wbg_no);
//  _form2->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  _form2->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
  _form2->setVisible(True);

  _sp1 = new WSCvlabel(_form2,"FS-sp1");
  _sp1->initialize();
  _sp1->setInternalObject(True);
  WSGFsetGeometry(_sp1,0,30,_w-2,2);
//  _sp1->setPropertyV(WSNx,(short)0);
//  _sp1->setPropertyV(WSNy,(short)30);
//  _sp1->setPropertyV(WSNwidth, (WSCushort)(_w -2));
//  _sp1->setPropertyV(WSNheight,(WSCushort)2);
  _sp1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _sp1->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
//  _sp1->setPropertyV(WSNbackColor,"gray75");
//  _sp1->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  _sp1->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
  _sp1->setVisible(True);

  WSCbase* dtitle = new WSCvlabel(_form2,"fs-dtitle");
  dtitle->initialize();
  dtitle->setInternalObject(True);
  WSGFsetGeometry(dtitle,5,7,40,16);
//  dtitle->setPropertyV(WSNx,     (short)5 );
//  dtitle->setPropertyV(WSNy,     (short)7 );
//  dtitle->setPropertyV(WSNwidth, (WSCushort)40);
//  dtitle->setPropertyV(WSNheight,(WSCushort)16);
  dtitle->setPropertyV(WSNlabelString,"FILE:");
  dtitle->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  dtitle->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  WSGFsetMargin(dtitle,0);
  dtitle->setVisible(True);

  _file_if = new WSCvifield(_form2,"fs_dir_if");
  _file_if->initialize();
  _file_if->setInternalObject(True);
  WSGFsetGeometry(_file_if,45,5,_w -52,20);
//  _file_if->setPropertyV(WSNx,     (short)45 );
//  _file_if->setPropertyV(WSNy,     (short)5 );
//  _file_if->setPropertyV(WSNwidth, (WSCushort)(_w -52));
//  _file_if->setPropertyV(WSNheight,(WSCushort)20);
  _file_if->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _file_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
//  _file_if->setPropertyV(WSNcolumns,(WSCushort)26);
  _file_if->setPropertyV(WSNmaxLength,(WSCushort)512);
  _file_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _file_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _file_if->setPropertyV(WSNlabelString,"");
//  _file_if->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  _file_if->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
  _file_if->setUserData("FS EDIT",(void*)this); 
  _file_if->setVisible(True);

  WSCprocedure* aifop = new WSCprocedure("aifop",WSEV_ACTIVATE);
  aifop->setInternal(True);
  aifop->setFunction(_set_btn_work,"_set_btn_work");
  _file_if->addProcedure(aifop);

  _sp2 = new WSCvlabel(_form2,"FS-sp2");
  _sp2->initialize();
  _sp2->setInternalObject(True);
  WSGFsetGeometry(_sp2,0,_h -100,_w -2,2);
//  _sp2->setPropertyV(WSNx,(short)0);
//  _sp2->setPropertyV(WSNy,(short)(_h -100));
//  _sp2->setPropertyV(WSNwidth, (WSCushort)(_w -2));
//  _sp2->setPropertyV(WSNheight,(WSCushort)2);
  _sp2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _sp2->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
//  _sp2->setPropertyV(WSNbackColor,"gray75");
//  _sp2->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  _sp2->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
  _sp2->setVisible(True);

  _dtitle2 = new WSCvlabel(_form2,"fs-dtitle");
  _dtitle2->initialize();
  _dtitle2->setInternalObject(True);
  WSGFsetGeometry(_dtitle2,5,_h -93,40,16);
//  _dtitle2->setPropertyV(WSNx,     (short)5 );
//  _dtitle2->setPropertyV(WSNy,     (short)(_h - 93) );
//  _dtitle2->setPropertyV(WSNwidth, (WSCushort)40);
//  _dtitle2->setPropertyV(WSNheight,(WSCushort)16);
  _dtitle2->setPropertyV(WSNlabelString,"DIR:");
  _dtitle2->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _dtitle2->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  WSGFsetMargin(_dtitle2,0);
  _dtitle2->setVisible(True);

  _dir_if = new WSCvifield(_form2,"fs_dir_if");
  _dir_if->initialize();
  _dir_if->setInternalObject(True);
  WSGFsetGeometry(_dir_if,45,_h -95,_w -77,20);
//  _dir_if->setPropertyV(WSNx,     (short)45 );
//  _dir_if->setPropertyV(WSNy,     (short)(_h -95) );
//  _dir_if->setPropertyV(WSNwidth, (WSCushort)(_w -77));
//  _dir_if->setPropertyV(WSNheight,(WSCushort)20);
  _dir_if->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _dir_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
//  _dir_if->setPropertyV(WSNcolumns,(WSCushort)22);
  _dir_if->setPropertyV(WSNmaxLength,(WSCushort)512);
  _dir_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _dir_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _dir_if->setPropertyV(WSNlabelString,"");
//  _dir_if->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  _dir_if->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
  _dir_if->setUserData("FS EDIT",(void*)this); 
  _dir_if->setVisible(True);

  WSCprocedure* dirop = new WSCprocedure("dirop",WSEV_ACTIVATE);
  dirop->setInternal(True);
  dirop->setFunction(_dir_if_work,"_dir_if_work");
  _dir_if->addProcedure(dirop);

  _dtitle3 = new WSCvlabel(_form2,"fs-dtitle3");
  _dtitle3->initialize();
  _dtitle3->setInternalObject(True);
  WSGFsetGeometry(_dtitle3,5,_h -68,40,16);
//  _dtitle3->setPropertyV(WSNx,     (short)5 );
//  _dtitle3->setPropertyV(WSNy,     (short)(_h - 68) );
//  _dtitle3->setPropertyV(WSNwidth, (WSCushort)40);
//  _dtitle3->setPropertyV(WSNheight,(WSCushort)16);
  _dtitle3->setPropertyV(WSNlabelString,"TYPE:");
  _dtitle3->setPropertyV(WSNalignmentH,(WSCuchar)WS_LEFT);
  _dtitle3->setPropertyV(WSNshadowType,(char)WS_SHADOW_TRANS);
  WSGFsetMargin(_dtitle3,0);
  _dtitle3->setVisible(True);

  _mask_if = new WSCvifield(_form2,"fs_mask_if");
  _mask_if->initialize();
  _mask_if->setInternalObject(True);
  WSGFsetGeometry(_mask_if,45,_h -70,_w -77,20);
//  _mask_if->setPropertyV(WSNx,     (short)45 );
//  _mask_if->setPropertyV(WSNy,     (short)(_h -70) );
//  _mask_if->setPropertyV(WSNwidth, (WSCushort)(_w -77));
//  _mask_if->setPropertyV(WSNheight,(WSCushort)20);
  _mask_if->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _mask_if->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
//  _mask_if->setPropertyV(WSNcolumns,(WSCushort)22);
  _mask_if->setPropertyV(WSNmaxLength,(WSCushort)512);
  _mask_if->setPropertyV(WSNinterCur,(WSCbool)True);
  _mask_if->setPropertyV(WSNfillSpace,(WSCbool)False);
  _mask_if->setPropertyV(WSNlabelString,"*");
//  _mask_if->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  _mask_if->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
  _mask_if->setUserData("FS EDIT",(void*)this); 
  _mask_if->setVisible(True);

  WSCprocedure* maskop = new WSCprocedure("dirop",WSEV_ACTIVATE);
  maskop->setInternal(True);
  maskop->setFunction(_dir_if_work,"_dir_if_work");
  _mask_if->addProcedure(maskop);

  _up_btn = new WSCvbtn(_form2,"pe-end-btn");
  _up_btn->initialize();
  _up_btn->setInternalObject(True);
  WSGFsetGeometry(_up_btn,_w -27,_h -95,20,20);
//  _up_btn->setPropertyV(WSNx,         (short)(_w -27)  );
//  _up_btn->setPropertyV(WSNy,         (short)(_h - 95));
//  _up_btn->setPropertyV(WSNwidth,     (WSCushort)20        );
//  _up_btn->setPropertyV(WSNheight,    (WSCushort)20        );
  _up_btn->setPropertyV(WSNforeColor, WSGFcolor("black")        );
//  _up_btn->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  _up_btn->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
  _up_btn->setPropertyV(WSNlabelPixmap,WS_UP2_PIX);
  _up_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _up_btn->setUserData("FS EDIT",(void*)this); 
  WSGFsetMargin(_up_btn,0);
  _up_btn->setVisible(True);

  WSCprocedure* upop = new WSCprocedure("upop",WSEV_ACTIVATE);
  upop->setInternal(True);
  upop->setFunction(_up_btn_work,"_up_btn_work");
  _up_btn->addProcedure(upop);

  _mkdir_btn = new WSCvbtn(_form2,"pe-end-btn");
  _mkdir_btn->initialize();
  _mkdir_btn->setInternalObject(True);
  WSGFsetGeometry(_mkdir_btn,_w -27,_h -70,20,20);
  _mkdir_btn->setPropertyV(WSNforeColor, WSGFcolor("black")        );
//  _mkdir_btn->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95")   );
//  _mkdir_btn->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
  _mkdir_btn->setPropertyV(WSNlabelPixmap,WS_MKDIR_PIX);
  _mkdir_btn->setPropertyV(WSNshadowThickness,(WSCuchar)1);
  _mkdir_btn->setUserData("FS EDIT",(void*)this); 
  WSGFsetMargin(_mkdir_btn,0);
  _mkdir_btn->setVisible(True);

  WSCprocedure* mkdirop = new WSCprocedure("mkdirop",WSEV_ACTIVATE);
  mkdirop->setInternal(True);
  mkdirop->setFunction(_mkdir_btn_work,"_mkdir_btn_work");
  _mkdir_btn->addProcedure(mkdirop);

  _scr_form = new WSCscrForm(_form2,"fs-area2");
  _scr_form->initialize();
  _scr_form->setInternalObject(True);
  WSGFsetGeometry(_scr_form,5,36,_w -12,_h -140);
//  _scr_form->setPropertyV(WSNx,     (short)5 );
//  _scr_form->setPropertyV(WSNy,     (short)36 );
//  _scr_form->setPropertyV(WSNwidth, (WSCushort)(_w -12));
//  _scr_form->setPropertyV(WSNheight,(WSCushort)(_h - 140));
  _scr_form->setPropertyV(WSNworkHeight,(WSCushort)3500);
  _scr_form->setPropertyV(WSNhbarVisible,(WSCbool)False);
  _scr_form->setPropertyV(WSNshadowType,(char)WS_SHADOW_IN);
//  _scr_form->setProperty(WSNworkBackColor,WS_DF_WORKBACKCOLOR);
  _scr_form->setProperty(WSNbarShadowColor,WS_FS_SLBARBG1);
//  _scr_form->setPropertyV(WSNforeColor,WSGFcolor("black"));
//  _scr_form->setPropertyV(WSNbackColor,WS_FS_BGCOLOR2);
//  _scr_form->setProperty(WSNbackColor,WS_DF_DARKBACKCOLOR);
  _scr_form->setProperty(WSNbackColor,_wbg_no);
//  _scr_form->setPropertyV(WSNtopShadowColor,WSGFcolor("gray95"));
//  _scr_form->setPropertyV(WSNbottomShadowColor,WSGFcolor("gray45"));
//  _scr_form->setPropertyV(WSNscrollHeight,(WSCushort)2);
//  _scr_form->setProperty(WSNscrollHeight,WS_FS_T-1 );
  _scr_form->setProperty(WSNscrollHeight,WS_FS_H );
  _scr_form->setPropertyV(WSNincrement,(WSCushort)30);
  _scr_form->setPropertyV(WSNpageIncrement,(WSCushort)100);
  _scr_form->setProperty(WSNpixmapStyle,WS_DYNAMIC_PIXMAP);
  _scr_form->setVisible(True);
#if 0
  _scr_form2 = new WSCform(_scr_form,"fs-area2");
  _scr_form2->initialize();
  _scr_form2->setInternalObject(True);
  WSGFsetGeometry(_scr_form2,0,0,_w -12,3500);
//  _scr_form2->setPropertyV(WSNx,     (short)0 );
//  _scr_form2->setPropertyV(WSNy,     (short)0 );
//  _scr_form2->setPropertyV(WSNwidth, (WSCushort)(_w -12));
//  _scr_form2->setPropertyV(WSNheight,(WSCushort)3500);
  _scr_form2->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _scr_form2->setProperty(WSNbackColor,WS_DF_WORKBACKCOLOR);
//  _scr_form2->setProperty(WSNbackColor,WS_FS_BGCOLOR1);
  _scr_form2->setPropertyV(WSNpixmapStyle,(WSCuchar)WS_DYNAMIC_PIXMAP);
  _scr_form2->setVisible(True);
#endif
  char buf[2048];

  GETCWD(buf,2048);
#ifdef MSW
  WSCstring tmp(buf);
  tmp.replaceString("\\","/",0);
  strcpy(buf,tmp.getString());
#endif

//  _adjust();
//  setPropertyV(WSNwidth,(WSCushort)_w);
//  setPropertyV(WSNheight,(WSCushort)_h);
  setPropertyV(WSNlabelPixmap,WS_FILES_PIX);
  setPropertyV(WSNtitleString,"FileSelection");
  setPropertyV(WSNdirName,buf);
  setPropertyV(WSNmaskFileName,"");
  setPropertyV(WSNfileName,"");

  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  return WS_NO_ERR;
}

void WSCfileSelect::_adjust(){
  long diff = 0;
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
    diff = 0;
  }else
  if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
    diff = 5;
  }

  if (_w <50){
    _w = 50;
  }
  if (_h+diff <60){
    _h = 60;
  }
  _form2->setPropertyV(WSNwidth, (WSCushort)(_w));
  _form2->setPropertyV(WSNheight,(WSCushort)(_h+diff -45));
  _file_if->setPropertyV(WSNwidth, (WSCushort)(_w -52));
  _sp2->setPropertyV(WSNy,(short)(_h+diff -100));
  _sp2->setPropertyV(WSNwidth, (WSCushort)(_w -2));
  _sp1->setPropertyV(WSNwidth, (WSCushort)(_w -2));

  _dtitle2->setPropertyV(WSNy,     (short)(_h+diff - 93) );
  _dtitle3->setPropertyV(WSNy,     (short)(_h+diff - 68) );
  _dir_if->setPropertyV(WSNy,     (short)(_h+diff -95) );
  _dir_if->setPropertyV(WSNwidth, (WSCushort)(_w -77));

  _mask_if->setPropertyV(WSNy,     (short)(_h+diff -70) );
  _mask_if->setPropertyV(WSNwidth, (WSCushort)(_w -77));

  _up_btn->setPropertyV(WSNx,         (short)(_w -27) );
  _up_btn->setPropertyV(WSNy,         (short)(_h+diff - 95));

  _mkdir_btn->setPropertyV(WSNx,         (short)(_w -27) );
  _mkdir_btn->setPropertyV(WSNy,         (short)(_h+diff - 70));

  _scr_form->setPropertyV(WSNwidth, (WSCushort)(_w -12));
  if (_h > 140){
    _scr_form->setPropertyV(WSNheight,(WSCushort)(_h+diff - 140));
  }else{
    _scr_form->setPropertyV(WSNheight,(WSCushort)(1));
  }
  if (_h > 140 + WS_FS_T){
    _scr_form->setPropertyV(WSNpageIncrement,(WSCushort)(_h+diff -140 - WS_FS_T));
  }else{
    _scr_form->setPropertyV(WSNpageIncrement,(WSCushort)(1));
  }
//  _scr_form2->setPropertyV(WSNwidth, (WSCushort)(_w -12));
}
void WSCfileSelect::setWorkWSNwidth(WSCushort w){
  _adjust();
  WSCbaseDialog::setWorkWSNwidth(_w);
}
void WSCfileSelect::setWorkWSNheight(WSCushort h){
  _adjust();
  WSCbaseDialog::setWorkWSNheight(_h);
}
void WSCfileSelect::onResize(WSCrect* rect){
  WSCbaseDialog::onResize(rect);
  _adjust();
}
void WSCfileSelect::onParentVisibleChange(WSCbool fl){
  WSCbaseDialog::onParentVisibleChange(fl);
  if (fl != False){
    _update_list();
    _scr_form->setPropertyV(WSNhbarValue,(WSCushort)0);
    _scr_form->setPropertyV(WSNvbarValue,(WSCushort)0);
    _need_update_fl = True; //for win32
    needUpdate();
  }
}
void WSCfileSelect::onVisibleChange(WSCbool fl){
  WSCbaseDialog::onVisibleChange(fl);
  if (fl != False){
    _update_list();
    _scr_form->setPropertyV(WSNhbarValue,(WSCushort)0);
    _scr_form->setPropertyV(WSNvbarValue,(WSCushort)0);
    WSCbase* tlb = (WSCbase*)_label_list[0];
    if (tlb != NULL && tlb->getVisible() != False){
      _label_btn_work(tlb);
      tlb->setFocus();
    }
    _ok_btn->setSpecialFocus();
    _need_update_fl = True; //for win32
    needUpdate();
  }
}
char* WSCfileSelect::getFileName(){
static char buf[1024];
  char* dir;
  char* file;
  getPropertyV(WSNfileName,&file);
  WSCstring tfile(file);

  getPropertyV(WSNdirName,&dir);
  WSCstring tdir(dir);

  if (!strcmp("",tdir.getString())){
    sprintf(buf,"%s",tfile.getString());
  }else if (_select_dir != False){
    sprintf(buf,"%s",tdir.getString());
  }else{

#ifndef MSW
    if (!strcmp("/",tdir.getString())){
      sprintf(buf,"/%s",tfile.getString());
    }else{
      sprintf(buf,"%s/%s",tdir.getString(),tfile.getString());
    }
#else
    tdir.replaceString("\\","/",0);
    tfile.replaceString("\\","/",0);
    long len = strlen(tdir.getString());
    if (dir[len] == ':'){
      sprintf(buf,"%s%s",tdir.getString(),tfile.getString());
    }else{
      sprintf(buf,"%s/%s",tdir.getString(),tfile.getString());
    }
#endif
  }
  return buf;
}
void WSCfileSelect::onGuiPolicyChange(long policy){
  if (_form2 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _form2->setPropertyV(WSNshadowThickness,(WSCuchar)1);
      _form2->setProperty(WSNy,5);
      _scr_form->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else
    if (policy & WS_POLICY_WINDOWS){
      _form2->setProperty(WSNy,0);
      _form2->setPropertyV(WSNshadowThickness,(WSCuchar)0);
      _scr_form->setPropertyV(WSNshadowThickness,(WSCuchar)2);
    }
  }
}
