//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDmwindowDev.h>
#include <WSCdevice.h>
#include <WSDdraw.h>
#include <WSCbase.h>

WSMFclassInit(WSDmwindowDev,WSDdev);

WSDmwindowDev::WSDmwindowDev(){
  _w = 0;
  _h = 0;
}
void WSDmwindowDev::getGeometry(WSCushort* w,WSCushort* h){
  *w = _w;
  *h = _h;
}
WSCbool WSDmwindowDev::getReady(){
  long d1 = getDeviceResource();
  long d2 = getWindowResource();
  long d3 = getContextResource();
  if (d1 == -1 || d2 == -1 || d3 == -1){
     return False;
  }
  return True;
}

long WSDmwindowDev::beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute,WSCbool scaling){

  if (scaling != False){
    double scale = getScale();
    if ( scale != 1){
      x = (short)((x + getXOffset()) * scale);
      y = (short)((y + getYOffset()) * scale);
      w = (WSCushort)(w * scale);
      h = (WSCushort)(h * scale);
    }else{
      x = x + getXOffset();
      y = y + getYOffset();
    }
  }

  WSDdraw* draw = getDraw();
  if (draw == NULL){
    return WS_ERR;
  }

  if (getReady() == False){
    return WS_ERR;
  }
  draw->beginDraw(this,getDeviceResource(),getWindowResource(),getContextResource());

  draw->setRegion(x,y,w,h);
  draw->setLineWidth(1);
  draw->setLineDashType(0);
  draw->setHatchPattern(0);
  return WS_NO_ERR;
}

long WSDmwindowDev::endDraw(){
  WSDdraw* draw = getDraw();
  if (draw == NULL){
    return WS_ERR;
  }
  draw->endDraw();

  return WS_NO_ERR;
}
WSDmwindowDev* WSDmwindowDev::getNewInstance(){
  WSDdev* dev = WSGIappDevice()->getDevObject("mwindowDev");
  if (dev != NULL){
    WSDmwindowDev* mdev = (WSDmwindowDev*)dev->cast("WSDmwindowDev");
    return mdev;
  }
  return NULL;
}
WSCuchar* WSDmwindowDev::getBuffer(){
  WSCuchar* buf = new WSCuchar[(_w * _h)*3];
  if (buf == NULL){
    return NULL;
  }
  long i;
  long j;
  for(i=0; i<_h; i++){
    for(j=0; j<_w; j++){
      WSCuchar r,g,b;
      getBufferRGB(j,i,&r,&g,&b);
      buf[_w*3*i + j*3] = r;
      buf[_w*3*i + j*3+1] = g;
      buf[_w*3*i + j*3+2] = b;
    }
  }
  return buf;
}
long WSDmwindowDev::setBuffer(WSCuchar* buf){
  if (buf == NULL){
    return WS_ERR;
  }
  long i;
  long j;
  for(i=0; i<_h; i++){
    for(j=0; j<_w; j++){
      WSCuchar r,g,b;
      r = buf[_w*3*i + j*3];
      g = buf[_w*3*i + j*3+1];
      b = buf[_w*3*i + j*3+2];
      setBufferRGB(j,i,r,g,b);
    }
  }
  return WS_NO_ERR;
}
