//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCvrect.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSDdev.h>
#include <WSCblink.h>

WSMFguiClassInitialize(WSCvrect, WSCvpolyAttr);
WSMFversion(WSCvrect, WSCvpolyAttr);

WSCvrect::WSCvrect(WSCbase* base, char* objname):
				WSCvpolyAttr(base, objname){
  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvrect);
  WSMFpropertyCreateEnd
}


long WSCvrect::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

//  short          x, y;
//  WSCushort w, h;
//  getGeometry(&x, &y, &w, &h);
  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);

  if (_bl_fl == True &&
      blinkfore == True &&
      _tw_fl == False) {
    return WS_NO_ERR;
  }

  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
    return WS_NO_ERR;
  }

  //ե饰Ȥ
  WSCbase::update();
  setAbsoluteDraw(False);

  WSCushort line_w = _lw;
  if (line_w == 1) {
    dev->setLineWidth((WSCushort)0);
  } else {
    dev->setLineWidth((WSCushort)_lw);
  }

  // 
  dev->setLineDashType(_lt);

  short xx, yy;
  WSCushort ww, hh;
  xx = (short)line_w / 2;
  yy = (short)line_w / 2;
  ww = w - line_w;
  hh = h - line_w;
//WSMFtrace("*** WSCvrect::draw xx=%d yy=%d ww=%d hh=%d\n", xx, yy, ww, hh);

  if (_stippled == True) {
    if (_hatch_pattern != (char)0) {
      if (_back_color_flag == True) {
        if (_blink_type != WS_FORE &&
            _bl_fl == True &&
            blinkfore == True &&
            _tw_fl == True) {
          dev->setForeColor(_back_blink_color);
        } else {
          dev->setForeColor(_blink_color);
        }
        dev->setHatchPattern((char)0);
        dev->drawFillRect(xx, yy, ww, hh);
      }
    }
    dev->setHatchPattern(_hatch_pattern);
    if (_blink_type != WS_FORE &&
        _bl_fl == True &&
        blinkfore == True &&
        _tw_fl == True) {
      dev->setForeColor(_hatch_blink_color);
    } else {
      dev->setForeColor(_hatch_color);
    }
    dev->drawFillRect(xx, yy, ww, hh);
  }

  if (_bl_fl == True &&
      blinkfore == True &&
      _blink_type != WS_BACK &&
      _tw_fl == True) {
    dev->setForeColor(_blink_color);
  } else {
    dev->setForeColor(_fore_color);
  }

  // Ǥʤ
  if (line_w != 0) {
    dev->setHatchPattern(char(0));
    dev->drawRect(xx, yy, ww, hh);
  }

  //轪λ
  dev->endDraw();

  return WS_NO_ERR;
}

