/*-------------------------------------------------------------------------*/
/*  J3W ver 6.40  3D Animation Kit                                         */
/*  jrlcode.cpp    9/17/98                                                 */
/*  Copyright (C) 1995 - 1999 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include    <iomanip.h>
#include    <iostream.h>
#include    <fstream.h>
#include    "jrlcode.h"
#ifdef WS
#include <string.h>
#endif //WS

void cCode::clear_code()
{
    endpos = 0;
    for(int i=0;i<codeSize;i++) code[i]=0;
}

int cCode::LoadObjFile(char *FileName)
{
    if (strlen(FileName) == 0) {
        long n;
        while(cin >> hex >> n) set_code(n);
    } else {

        ifstream source(FileName,ios::in);

        if (!source) {
           cerr << "Cannot open source file " << FileName << " for input\n";
           return 1;
        }

        long n;
        while(source >> hex >> n) set_code(n);

        source.close();
    }
    if (endpos) return 0;
    else return 1;
}

int cCode::SaveObjFile(char *FileName)
{
    if (strlen(FileName) == 0) {
        for(int i=0; i<endpos; i++)
        cout << hex << code[i] << '\n';
    } else {
        ofstream dest;
        dest.open(FileName);

        if (!dest) {
           cerr << "Cannot open destination file " << FileName << " for output\n";
           return 1;
        }

        for(int i=0; i<endpos; i++)
          dest << hex << (unsigned long)code[i] << '\n';
        dest.close();
    }
    return 0;
}

