//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCRROOT_H
#define WSCRROOT_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSCstring.h>
#include <WSDserialize.h>
#include <WSCconductor.h>

class WSCRroot :public WSCroot{

 protected:
  WSCstring _addr;
  WSCushort _port;
  WSCstring _instance_name;
  WSDserialize* _db;
  long _rstatus;
 public:
  WSDLEX32 WSCRroot();
  WSDLEX32 virtual ~WSCRroot();

  WSDLEX32 void setInstanceName(char*);
  WSDLEX32 void setAddr(char*);
  WSDLEX32 void setPort(WSCushort);
  WSDLEX32 long beginRemoteCall(WSCremoteCall*);
  WSDLEX32 long endRemoteCall();

  WSDLEX32 long getRemoteCallStatus();

  WSMFclassDef(WSCRroot,WSCroot);
};
#endif
