//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.


#ifndef WSCBASE_H
#define WSCBASE_H

#include <WScom.h>
#include <WSCroot.h>
#include <WSCproperty.h>
#include <WSClistData.h>
#include <WSCindexData.h>
#include <WSCindexVariantData.h>
#include <WSCprocedure.h>
#include <WSCconductor.h>
#include <WSDserialize.h>
#include <WSCvariant.h>

class WSDdev;
class WSCbase;
class WSCdevice;
class WSCfontSet;
class WSCclassInformation;

#define WSCbase_VER   1000

class WSCbase :public WSCroot{

 private:
  static WSCclassInformation* WSCbase_info_ptr;
  WSCclassInformation* _own_class_info;
 protected:
  WSDLEX32 static WSClistData* _create_proc_list;
  WSDLEX32 static WSClistData* _cname_list;
  WSDLEX32 static WSCbase* _focus_instance;
  WSDLEX32 static WSCbase* _special_focus_instance;
  WSDLEX32 static WSCushort _grid_x;
  WSDLEX32 static WSCushort _grid_y;

//  WSCprocedure** _proc_list;
//  WSCprocedure** _pro_list_bk;
  WSClistData* _proc_list;
  WSCprocedure** _proc_list_bk;
  char*     _instance_name;
  WSDdev*   _dev;
  WSCbase*  _dev_public;
  WSCbase*  _parent;
  WSCbase*  _data_source_server;
  WSClistData*  _data_source_clients;
  char**    _user_data_st_list;
  char**    _user_data_list;
#ifndef NO_INDEX_VARIANT_DATA
  WSCindexVariantData* _variant_list;
#endif
  void**    _scale_ptrs;
  long      _event_mask;
//  long      _event_mask_ex;
  char      _num_of_st_user_data;
  char      _num_of_user_data;
  WSCushort _proc_list_len;
  unsigned  _name_hash_value:6;
  unsigned  _absolute_draw:1;
#ifndef WS_EMBED
  unsigned  _show_grip_hand:1;
#endif
  unsigned  _init_registered:1;
  unsigned  _update_registered:1;
  unsigned  _vis:1;
  unsigned  _vis_bk:1;
  unsigned  _parent_vis:1;
  unsigned  _parent_vis_init:1;
  unsigned  _sensitive:1;
  unsigned  _sensitive_work:1;
  unsigned  _parent_sensitive:1;
  unsigned  _parent_sensitive_init:1;
#ifndef WS_EMBED
  unsigned  _property_edit_mode:1;
#endif
  unsigned  _internal_object:1;
  unsigned  _geometry_changed:1;
  unsigned  _expose_op:1;
  unsigned  _initialized:1;
  unsigned  _use_parent_base_dev:1;
  unsigned  _dev_is_public_dev:1;
  unsigned  _proc_is_changed:1;
  unsigned  _no_clear:1;
#ifndef NO_REMOTE_INSTANCE
  unsigned  _export_:1;
  unsigned  _export_bk:1;
#endif
  unsigned  _keep_pixmap_cache:1;

#ifndef WS_EMBED
  WSDLEX32 static long _edit_mouse_move_handler(void*);
#endif

  WSDLEX32 void _set_prop_error(char*);
  WSDLEX32 void _set_prop_error2(char*,char*,WSCproperty*);
  WSDLEX32 void _get_prop_error(char*);
  WSDLEX32 void _get_prop_error2(char*,char*,WSCproperty*);

 public:
  unsigned  _flag_for_anchor:1;
  WSDLEX32 virtual void onMouseIn(WSCpoint*);
  WSDLEX32 virtual void onMouseOut();
  WSDLEX32 virtual void onMouseMove(WSCpoint*);
  WSDLEX32 virtual void onMousePress(WSCpoint*);
  WSDLEX32 virtual void onMouseDoubleClick(WSCpoint*);
  WSDLEX32 virtual void onMouseRelease(WSCpoint*);
  WSDLEX32 virtual void onExpose(WSCrect*);
  WSDLEX32 virtual void onResize(WSCrect*);
  WSDLEX32 virtual void onVisibleChange(WSCbool);
  WSDLEX32 virtual void onSensitiveChange(WSCbool);
  WSDLEX32 virtual void onParentVisibleChange(WSCbool);
  WSDLEX32 virtual void onParentSensitiveChange(WSCbool);
#ifndef WS_EMBED
  WSDLEX32 virtual void onEditModeChange(WSCbool);
#endif
  WSDLEX32 virtual void onFocusChange(WSCbool);
  WSDLEX32 virtual void onWindowFocusChange(WSCbool);
  WSDLEX32 virtual void onSpecialFocusChange(WSCbool);
  WSDLEX32 virtual void onChildAdded(WSCbase*);
  WSDLEX32 virtual void onSelectionChange(WSCbool);
  WSDLEX32 virtual void onGuiPolicyChange(long policy);
  WSDLEX32 virtual void onDefaultColorChange();

 protected:
  WSDLEX32 virtual long _device_initialize();

  WSDLEX32 WSCbool _get_parent_visible();
  WSDLEX32 WSCbool _get_parent_sensitive();
  WSDLEX32 WSCbool _get_prop(void* value,char type,WSCproperty*);
//  WSDLEX32 char*   _get_property_str_value(WSCproperty*);
  WSDLEX32 WSCvariant _get_property_str_value(WSCproperty*);
#ifndef WS_EMBED
  WSDLEX32 void _draw_grip_hand(short x,short y,WSCushort w,WSCushort h);
#endif
//  WSDLEX32 void _exec_procedure(WSCprocedure**,char*);
//  WSDLEX32 void _exec_procedure(WSCprocedure**,long,WSCbool del_ev);
  WSDLEX32 void _exec_procedure(char*,WSCbool internal);
  WSDLEX32 void _exec_procedure(long,WSCbool del_ev,WSCbool internal);
  WSDLEX32 void _exec_procedure(WSCprocedure*);
  WSDLEX32 void _exec_del_procedure();
  WSDLEX32 void _add_prcs(WSCprocedure*);
  WSDLEX32 void _register_focus_move();

  WSDLEX32 WSCbase* _get_focus_move_instance(long direction,WSCbool retry = False,WSCbase* orig = NULL);
  WSDLEX32 void   _error_output(char*,char*,char*,WSCbool);
  WSDLEX32 long   _property_init();
  WSDLEX32 static WSCbase* (*_create_instance_handler)(char*,WSCbase*,char*);

#ifndef WS_EMBED
  WSDLEX32 void _start_new_instance_positioning();
  WSDLEX32 void _stop_new_instance_positioning();
  static WSDLEX32 void _new_instance_pos_work_proc(void*);
#endif
 public:
  WSDLEX32 static void setCreateInstanceHandler(WSCbase*(*)(char*,WSCbase*,char*));
  WSDLEX32 static void setGripHandGrid(WSCushort,WSCushort);
  WSDLEX32 static void getGripHandGrid(WSCushort*,WSCushort*);
  WSDLEX32 virtual void _adjust_for_anchors(WSCushort w,WSCushort h);

  WSDLEX32 WSCbase(WSCbase *,char *);
  WSDLEX32 virtual  ~WSCbase();

  WSDLEX32 virtual long initialize();
  WSDLEX32 WSCbool getInitialized();
  WSDLEX32 void    setInstanceName(char *); 
  WSDLEX32 void    setInstanceNameNC(char *); 

  WSDLEX32 char* getInstanceName();
  WSDLEX32 long  getInstanceNameHashValue();

  WSDLEX32 virtual long getObjectType();
  WSDLEX32 WSClistData* getProcedureList();
  WSDLEX32 WSClistData getProcedures();

  WSDLEX32 void     setParent(WSCbase*);
  WSDLEX32 WSCbase* getParent();
  WSDLEX32 WSCbase* getParentWindow();

  WSDLEX32 long setChild(WSCbase*);
  WSDLEX32 long delChild(WSCbase*);

  WSDLEX32 void    setInternalObject(WSCbool );
  WSDLEX32 WSCbool getInternalObject();

  WSDLEX32 virtual void setScaleOffsetPtr(double*);
  WSDLEX32 virtual void setXOffsetPtr(short*);
  WSDLEX32 virtual void setYOffsetPtr(short*);
  WSDLEX32 double* getScaleOffsetPtr();
  WSDLEX32 short*  getXOffsetPtr();
  WSDLEX32 short*  getYOffsetPtr();

  WSDLEX32 WSCproperty* getPropObj(char* prop_name);
  WSDLEX32 long     getPropObjArray(WSClistData*);
  WSDLEX32 long     isDefaultValue(char*,WSCbool*);
  WSDLEX32 WSCbool  setDefaultValue(char*);
  WSDLEX32 WSCbool  existProperty(char*);

//  WSDLEX32 WSCbool  _set_property(char *name,char *data);
//  WSDLEX32 WSCbool  _set_property(char *name,WSCvariant& value);
  WSDLEX32 WSCbool  setProperty(char *name,const WSCvariant&);
  WSDLEX32 WSCvariant getProperty(char *name);
  WSDLEX32 long     getPropertyArray(WSClistData*,WSCbool include_default);

  WSDLEX32 virtual char* getDefaultProperty();

  WSDLEX32 WSCbool  setPropertyV(char *name,long  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,long* v);
  WSDLEX32 WSCbool  setPropertyV(char *name,int  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,int* v);
  WSDLEX32 WSCbool  setPropertyV(char *name,WSCuint   v);
  WSDLEX32 WSCbool  getPropertyV(char *name,WSCuint*  v);
  WSDLEX32 WSCbool  setPropertyV(char *name,WSCuchar   v);
  WSDLEX32 WSCbool  getPropertyV(char *name,WSCuchar*  v);
  WSDLEX32 WSCbool  setPropertyV(char *name,WSCushort  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,WSCushort* v);
  WSDLEX32 WSCbool  setPropertyV(char *name,WSCulong   v);
  WSDLEX32 WSCbool  getPropertyV(char *name,WSCulong*  v);
  WSDLEX32 WSCbool  setPropertyV(char *name,short  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,short* v);
  WSDLEX32 WSCbool  setPropertyV(char *name,char*  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,char** v);
  WSDLEX32 WSCbool  setPropertyV(char *name,char  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,char* v);
  WSDLEX32 WSCbool  setPropertyV(char *name,float  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,float* v);
  WSDLEX32 WSCbool  setPropertyV(char *name,double  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,double* v);
  WSDLEX32 WSCbool  setPropertyV(char *name,void*  v);
  WSDLEX32 WSCbool  getPropertyV(char *name,void** v);
  WSDLEX32 WSCbool  setPropertyV(char *name,WSCvariant v);

//  WSDLEX32 void         setPropertyVDefault(char* name,long fl);
  WSDLEX32 virtual      WSCclassInformation* getClassInformation();
  WSDLEX32 WSClistData* getPropertyList();

#ifndef WS_EMBED
  WSDLEX32 virtual long setPropertyEditMode(WSCbool );
#endif
  WSDLEX32 long setFocus(WSCbool fl = True);
  WSDLEX32 long setSpecialFocus(WSCbool fl = True);

#ifndef WS_EMBED
  WSDLEX32 long setPropertyEditExecute(WSCbool );
#endif
  WSDLEX32 virtual void setVisible(WSCbool); 
  WSDLEX32 void setNoClearFlag(WSCbool);

  WSDLEX32 void setParentVisible(WSCbool);
  WSDLEX32 void setSensitive(WSCbool);
  WSDLEX32 void setParentSensitive(WSCbool);

#ifndef WS_EMBED
  WSDLEX32 WSCbool getPropertyEditMode();
#endif
  WSDLEX32 WSCbool getVisible();
  WSDLEX32 WSCbool getParentVisible();
  WSDLEX32 WSCbool getSensitive();
  WSDLEX32 WSCbool _get_sensitive_work();
  WSDLEX32 WSCbool getParentSensitive();
  WSDLEX32 WSCbool getFocus();
  WSDLEX32 WSCbool getSpecialFocus();
  WSDLEX32 WSCbool getDotMode();
  WSDLEX32 virtual WSCbool canFocus();

  WSDLEX32 long    setAbsoluteDraw(WSCbool fl);
  WSDLEX32 WSCbool getAbsoluteDraw();

  WSDLEX32 void    setUserData(const char*,void *);
  WSDLEX32 void    setUserData(char*,void *);
  WSDLEX32 void*   getUserData(char*);
  WSDLEX32 void    setUserLongData(char*,WSCulong);
  WSDLEX32 WSCulong  getUserLongData(char*);
  WSDLEX32 void    setUserStringData(char*,char*);
  WSDLEX32 char*   getUserStringData(char*);
#ifndef NO_INDEX_VARIANT_DATA
  WSDLEX32 void    setVariantData(char*,WSCvariant);
  WSDLEX32 WSCvariant&   getVariantData(char*);
#endif

  WSDLEX32 WSCbase* getChildInstance(char*);
  WSDLEX32 WSCbase* getFocusMoveInstance(long);
  WSDLEX32 virtual WSCbase* getFocusMoveInternalInstance(long);

  WSDLEX32 WSClistData* getDataSourceClients();      
  WSDLEX32 void         addDataSourceClient(WSCbase*);      
  WSDLEX32 void         delDataSourceClient(WSCbase*);      
  WSDLEX32 WSCbase*     getDataSourceServer();      
  WSDLEX32 void         setDataSourceServer(WSCbase*);      
  WSDLEX32 void         setDataToDataSourceClients(WSCvariant*);      
  WSDLEX32 virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT); 
  WSDLEX32 virtual long getDataSourceType(); 
  WSDLEX32 virtual char* getDataSourcePropertyName(); 

  WSDLEX32 virtual WSClistData&    getChildren();      
  WSDLEX32 virtual WSClistData*    getChildrenPtr();      
#ifndef NO_RESTACK_CHILD
  WSDLEX32 virtual long    restackChild(WSCbase*,int order);
#endif
  WSDLEX32 virtual void    setChildren(WSClistData&);      
  WSDLEX32 long            getAllChildren(WSClistData&);      
  WSDLEX32 virtual  void   update();
  WSDLEX32 void            needUpdate();
  WSDLEX32 virtual  void   internalUpdate();

  WSDLEX32 WSCbool isNeedUpdate();
  WSDLEX32 WSCbool isParent(WSCbase*);
  WSDLEX32 WSCbool existTrigger(long);
  WSDLEX32 WSCbool getMouseAddr(short*,short*);
  WSDLEX32 WSCindexData* getExtTriggerList();

  WSDLEX32 virtual long addProcedure(WSCprocedure*);
#ifndef WS_EMBED
  WSDLEX32 long addProcedure(char* pname,char* fname,long);
  WSDLEX32 long delProcedure(long);
#endif
  WSDLEX32 long addProcedureV(char* pname,char* fname,void(*hd)(WSCbase*),long);

  WSDLEX32 long delProcedure(WSCprocedure*);
  WSDLEX32 WSCbase* getNextChild(WSCbase*);
  
  WSDLEX32 long delAllProcedure();
  WSDLEX32 void execProcedure(char*);
  WSDLEX32 void execProcedure(long);

  WSDLEX32 virtual long draw();
  WSDLEX32 virtual long clear();
  WSDLEX32 virtual long redraw();
  WSDLEX32 virtual long cdraw();

  WSDLEX32 WSDdev* getdev();
  WSDLEX32 WSDdev* getowndev();
  WSDLEX32 WSDdev* getParentDev();
  WSDLEX32 WSDdev* attachdev();
  WSDLEX32 WSCbase* getPublicDevChild();

  WSDLEX32 void setUseParentBaseDev(WSCbool);
  WSDLEX32 WSCbool getUseParentBaseDev();
  WSDLEX32 long setdev(WSDdev*);
  WSDLEX32 long setpablicdev(WSDdev*);
  WSDLEX32 long setMoveMode(WSCbool);
  WSDLEX32 long setOrder(char);

#ifndef WS_EMBED
  WSDLEX32 long    setShowGriphand(WSCbool);
  WSDLEX32 long drawGriphand();
  WSDLEX32 long clearGriphand();
#endif

  WSDLEX32 static void     setCreateHandler(char*,WSCbase* (*hd)(WSCbase*,char*));
  WSDLEX32 static WSCbase* getNewInstance(char* class_name,WSCbase* parent,char* name);
  WSDLEX32 static WSCbase* getFocusInstance();
  WSDLEX32 static WSCbase* getSpecialFocusInstance();
  WSDLEX32 static WSClistData* getSupportedClassList();

  WSDLEX32 virtual void onDataSave(WSDserialize*);
  WSDLEX32 virtual void onDataLoad(WSDserialize*);

  WSDLEX32 virtual char* getUseDevName();
  WSDLEX32 virtual long execEventProc(long ev,void*);
  WSDLEX32 virtual WSCbase* getPropertyInheritChild();

  WSDLEX32 static  void setCreateCallback(void(*)(void*),void*);

  WSDLEX32 long getVer(long v = WSCbase_VER);
  WSDLEX32 long checkVersion(long v);

  WSDLEX32 void setGeometryChanged(WSCbool);
#ifndef NO_REMOTE_INSTANCE
  WSDLEX32 void setExportName(char*);
  WSDLEX32 char* getExportName();
  WSDLEX32 void setExported(WSCbool);
  WSDLEX32 WSCbool getExported();
#endif
  WSDLEX32 virtual WSCbool adjustAnchor();
  WSDLEX32 WSCbool canBurstCast(void*);
  WSMFclassDef(WSCbase,WSCroot);
};
#define WSMFsetUseDevice(DN) \
  WSDLEX32 virtual char* getUseDevName()

#define WSMFguiClassDef(CN,VC) \
 public: \
  WSDLEX32 static WSCbase* createInstance(WSCbase*,char*); \
  WSDLEX32 virtual char* getClassName(); \
  WSDLEX32 virtual void* cast(char *cname = NULL); \
  WSDLEX32 virtual void* cast2(char *cname = NULL); \
  WSDLEX32 static WSCclassInformation* CN ## _info_ptr; \
  WSDLEX32 virtual WSCclassInformation* getClassInformation()

#define WSMFversionDef(CN) \
  WSDLEX32 long getVer(long val = CN ## _VER); \
  WSDLEX32 long checkVersion(long)

#define WSMFpropertyDef(PN,PT,WorkVal) \
  WSDLEX32 static void _set_p_w  ## WorkVal(void* ptr,void* data); \
  WSDLEX32 static void _get_def_w ## WorkVal(void* ptr); \
  WSDLEX32 static void _get_p_w  ## WorkVal(void* ptr,void* data); \
  WSDLEX32 virtual void setWork ## PN (PT); \
  WSDLEX32 virtual void getWork ## PN (PT*)


#endif
