//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCCLASSINFOMATION_H
#define WSCCLASSINFOMATION_H

#include <WScom.h>
#include <WSCproperty.h>
#include <WSClistData.h>
#include <WSCindexData.h>
#include <WSSdef.h>
#include <WSRdef.h>

class WSCclassInformation{

 private:
   WSCclassInformation* _pclass_info;
   WSClistData  _prop_list;
   WSCulong     _trigger_mask;
   WSCulong     _del_trigger_mask;
   WSClistData* _inf_table; 
//   WSClistData* _all_prop_list;
//   WSClistData* _prop_list_for_init;
   WSClistData _all_prop_list;
   WSClistData _prop_list_for_init;
   WSCindexData _all_ext_trigger_list;
   WSCindexData _ext_trigger_list;
   WSClistData  _del_ext_trigger_list;

   void* _bases;
   WSCproperty* _cache;
   WSDLEX32 void _create_inf_table();

 public:
   const char* cname;
   long  cname_hash_value;
   WSDLEX32 WSCclassInformation(const char* cname,WSCclassInformation* parent);
   WSDLEX32 virtual ~WSCclassInformation();

   WSDLEX32 WSCbool      getPropObj(char* prop_name,WSCproperty** prop);
#ifndef WS_EMBED
   WSDLEX32 WSCbool      getPropObj(char* prop_name,char** class_name);
#endif
   WSDLEX32 void         addPropObj(WSCproperty* prop);
   WSDLEX32 void         setTrigger(long trg); 
   WSDLEX32 void         setDelTrigger(long trg); 
   WSDLEX32 WSCbool      existTrigger(long trg);
   WSDLEX32 WSCbool      _existExtTrigger(long trg);
   WSDLEX32 WSCbool      _existTrigger(long trg);
   WSDLEX32 WSClistData* getHashTable();
   WSDLEX32 WSClistData* getAllPropertyList();
   WSDLEX32 WSClistData* getPropertyList();
   WSDLEX32 WSClistData* getPropertyListForInit();
   WSDLEX32 void*        getClassInstanceList();
   WSDLEX32 void         setClassInstanceList(void*);

   WSDLEX32 void         setExtTrigger(long trg,const char* tname);
   WSDLEX32 void         setDelExtTrigger(long trg);
   WSDLEX32 WSCindexData* getExtTriggerList();
   WSDLEX32 WSCindexData* getAllExtTriggerList();
   WSDLEX32 WSCclassInformation* getParentClassInformation();
};
//struct WSChashData{
//   WSChashData();
//   WSCclassInformation* _class_info;
//   WSCproperty* _property;
//};
extern WSDLEX WSCclassInformation* WSGIappClassInformation();

#define WSMFdefineUseDevice(CN,DN) \
  char* CN::getUseDevName(){return #DN;}

#define WSMFpropertyCreateStart \
  static WSCbool _prop_init = False; \
  if (_prop_init == False){ \
    _prop_init = True; \
    WSCproperty* prop; \
    WSCbool cb_cast = canBurstCast(this); \
    WSCclassInformation* cinf = getClassInformation(); \
    char* cname = getClassName(); \
    prop = NULL;

#ifndef WS_EMBED
#define WSMFpropertyCreate(PropName,PropType,WorkVar,BuilderTitle) \
  prop = new WSCproperty(PropName,cname); \
  cinf->addPropObj(prop); \
  prop->setType( #PropType,_set_p_w ## WorkVar, _get_p_w  ## WorkVar, \
     _get_def_w ## WorkVar); \
  prop->_can_burst_cast = cb_cast; \
  prop->_builder_title = BuilderTitle;
#else
#define WSMFpropertyCreate(PropName,PropType,WorkVar,BuilderTitle) \
  prop = new WSCproperty(PropName,cname); \
  cinf->addPropObj(prop); \
  prop->setType( #PropType,_set_p_w ## WorkVar, _get_p_w  ## WorkVar, \
     _get_def_w ## WorkVar); \
  prop->_can_burst_cast = cb_cast;
#endif

#ifndef WS_EMBED
#define WSMFpropertySetSelection(ValueNameList,ValueList) \
  if (ValueNameList != NULL || ValueList != NULL){ \
    prop->_data_labels = ValueNameList; \
    prop->_data = ValueList; \
  }
#else
#define WSMFpropertySetSelection(ValueNameList,ValueList)
#endif

#ifndef WS_EMBED
#define WSMFpropertyVisibleOff(PropName) \
  prop = new WSCproperty(PropName,cname); \
  prop->_ignore = True; \
  prop->_builder_visible = False; \
  prop->_can_burst_cast = canBurstCast(this); \
  getClassInformation()->addPropObj(prop);
#else
#define WSMFpropertyVisibleOff(PropName) 
#endif

#define WSMFpropertyInitExec(init) \
  prop->_init_execute = init;

#ifndef WS_EMBED
#define WSMFpropertyVisible(Vis) \
  prop->_builder_visible = Vis;
#else
#define WSMFpropertyVisible(Vis)
#endif

#define WSMFpropertyFileSelect(fl) \
  prop->_file_select = fl;

#define WSMFpropertyValueChangeDef(CN,PropName,PropType) \
  prop = new WSCproperty(PropName,cname); \
  cinf->addPropObj(prop); \
  prop->_default_value_change = True; \
  prop->setType( #PropType,NULL, NULL, CN ## PropName ## _get_def_w); \
  prop->_init_execute = True; \
  prop->_can_burst_cast = cb_cast;

#define WSMFpropertyDelete(PropName) \
  prop = new WSCproperty(PropName,cname); \
  prop->_not_use = True; \
  prop->_can_burst_cast = cb_cast; \
  cinf->addPropObj(prop); 

#define WSMFpropertyCreateEnd };
#define WSMFaddTrigger(TRG) getClassInformation()->setTrigger(TRG);
#define WSMFdelTrigger(TRG) getClassInformation()->setDelTrigger(TRG);
#define WSMFaddExtTrigger(TRG,TNAME) getClassInformation()->setExtTrigger(TRG,TNAME);
#define WSMFdelExtTrigger(TRG) getClassInformation()->setDelExtTrigger(TRG);
#define WSMFpropertyValueChange( CN,PN, CT, DEF ) \
  static void CN ## PN ## _get_def_w (void* var){ \
    *(CT*)var = DEF; \
  }

#define WSMFproperty(CN,PN,CT,WorkVal,DEF) \
  void CN::_get_def_w ## WorkVal(void* var){ \
    *(CT*)var = DEF; \
  } \
  void CN::_set_p_w ## WorkVal(void* ptr,void* data){ \
    CN* obj = (CN*)ptr; \
    if ( obj->WorkVal != *(CT*)data){ \
      obj->WorkVal = *(CT*)data; \
      if (obj->_update_registered == False && obj->_vis != False ){ \
        obj->needUpdate(); \
      } \
      obj->_absolute_draw = True; \
      obj->setWork ## PN(obj->WorkVal); \
    } \
  } \
  void CN::_get_p_w ## WorkVal(void* ptr,void* data){ \
    CN* obj = (CN*)ptr; \
    CT* val = (CT*)data; \
    *val = obj->WorkVal; \
    obj->getWork ## PN(val); \
  }

#define WSMFguiClassInitialize(CN,VC) \
  static void  CN ## _save(WSDserialize*,void* ){} \
  static void  CN ## _load(WSDserialize*,void* ){} \
  static void* CN ## _create(void* ptr){ \
    WSCbase* parent = (WSCbase*)ptr; \
    CN* ret = new CN(parent,""); \
    ret->initialize(); \
    if (parent == NULL && !(ret->getObjectType() & WS_TYPE_WINDOW )){ \
      delete ret; \
      return NULL; \
    } \
    return ret; \
  } \
  static void CN ## _delete(void* ptr){ \
    WSCbase* base = (WSCbase*)ptr; \
    delete base; \
  } \
  WSMFdefineDrInheritClient(CN,VC,CN ## _save,CN ## _load, CN ## _create,CN ## _delete);\
  class CN ## _init{ \
   public: \
    CN ## _init(){ \
      WSCbase::setCreateHandler(#CN, CN::createInstance); \
    } \
    ~CN ## _init(){ \
      WSCbase::setCreateHandler(#CN, NULL); \
    } \
  }; \
  static CN ## _init _init_run_constructor; \
  WSCbase* CN ::createInstance(WSCbase* p,char* n){ \
    WSCbase* ret = new CN (p,n); \
    return ret; \
  } \
  char* CN::getClassName(){return(#CN);} \
  void* CN::cast(char *class_name){ \
    if(class_name == NULL){ \
      return(this); \
    }else if(!WSIFstrcmp(class_name,#CN)){ \
      return(this); \
    }else{ \
      return(VC::cast(class_name)); \
    } \
  } \
  void* CN::cast2(char *class_name){ \
    if(!WSIFstrcmp(class_name,#CN)){ \
      return(this); \
    }else{ \
      return(VC::cast2(class_name)); \
    } \
  } \
  WSCclassInformation* CN::CN ## _info_ptr = NULL; \
  WSCclassInformation* CN::getClassInformation(){ \
    if (CN ## _info_ptr == NULL){ \
      CN ## _info_ptr = new WSCclassInformation(#CN,VC::getClassInformation()); \
    } \
    return CN ## _info_ptr; \
 }

#define WSMFversion(CN,PCN) \
  long CN::getVer(long val){return val;}; \
  long CN::checkVersion(long val){ \
    if (val/10 == CN ## _VER/10){ \
      long ret = PCN::checkVersion(PCN ## _VER); \
      if (ret == 0){ \
        WSMFtrace("Target  FILE:%s    Please recompile.\n",__FILE__); \
      } \
      return ret; \
    } \
    WSMFtrace("VERSION error. class=%s object_version=%d  <- differ -> object_version=%d\n",#CN,CN ## _VER,val); \
    fprintf(stderr,"VERSION error. class=%s object_version=%d  <- differ -> object_version=%d\n",#CN,CN ## _VER,val); \
    return 0; \
  };

#define WSMFparentCheckVerSrc(CN) \
  if (CN::checkVersion(CN ## _VER) == 0){ \
    WSMFtrace("Target CLASS:%s    Please recompile.\n",#CN); \
    fprintf(stderr,"Target CLASS:%s    Please recompile.\n",#CN); \
  }

#endif
