//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCDBSQLITE_H
#define WSCDBSQLITE_H

#ifdef MSW
#include <windows.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "sqlite3.h"

#include <WScom.h>
#include <WSCvariant.h>

struct _SqLiteCol {
	WSCuchar	colName[32];
	short		colType;
	int			buffLen;
	void*		buff;
};

#define SQLITE_ACCESS_MODE_READ			0444
#define SQLITE_ACCESS_MODE_EDIT			0666
#define SQLITE_ACCESS_MODE_ADDNEW		2
#define SQLITE_MAX_MESSAGE_LENGTH		255
#define SQLITE_TRAN_FUNCTION			1
#define SQLITE_TRAN_RECORD_FUNCTION		2


class WSCdbDrvDatabase;
class WSCdbDrvRecord;
class WSCdbSQLiteRecord;

class WSCdbSQLiteDatabase : public  WSCdbDrvDatabase
{
public:
	WSDLEX32 WSCdbSQLiteDatabase();
	WSDLEX32 virtual ~WSCdbSQLiteDatabase();
	
	WSDLEX32 virtual long     open(char* host, char* uid, char* pwd, char* dbname, char* port = NULL);
	WSDLEX32 virtual long     close();
	WSDLEX32 virtual long     beginTran();
	WSDLEX32 virtual long     commitTran();
	WSDLEX32 virtual long     abortTran();
	WSDLEX32 virtual long     sqlExecute(const char* stmt);
	WSDLEX32 virtual WSCbool  isOpen();
	WSDLEX32 virtual void     getErrorMsg(char* szState, char* szMsg);
	WSDLEX32 virtual void     getErrorMsg(char* szMsg,long size);
	WSDLEX32 virtual void     setEncode(long code);
	WSDLEX32 virtual long     getEncode();

	WSDLEX32         int      getProcessId();
	WSDLEX32         WSCulong getCursor();
	WSDLEX32         short    getbeginTranmode();
	WSDLEX32         void     setbeginTranmode(short begin);
	WSDLEX32         char*    getDbName();
private:
	void getError();
	void getServerEncoding();
	char* decode(const char* buf);

public:
	WSCbool		_open;
	short		_begin;
	sqlite3*		_hconn;
	WSCuchar	_szSqlState[6];
	WSCuchar	_szErrorMsg[SQLITE_MAX_MESSAGE_LENGTH + 1];
	char		_dbName[80];
	long		_encoding;
	int			_errno;
	char*		_errmsg;
};

class WSCdbSQLiteRecord  : public  WSCdbDrvRecord
{
public:
	WSDLEX32 WSCdbSQLiteRecord(WSCdbSQLiteDatabase* pDatabase);
	WSDLEX32 virtual ~WSCdbSQLiteRecord();
	WSDLEX32 virtual long    open(const char* stmt);
	WSDLEX32 virtual long    open(const char* stmt, short eCousor, short eAccess = WSCDB_SQL_CONCUR_LOCK);
	WSDLEX32 virtual long    close();
	WSDLEX32 virtual WSCbool isEOF();
	WSDLEX32 virtual WSCbool isOpen();
	WSDLEX32 virtual long    getColValue(long index, WSCvariant* var);
	WSDLEX32 virtual long    getColValue(const char* name, WSCvariant* var);
	WSDLEX32 virtual long    getColStringValue(long index, char* var);
	WSDLEX32 virtual long    getColStringValue(const char* name, char* var);
	WSDLEX32 virtual long    setColValue(long index, WSCvariant var);
	WSDLEX32 virtual long    setColValue(const char* name, WSCvariant var);
	WSDLEX32 virtual long    edit();
	WSDLEX32 virtual long    update();
	WSDLEX32 virtual long    addnew();
	WSDLEX32 virtual long    deleterow();
	WSDLEX32 virtual long    moveNext();
	WSDLEX32 virtual long    movePrevious();
	WSDLEX32 virtual long    moveFirst();
	WSDLEX32 virtual long    moveLast();
	WSDLEX32 virtual long    getColName(long index, char* name);
	WSDLEX32 virtual long    getColIndex(const char* name);
	WSDLEX32 virtual long    getColType(long index);
	WSDLEX32 virtual long    getColType(const char* name);
	WSDLEX32 virtual long    getColLength(long index);
	WSDLEX32 virtual long    getColLength(const char* name);
	WSDLEX32 virtual long    getRowCount();
	WSDLEX32 virtual long    getColCount();
	WSDLEX32 virtual void    getErrorMsg(char* szState, char* szMsg);
	WSDLEX32 virtual WSCstring getErrorMessage();
	WSDLEX32 virtual long    isNull(long index);
	WSDLEX32 virtual long    isNull(const char* name);

private:
	void  Cleanup(WSCdbSQLiteDatabase* pDatabase);
	long  BindCols();
	void  ReleaseCols();
	void  getValue(int index, WSCvariant* var);
	void  setValue(int index, WSCvariant* var);
	void  getError();
	char* makeINSERT();
	char* makeUPDATE();
	char* makeDELETE();
	void  getTableName(char* p, char* tbl, int size);
	long  setRowPos(WSCulong pos);
	int   getBufflen(int type);
	char* getSqlString(int i);
	void  encode(char* buf, char* str);
	char* decode(char* buf);
	char* getSelectSQL(const char* p, long rowiduse);
	void  getColTypeLength(const char*colname, short* type, int* length);

public:
	WSCdbSQLiteDatabase*	_pDB;
	sqlite3_stmt*				_res_stmt;
	WSCbool					_open;
	int						_Cols;
	_SqLiteCol*				_fd;
	short					_access_mode;
	WSCuchar				_szSqlState[6];
	WSCuchar				_szErrorMsg[SQLITE_MAX_MESSAGE_LENGTH + 1];
	int						_access;
	int						_Cursor;
	WSCbool					_eof;
	WSCulong				_RowCount;
	WSCulong				_FetchRowPos;
	long					_encoding;
	char					_tableName[80];
	long					_rowiduse;
	int						_errno;
	char*					_errmsg;
	const char**				_val;
	const char*					_stmt;	
};

#endif		// WSCDBSQLITE_H

