//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCFONTSET_H
#define WSCFONTSET_H

#include <WScom.h>
#include <WSDfont.h>
#include <WSClistData.h>

class WSCstring;
#define WS_DEFAULT_FONT_NO 0

class WSCfontSet{

 protected:
    WSClistData _font_list;
    WSDfont*  (*_create_handler)();
    long   (*_setup_handler)(WSDfont*,char*);
    long   (*_default_init_handler)(WSCfontSet*);
    short   _default_font;
   
 public:
   WSDLEX32 WSCfontSet();
   WSDLEX32 virtual ~WSCfontSet();

   WSDLEX32 long     addFont(WSDfont* );
   WSDLEX32 WSDfont* getFont(short no);
   WSDLEX32 long     getStringWidth(short no,WSCstring*);
   WSDLEX32 long     getStringHeight(short no,WSCstring*);
   WSDLEX32 long     getStringWidth(short no,char*,long en = WS_EN_DEFAULT);
   WSDLEX32 long     getStringHeight(short no,char*,long en = WS_EN_DEFAULT);
   WSDLEX32 long     initializeDefault();
   WSDLEX32 void     setDefaultFont(short no);
   WSDLEX32 void     setCreateHandler(WSDfont* (*)());
   WSDLEX32 void     setSetupHandler(long (*)(WSDfont*,char*));
   WSDLEX32 void     setDefaultInitializeHandler(long (*)(WSCfontSet* ));
   WSDLEX32 WSDfont* getDefaultFont();
   WSDLEX32 short    getDefaultFontNo();
   WSDLEX32 WSCbool  getReady(short no,WSCbool loading = False);
};
extern WSDLEX WSCfontSet*  WSGIappFontSet();
#endif
