//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCFORM_H
#define WSCFORM_H

#include <WScom.h>
#include <WSCbase.h>

#define WSCform_VER  1010

class WSCform :public WSCbase{

  protected:
    char*          _user_string;
    long           _user_value;
    WSClistData    _children;
    short          _x;
    short          _y;
    WSCushort      _w;
    WSCushort      _h;
    short          _fore_color;
    short          _back_color;
    short          _ts_color;
    short          _bs_color;
    short          _bp_color;
    WSCushort      _mouse_no;
    unsigned short _anchor_top;
    unsigned short _anchor_bottom;
    unsigned short _anchor_left;
    unsigned short _anchor_right;
    short          _a1_color;
    short          _a2_color;
    short          _a3_color;
#ifndef NO_GRADATION
    WSCuchar       _grad_margin;
    unsigned       _grad_no:4;
#endif
    unsigned  _anchor_top_use:1;
    unsigned  _anchor_bottom_use:1;
    unsigned  _anchor_left_use:1;
    unsigned  _anchor_right_use:1;

    unsigned       _shadow_thick:4;
    signed         _shadow_type:4;
    unsigned       _pixmap_style:2;
    unsigned       _no_refresh:1;
    unsigned       _update_resize:1;

    WSMFpropertyDef(WSNname,       char*,     _instance_name ); 
    WSMFpropertyDef(WSNuserString,       char*,     _user_string ); 
    WSMFpropertyDef(WSNuserValue,        long,      _user_value  ); 
    WSMFpropertyDef(WSNx,                short,     _x           );
    WSMFpropertyDef(WSNy,                short,     _y           );
    WSMFpropertyDef(WSNwidth,            WSCushort, _w           );
    WSMFpropertyDef(WSNheight,           WSCushort, _h           );
    WSMFpropertyDef(WSNshadowThickness,  WSCuchar,  _shadow_thick);
    WSMFpropertyDef(WSNforeColor,        short,     _fore_color  );
    WSMFpropertyDef(WSNbackColor,        short,     _back_color  );
    WSMFpropertyDef(WSNtopShadowColor,   short,     _ts_color    );
    WSMFpropertyDef(WSNbottomShadowColor,short,     _bs_color    );
    WSMFpropertyDef(WSNbackPixmap,       short,     _bp_color    );
    WSMFpropertyDef(WSNshadowType,       char,      _shadow_type );
    WSMFpropertyDef(WSNvis,              WSCbool,   _vis         );
    WSMFpropertyDef(WSNdet,              WSCbool,   _sensitive_work );
    WSMFpropertyDef(WSNpixmapStyle,      WSCuchar,  _pixmap_style);
    WSMFpropertyDef(WSNmouse,   WSCushort,  _mouse_no    );
#ifndef NO_GRADATION
    WSMFpropertyDef(WSNgradation,   WSCuchar,  _grad_no    );
    WSMFpropertyDef(WSNgradationMargin,   WSCuchar,  _grad_margin    );
#endif
    WSMFpropertyDef(WSNanchorTop,     WSCushort,      _anchor_top  );
    WSMFpropertyDef(WSNanchorBottom,  WSCushort,      _anchor_bottom  );
    WSMFpropertyDef(WSNanchorLeft,    WSCushort,      _anchor_left  );
    WSMFpropertyDef(WSNanchorRight,   WSCushort,      _anchor_right  );
    WSMFpropertyDef(WSNanchorTopFlag,     WSCbool,      _anchor_top_use  );
    WSMFpropertyDef(WSNanchorBottomFlag,  WSCbool,      _anchor_bottom_use  );
    WSMFpropertyDef(WSNanchorLeftFlag,    WSCbool,      _anchor_left_use  );
    WSMFpropertyDef(WSNanchorRightFlag,   WSCbool,      _anchor_right_use  );
#ifndef NO_REMOTE_INSTANCE
    WSMFpropertyDef(WSNexport,   WSCbool,      _export_  );
#endif
    WSMFpropertyDef(WSNkeepPixmapCache,   WSCbool,      _keep_pixmap_cache  );

    WSDLEX32 virtual long  _device_initialize();
    WSDLEX32 virtual void  _exec_child_adjust_for_anchors();
static void      (*_ext_draw_proc)(void*);
static char* _policy_name;

  public:
    WSDLEX32 WSCform(WSCbase*,char*);
    WSDLEX32 virtual ~WSCform();

    WSDLEX32 virtual void onResize(WSCrect*);
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onParentVisibleChange(WSCbool);
    WSDLEX32 virtual void onGuiPolicyChange(long);

    WSDLEX32 virtual void _adjust_for_anchors(WSCushort,WSCushort);

    WSDLEX32 virtual long execEventProc(long ev,void*);

    WSDLEX32 virtual long draw();
    WSDLEX32 virtual long clear();
    WSDLEX32 virtual long redraw();
    WSDLEX32 virtual long cdraw();
//    virtual long execEventProc(long ev, void*);
//    virtual long drawGriphand();
    WSDLEX32 virtual void update();
    WSDLEX32 virtual long getObjectType();
    WSDLEX32 virtual WSClistData& getChildren();
    WSDLEX32 virtual WSClistData* getChildrenPtr();
    WSDLEX32 virtual void setChildren(WSClistData&);
    WSDLEX32 virtual void internalUpdate();
#ifndef NO_RESTACK_CHILD
    WSDLEX32 virtual long restackChild(WSCbase*,int order);
#endif

    WSDLEX32 void execResizeEvent();
    WSDLEX32 void setNoRefresh(WSCbool);
    WSDLEX32 WSCbool getNoRefresh();
    WSDLEX32 long getPixmapStyle();

    WSMFguiClassDef(WSCform,WSCbase);
    WSMFsetUseDevice(formDev);
    WSMFversionDef(WSCform);
};
struct WSCform_draw_struct{
  WSCform* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  short fore_color;
  short back_color;
  short top_shadow_color;
  short bottom_shadow_color;
  short back_pixmap;
  long shadow_type;
#ifndef NO_GRADATION
  short gradation;
  short gradation_margin;
#endif
};


#endif
