//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCINDEXDATA_H
#define WSCINDEXDATA_H

#include <WScom.h>
#include <WSClistData.h>

class WSCindexData{
  protected:
    WSClistData _data;
//    WSClistData _index;
    WSCbool     _no_alloc_index;
  public:
    WSDLEX32 WSCindexData();
    WSDLEX32 WSCindexData(WSCindexData&);
    WSDLEX32 WSCindexData(const WSCindexData&);
    WSDLEX32 virtual ~WSCindexData();

    WSDLEX32 long   setData(char*,void*);
    WSDLEX32 void   setNoAllocIndex(WSCbool);

    WSDLEX32 char*  getIndex(long pos);
    WSDLEX32 void*  getData(char*);
    WSDLEX32 void*  getData(long pos);
    WSDLEX32 long   getNum();

    WSDLEX32 long   del(char* index);
    WSDLEX32 long   delPos(long i);      
    WSDLEX32 void   clear();
    WSDLEX32 WSCindexData& operator = (WSCindexData&);
    WSDLEX32 void*  &operator[](char* index);
    WSDLEX32 WSClistData* getList();
};
#endif
