//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCINDEXFORM_H
#define WSCINDEXFORM_H

#include <WScom.h>
#include <WSCform.h>

#define WSCindexForm_VER  1000
class WSCindexForm :public WSCform{

  protected:
     WSClistData _btns;
     WSCform*    _tab_form;
     char*       _menu_string;
     char*       _sc_str;
     WSCushort   _bar_thick;
     WSCuchar    _value;
     unsigned    _orientation:1;
     unsigned    _need_adjust:1;
     unsigned    _flipped:1;
     unsigned    _use_icon:1;

     WSMFpropertyDef( WSNbarThickness, WSCushort, _bar_thick   );
     WSMFpropertyDef( WSNorientation,  WSCuchar,  _orientation );
     WSMFpropertyDef( WSNmenuItems,    char*,     _menu_string );
     WSMFpropertyDef( WSNvalue,    WSCuchar,     _value );
     WSMFpropertyDef( WSNflip,    WSCbool,     _flipped );
     WSMFpropertyDef( WSNuseIcon,     WSCbool, _use_icon  );
     WSMFpropertyDef( WSNshortcut,     char*, _sc_str  );

     WSDLEX32 virtual void setWorkWSNbackColor(short);
     WSDLEX32 virtual void setWorkWSNforeColor(short);
     WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
     WSDLEX32 virtual void setWorkWSNheight(WSCushort);
     WSDLEX32 virtual void setWorkWSNshadowType(char);
     WSDLEX32 virtual void setWorkWSNshadowThickness(WSCuchar);

     WSDLEX32 void  _value_adjust();
     WSDLEX32 void  _adjust();
     WSDLEX32 void  _vis_adjust();
     WSDLEX32 static void _index_op(WSCbase*);
static void      (*_ext_draw_proc)(void*);
static char* _policy_name;

  public:
    WSDLEX32 WSCindexForm(WSCbase*,char*);
    WSDLEX32 virtual ~WSCindexForm();
    WSDLEX32 virtual void onGuiPolicyChange(long);

    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual long redraw();
    WSDLEX32 virtual long clear();
    WSDLEX32 virtual long cdraw();

    //internal function
    WSDLEX32 void set_btn_background(short no);
    WSDLEX32 WSCbase* get_target_btn();

    WSMFguiClassDef(WSCindexForm,WSCform);
    WSMFversionDef(WSCindexForm);
};
struct WSCindexForm_draw_struct{
  WSCindexForm* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  short fore_color;
  short back_color;
  short top_shadow_color;
  short bottom_shadow_color;
  short back_pixmap;
  long shadow_type;
#ifndef NO_GRADATION
  short gradation;
  short gradation_margin;
#endif
  WSCushort bar_thickness;
  WSCuchar orientation;
  WSCbool flipped;
  char* menu_string;
  WSCulong value;
};



#endif
