//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCLOCALESET_H
#define WSCLOCALESET_H

#include <WScom.h>
#include <WSDimage.h>
#include <WSClistData.h>
#include <WSCindexData.h>

class WSDcodeConvert{
  protected:
    char _locale_name[32];
  public:
    WSDLEX32 WSDcodeConvert();
    WSDLEX32 virtual ~WSDcodeConvert();
    WSDLEX32 virtual int codeConvert(char*,int,int,const char*,int,int)=0;
    WSDLEX32 virtual int getSystemEncoding()=0;
    WSDLEX32 virtual void initialize()=0;
    WSDLEX32 char*   getSystemLocaleName();
    WSDLEX32 void    setSystemLocaleName(char*,long encoding);
    WSDLEX32 virtual int utf8CharLen(const char*,int)=0;
    WSDLEX32 virtual int encode(WSCushort*,int,const char*,int,int)=0;
    WSDLEX32 virtual int decode(char* dest,int,const WSCushort*,int,int)=0;
    WSDLEX32 static void _set_code_convert_handler(WSDcodeConvert*(*)());
};
extern WSDLEX WSDcodeConvert*  WSGIappCodeConvert();

class WSClocale{
 protected:
  WSCindexData* _hash[WS_MAX_HASH_VALUE];
  WSCindexData* _hash_string[WS_MAX_HASH_VALUE];
//  WSCstring _name;
 public:
  char* _name;
  long _locale;
  WSDLEX32 WSClocale();
  WSDLEX32 virtual ~WSClocale();

  WSDLEX32 void setLocaleName(char*);
  WSDLEX32 char* getLocaleName();

  WSDLEX32 void setString(char* index,char* str);
  WSDLEX32 char* getString(char* index,long encode = WS_EN_DEFAULT);
};

class WSClocaleSet{

 protected:
   WSClistData _locale_list;
   WSClocale*  _default_locale;
   long _init;
   long _encoding;
//   WSClistData _init_procs;
//   long _executed;
 public:
   WSDLEX32 WSClocaleSet();
   WSDLEX32 virtual ~WSClocaleSet();
   WSDLEX32 void  setLocaleString(char* locale,char* index,char* str);
   WSDLEX32 char* getLocaleString(char* locale,char* index,long encode = WS_EN_DEFAULT);

   WSDLEX32 void initialize();
   WSDLEX32 WSClocale* getLocale(char*);
   WSDLEX32 WSClocale* getDefaultLocale();
   WSDLEX32 long setDefaultLocale(char* );
   WSDLEX32 char* getDefaultLocaleName();
   WSDLEX32 long getDefaultEncoding();
   WSDLEX32 void setDefaultEncoding(long int);
   WSDLEX32 long getSystemLocaleEncoding();
   WSDLEX32 char* getSystemLocaleName();
//   void addInitializeProc(void(*)());
//   void execInitializeProcs();
};
extern WSDLEX WSClocaleSet*  WSGIappLocaleSet();
extern WSDLEX void WSGFsetDefaultEncoding(long);
extern WSDLEX long WSGFgetDefaultEncoding();
extern WSDLEX void WSGFsetSystemDefaultEncoding(long);
extern WSDLEX long WSGFgetSystemDefaultEncoding();
#endif
