//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCNWBASE_H
#define WSCNWBASE_H

#include <WScom.h>
#include <WSCbase.h>

#define WSCnwbase_VER  1000
class WSCnwbase :public WSCbase{

  private:
  protected:
    char*     _user_string;
    long      _user_value;
    short     _x;
    short     _y;
    short     _fore_color;
    short     _blink_color;
    WSCushort _w;
    WSCushort _h;

#ifndef NO_NWBASE_MOUSE_PROPERTY
    unsigned short _mouse_no;
#endif
    unsigned short _anchor_top;
    unsigned short _anchor_bottom;
    unsigned short _anchor_left;
    unsigned short _anchor_right;
    unsigned  _anchor_top_use:1;
    unsigned  _anchor_bottom_use:1;
    unsigned  _anchor_left_use:1;
    unsigned  _anchor_right_use:1;
    unsigned  _blink_rate:4;
    unsigned  _bl_refreshing:1;
    unsigned  _bl_fl:1;
    unsigned  _tw_fl:1;
	unsigned  _blinking:1;
    unsigned  _mouse_enter:1;
    unsigned  _out_side_mouse_press:1;
    unsigned  _out_side_mouse_release:1;
    unsigned  _out_side_mouse_move:1;
    unsigned  _mouse_grabed:1;
    unsigned  _anchor_under_refreshing:1;

    WSMFpropertyDef(WSNname,      char*,      _instance_name);
    WSMFpropertyDef(WSNuserString,      char*,          _user_string);
    WSMFpropertyDef(WSNuserValue,       long,           _user_value );
    WSMFpropertyDef(WSNblinkRefreshing, WSCbool,        _bl_refreshing );
    WSMFpropertyDef(WSNvis,             WSCbool,        _vis    );
    WSMFpropertyDef(WSNdet,             WSCbool,        _sensitive_work );
    WSMFpropertyDef(WSNx,          short,          _x        );
    WSMFpropertyDef(WSNy,          short,          _y        );
    WSMFpropertyDef(WSNwidth,      WSCushort, _w        );
    WSMFpropertyDef(WSNheight,     WSCushort, _h        );
    WSMFpropertyDef(WSNforeColor,  short,          _fore_color);
    WSMFpropertyDef(WSNblinkFlag,  WSCbool,        _bl_fl    );
    WSMFpropertyDef(WSNtwinBlink,  WSCbool,        _tw_fl    );
    WSMFpropertyDef(WSNblinkColor, short,          _blink_color);
    WSMFpropertyDef(WSNblinkRate,  WSCuchar,       _blink_rate  );
    WSMFpropertyDef(WSNanchorTop,     WSCushort,      _anchor_top  );
    WSMFpropertyDef(WSNanchorBottom,  WSCushort,      _anchor_bottom  );
    WSMFpropertyDef(WSNanchorLeft,    WSCushort,      _anchor_left  );
    WSMFpropertyDef(WSNanchorRight,   WSCushort,      _anchor_right  );
    WSMFpropertyDef(WSNanchorTopFlag,     WSCbool,      _anchor_top_use  );
    WSMFpropertyDef(WSNanchorBottomFlag,  WSCbool,      _anchor_bottom_use  );
    WSMFpropertyDef(WSNanchorLeftFlag,    WSCbool,      _anchor_left_use  );
    WSMFpropertyDef(WSNanchorRightFlag,   WSCbool,      _anchor_right_use  );
#ifndef NO_REMOTE_INSTANCE
    WSMFpropertyDef(WSNexport,   WSCbool,      _export_  );
#endif

#ifndef NO_NWBASE_MOUSE_PROPERTY
    WSMFpropertyDef(WSNmouse,   WSCushort,          _mouse_no);
    WSCbase* _get_child_with_point(WSCpoint*,WSCbool);
#endif
    WSDLEX32 virtual long _device_initialize();
  public:
    WSDLEX32 WSCnwbase(WSCbase*,char*);
    WSDLEX32 virtual ~WSCnwbase();

    WSDLEX32 virtual void onChildAdded(WSCbase* );
#ifndef NO_NWBASE_MOUSE_PROPERTY
    WSDLEX32 virtual void onMouseIn(WSCpoint*);
    WSDLEX32 virtual void onMouseOut();
#endif

    WSDLEX32 virtual long clear();
    WSDLEX32 virtual long redraw();
    WSDLEX32 virtual long cdraw();
    WSDLEX32 virtual long execEventProc(long ev,void*);
    WSDLEX32 virtual long addProcedure(WSCprocedure*);
    WSDLEX32 virtual void setScaleOffsetPtr(double*);
    WSDLEX32 virtual void setXOffsetPtr(short*);
    WSDLEX32 virtual void setYOffsetPtr(short*);
    WSDLEX32 virtual void update();
    WSDLEX32 virtual void _adjust_for_anchors(WSCushort,WSCushort);

//    long clearArea();
//    long getGeometry(short*,short*,WSCushort*,WSCushort*);
//    long setGeometry(short,short,WSCushort,WSCushort);

    WSDLEX32 long    getBlinkRate();
//	void    setBlinkFore(WSCbool);
    WSDLEX32 WSCbool getBlinkRefresh();

    WSDLEX32 void  setOutSideMousePress(WSCbool);
    WSDLEX32 void  setOutSideMouseMove(WSCbool);
    WSDLEX32 void  setOutSideMouseRelease(WSCbool);
    WSDLEX32 void  setMouseGrabed(WSCbool);
    WSDLEX32 WSCbool getOutSideMouseMove();
    WSDLEX32 WSCbool getOutSideMouseRelease();
    WSDLEX32 WSCbool getOutSideMousePress();
    WSDLEX32 WSCbool getMouseGrabed();

    WSMFguiClassDef(WSCnwbase,WSCbase);
	WSMFsetUseDevice(nwDev);
    WSMFversionDef(WSCnwbase);
};
#endif
