//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCPULLDOWNMENUPOPUP_H
#define WSCPULLDOWNMENUPOPUP_H

#include <WScom.h>
#include <WSCwindow.h>
#include <WSCstring.h>
#include <WSDkeyboard.h>

class WSCpulldownMenuPopup    :public WSCwindow{

  protected:
    WSCpulldownMenuPopup* _popup;
    WSCpulldownMenuPopup* _parent_pld_menu;
    void*            _pld_data;
    char*            _menu_string;
    char*            _separator;
    char*            _separator2;
    WSCstring        _prc_name;
    long             _id_value;
    WSClistData      _child_pld_list;
    WSCushort        _item_height;
    signed char             _selected_item;
    char             _items;
    unsigned         _font:4;
    unsigned         _selected:1;
    unsigned         _next_popup:1;
    unsigned         _emboss:1;
    unsigned         _mouse_no_check:1;
    unsigned         _wait_child_popup:1;
    unsigned         _child_popup_waited:1;
//--- [20041015]
    unsigned         _use_pixmap:1;
//---

    //menu string = string:prcname:short cut key:value,
    //              string:prcname:short cur key:value,
    //              string:{
    //                string:prcname:short cur key:value,
    //                string:prcname:short cur key:value
    //              },
    //              string:prcname:short cur key:value,

    WSMFpropertyDef( WSNfont,           WSCuchar,  _font       );
    WSMFpropertyDef( WSNmenuItems,      char*,     _menu_string); 
    WSMFpropertyDef( WSNmenuItemHeight, WSCushort, _item_height); 
    WSMFpropertyDef( WSNseparator,      char*,     _separator); 
    WSMFpropertyDef( WSNseparator2,      char*,     _separator2); 

    WSDLEX32 virtual void setWorkWSNwidth(WSCushort);
    WSDLEX32 virtual void setWorkWSNheight(WSCushort);
    WSDLEX32 virtual void setWorkWSNemboss(WSCbool);

    WSDLEX32 virtual long _device_initialize();

    WSDLEX32 WSCpulldownMenuPopup* _check_child_status_no_mouse();
WSDLEX32 static void      (*_ext_draw_proc)(void*);
WSDLEX32 static char* _policy_name;

  public:
    WSDLEX32 WSCpulldownMenuPopup(WSCbase*,char*);
    WSDLEX32 virtual ~WSCpulldownMenuPopup();

    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onResize(WSCrect*);
    WSDLEX32 virtual void onKeyPress(WSDkeyboard*,WSCbool);
    WSDLEX32 virtual void onGuiPolicyChange(long);

    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long draw();

    WSDLEX32 void setEmboss(WSCbool);
    WSDLEX32 long setItemSensitive(short no,WSCbool flag);    
    WSDLEX32 long setValueSensitive(short id,WSCbool flag);    
    WSDLEX32 void setParentMenu(WSCpulldownMenuPopup*);
    WSDLEX32 long setValueToggleMenu(short no,WSCbool flag);    
    WSDLEX32 long setValueToggleState(short no,WSCbool flag);    
    WSDLEX32 WSCbool getValueToggleMenu(short no);
    WSDLEX32 WSCbool getValueToggleState(short no);
    WSDLEX32 WSCbool isToggle();

    WSDLEX32 WSCpulldownMenuPopup* getParentMenu();
    WSDLEX32 WSCushort getItemHeight();
    WSDLEX32 WSCuchar  getFontNo();
    WSDLEX32 long      getItems();
    WSDLEX32 char*     getProcName();
    WSDLEX32 WSCbool   getSelected();
    WSDLEX32 WSCbool   getNextPopup();
    WSDLEX32 WSCbool   getEmboss();
    WSDLEX32 WSCbool*  getItemSensitive();
    WSDLEX32 long      getValue();
    WSDLEX32 WSCbool   getValueSensitive(short id);
    WSDLEX32 void   setSelected(WSCbool);

    //internal
    WSDLEX32 void set_items(long items);
    WSDLEX32 WSCstring& get_prc_name();
    WSDLEX32 void set_selected(WSCbool fl);
    WSDLEX32 void* get_pld_data();
    WSDLEX32 void* get_parent_pld_data();
    WSDLEX32 void set_child_popup_waited(WSCbool fl);
    WSDLEX32 void set_selected_item(long item);
    WSDLEX32 void set_id_value(long v);
    WSDLEX32 WSClistData& get_child_pld_list();
    WSDLEX32 void popupChildPld(short childno,char* menustr, short x, short y);
    WSDLEX32 void popdownChildPld(short childno);
    WSDLEX32 void updateChild();
    WSDLEX32 WSCbool checkChildStatus();
    //--- [20041015]
    WSDLEX32 WSCbool get_use_pixmap();
    WSDLEX32 void set_use_pixmap(WSCbool px);
    //---
    WSDLEX32 virtual long getObjectType();
    WSDLEX32 WSCstring _get_proc_name_by_sc(char*,int* val);

    WSMFguiClassDef(WSCpulldownMenuPopup,WSCwindow);
};

struct WSCpulldownData {
  WSCstring  _label;
  WSCstring  _op;
  WSCstring  _sc;
  WSCpulldownData*  _next;
  WSCpulldownData*  _cascade_data;
  short _id;
  WSCbool    _separator;
  WSCbool    _cascaded;
  WSCbool    _sensitive;
  WSCbool    _toggle;
  WSCbool    _toggle_state;
//-- [20041015]
  WSCstring _px;
//--
  WSDLEX32 WSCpulldownData();
  WSDLEX32 ~WSCpulldownData();
  WSDLEX32 WSCbool   getSensitive(long no);
  WSDLEX32 WSCbool   _get_sensitive(long no,void*);
  WSDLEX32 WSCbool   getSensitiveWithId(long id);
  WSDLEX32 WSCbool   _get_sensitive_with_id(long no,void*);
  WSDLEX32 WSCbool   getToggle(long no);
  WSDLEX32 WSCbool   _get_toggle(long no,void*);
  WSDLEX32 WSCbool   getToggleWithId(long id);
  WSDLEX32 WSCbool   _get_toggle_with_id(long no,void*);
  WSDLEX32 WSCbool   getToggleState(long no);
  WSDLEX32 WSCbool   _get_toggle_state(long no,void*);
  WSDLEX32 WSCbool   getToggleStateWithId(long id);
  WSDLEX32 WSCbool   _get_toggle_state_with_id(long no,void*);
  WSDLEX32 WSCpulldownData* getItem(long no);
  WSDLEX32 WSCpulldownData* getItemWithId(long no);
  WSDLEX32 long   setSensitive(long no,WSCbool fl );
  WSDLEX32 long   setSensitiveWithId(long id,WSCbool fl );
  WSDLEX32 long   setToggle(long no,WSCbool fl );
  WSDLEX32 long   setToggleWithId(long id,WSCbool fl );
  WSDLEX32 long   setToggleState(long no,WSCbool fl );
  WSDLEX32 long   setToggleStateWithId(long id,WSCbool fl );
  WSDLEX32 void   setCascaded(WSCbool fl,char* sep,char* sep2);
  WSDLEX32 void   add(WSCpulldownData* data);
  WSDLEX32 long   getItems();
  WSDLEX32 WSCbool isToggle();
  WSDLEX32 WSCbool _is_toggle(void*);

  WSDLEX32 static  WSCpulldownData* parse(char* menu_string,char* sep,char* sep2);
};

struct WSCpulldownMenuPopup_draw_struct{
  WSCpulldownMenuPopup* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  short fore_color;
  short back_color;
  short top_shadow_color;
  short bottom_shadow_color;
  short back_pixmap;
  long shadow_type;
#ifndef NO_GRADATION
  short gradation;
  short gradation_margin;
#endif
  char*            menu_string;
  char*            separator;
  char*            separator2;
  WSCushort        item_height;
  WSCstring        prc_name;
  long             id_value;
  signed char      selected_item;
  char             items;
  unsigned         font:4;
  unsigned         selected:1;
  unsigned         next_popup:1;
  unsigned         emboss:1;
  unsigned         mouse_no_check:1;
  unsigned         wait_child_popup:1;
  unsigned         child_popup_waited:1;
};

#endif
