//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCRADIOGROUP_H
#define WSCRADIOGROUP_H

#include <WScom.h>
#include <WSCform.h>
#include <WSCvradio.h>

#define WSCradioGroup_VER  1001

class WSCradioGroup   :public WSCform{

  protected:
    WSClistData _radio_list;
    char* _title_string;
    char* _menu_str;
    WSCulong _value;
    WSCushort _item_height;
    short     _indicator_color;
    short     _select_color;
    short     _indicator_pixmap;
    short     _select_pixmap;
    short     _label_pixmap;

     char*     _upname;
     char*     _dwname;
     char*     _lname;
     char*     _rname;
     char*     _rtname;
     char*     _tbname;
     char*     _btbname;
     char*     _sc_str;
 
    unsigned  _font:4;
    unsigned  _margin:3;
    unsigned  _unique:1;
    unsigned  _indicator_size:6;
    unsigned  _indicator_type:2;
    unsigned  _indicator_shadow_thick:4;
    unsigned  _indicator_on:1;
    unsigned  _orientation:1;
    unsigned  _enable_focus_move:1;
    unsigned  _return_key_focus:1;

    WSMFpropertyDef(WSNvalue,     WSCulong, _value );
    WSMFpropertyDef(WSNtitleString,   char*, _title_string );
    WSMFpropertyDef(WSNmenuItems,   char*, _menu_str );
    WSMFpropertyDef(WSNmenuItemHeight,   WSCushort, _item_height );
    WSMFpropertyDef(WSNfont,         WSCuchar,   _font         );
    WSMFpropertyDef(WSNmargin,  WSCuchar, _margin);
    WSMFpropertyDef(WSNindicatorOn,     WSCbool, _indicator_on   );
    WSMFpropertyDef(WSNindicatorType,   WSCuchar, _indicator_type   );
    WSMFpropertyDef(WSNindicatorSize,   WSCuchar, _indicator_size   );
    WSMFpropertyDef(WSNindicatorShadow, WSCuchar, _indicator_shadow_thick );
    WSMFpropertyDef(WSNindicatorColor,  short,  _indicator_color );
    WSMFpropertyDef(WSNindicatorPixmap, short,  _indicator_pixmap );
    WSMFpropertyDef(WSNselectColor,     short,  _select_color );
    WSMFpropertyDef(WSNselectPixmap,    short,  _select_pixmap );
    WSMFpropertyDef(WSNlabelPixmap,    short,  _label_pixmap );
    WSMFpropertyDef(WSNorientation,     WSCuchar, _orientation  );
    WSMFpropertyDef(WSNkeepPixmapCache,   WSCbool,  _keep_pixmap_cache    );

    WSMFpropertyDef(WSNenableFocusMove,  WSCbool, _enable_focus_move );
    WSMFpropertyDef(WSNupward,    char*,   _upname);
    WSMFpropertyDef(WSNdownward, char*,   _dwname);
    WSMFpropertyDef(WSNleftward,   char*,   _lname);
    WSMFpropertyDef(WSNrightward,  char*,   _rname);
    WSMFpropertyDef(WSNreturn,     char*,   _rtname);
    WSMFpropertyDef(WSNtab,     char*,   _tbname);
    WSMFpropertyDef(WSNbacktab,     char*,   _btbname);
    WSMFpropertyDef(WSNreturnKeyFocus,   WSCbool, _return_key_focus);
    WSMFpropertyDef(WSNshortcut,     char*,   _sc_str);


    WSDLEX32 virtual void setWorkWSNbackColor(short);
    WSDLEX32 virtual void  _adjust();
    WSDLEX32 static void _value_ch_handler(WSCbase*);

  public:
    WSDLEX32 WSCradioGroup(WSCbase*,char*);
    WSDLEX32 virtual ~WSCradioGroup();

    WSDLEX32 virtual void update();
    WSDLEX32 virtual long draw();

    WSDLEX32 virtual void onValueChange();
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual char* getDefaultProperty();
    WSDLEX32 virtual void onFocusChange(WSCbool);

    WSDLEX32 long setItemSensitive(short no, WSCbool flag);
    WSDLEX32 WSCbool getItemSensitive(short no);
    WSDLEX32 WSCvradio* getItem(short no);

    WSMFguiClassDef(WSCradioGroup,WSCform);
    WSMFversionDef(WSCradioGroup);
};
#endif
