//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCVARIANT_H
#define WSCVARIANT_H
#include <WScom.h>

class WSCvariant{

  protected:
    void* _data;
    char* _data2;
    char* _type_name;
    signed char _type;
    unsigned _no_allocated:1;
    unsigned _inited:1;

  public:
    WSDLEX32 WSCvariant();
    WSDLEX32 WSCvariant(char);
    WSDLEX32 WSCvariant(WSCuchar);
    WSDLEX32 WSCvariant(short);
    WSDLEX32 WSCvariant(WSCushort);
    WSDLEX32 WSCvariant(int);
    WSDLEX32 WSCvariant(WSCuint);
    WSDLEX32 WSCvariant(long);
    WSDLEX32 WSCvariant(WSCulong);
    WSDLEX32 WSCvariant(float);
    WSDLEX32 WSCvariant(double);
    WSDLEX32 WSCvariant(void*);
    WSDLEX32 WSCvariant(void*,char* tname=NULL);
    WSDLEX32 WSCvariant(const WSCvariant&);
    WSDLEX32 WSCvariant(char*);
    WSDLEX32 WSCvariant(const char*);
    WSDLEX32 WSCvariant(WSCbase*);
//    WSDLEX32 WSCvariant(WSCstring);

    WSDLEX32 virtual ~WSCvariant();

    WSDLEX32 char getChar() const;
    WSDLEX32 WSCuchar getUnsignedChar() const;
    WSDLEX32 short getShort() const;
    WSDLEX32 WSCushort getUnsignedShort() const;
    WSDLEX32 long getLong() const;
    WSDLEX32 WSCulong getUnsignedLong() const;
    WSDLEX32 int getInt() const;
    WSDLEX32 WSCuint getUnsignedInt() const;
    WSDLEX32 float getFloat() const;
    WSDLEX32 double getDouble() const;
    WSDLEX32 void* getVoidPtr() const;
    WSDLEX32 char* getCharPtr();
    WSDLEX32 char* getCharPtrConst() const;
    WSDLEX32 WSCbase* getInstancePtr() const;
    WSDLEX32 WSCbool getNoAllocated() const;
    WSDLEX32 void setNoAllocated(WSCbool);

    WSDLEX32 void setValue(char);
    WSDLEX32 void setValue(WSCuchar);
    WSDLEX32 void setValue(short);
    WSDLEX32 void setValue(WSCushort);
    WSDLEX32 void setValue(long);
    WSDLEX32 void setValue(WSCulong);
    WSDLEX32 void setValue(int);
    WSDLEX32 void setValue(WSCuint);
    WSDLEX32 void setValue(char*);
    WSDLEX32 void setValue(const char*);
    WSDLEX32 void setValue(void*,char* cname=NULL);
    WSDLEX32 void setValue(float);
    WSDLEX32 void setValue(double);
    WSDLEX32 void setValue(WSCbase*);

    WSDLEX32 long getType() const;
    WSDLEX32 char* getTypeName() const;
    WSDLEX32 void clear();

    WSDLEX32 WSCvariant& operator= (const WSCvariant&);
    WSDLEX32 WSCvariant& operator= (char);
    WSDLEX32 WSCvariant& operator= (WSCuchar);
    WSDLEX32 WSCvariant& operator= (short);
    WSDLEX32 WSCvariant& operator= (WSCushort);
    WSDLEX32 WSCvariant& operator= (long);
    WSDLEX32 WSCvariant& operator= (WSCulong);
    WSDLEX32 WSCvariant& operator= (int);
    WSDLEX32 WSCvariant& operator= (WSCuint);
    WSDLEX32 WSCvariant& operator= (void*);
    WSDLEX32 WSCvariant& operator= (char*);
    WSDLEX32 WSCvariant& operator= (const char*);
    WSDLEX32 WSCvariant& operator= (float);
    WSDLEX32 WSCvariant& operator= (double);
    WSDLEX32 WSCvariant& operator= (WSCbase*);
//    WSDLEX32 WSCvariant& operator= (WSCstring);

    WSDLEX32 operator char() const;
    WSDLEX32 operator WSCuchar() const;
    WSDLEX32 operator short() const;
    WSDLEX32 operator WSCushort() const;
    WSDLEX32 operator long() const;
    WSDLEX32 operator WSCulong() const;
    WSDLEX32 operator int() const;
    WSDLEX32 operator WSCuint() const;
    WSDLEX32 operator void*() const;
    WSDLEX32 operator char*();
    WSDLEX32 operator float() const;
    WSDLEX32 operator double() const;
    WSDLEX32 operator WSCbase*() const;
//    WSDLEX32 operator WSCstring();
};
#endif
