//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCVCLOCK_H
#define WSCVCLOCK_H

#include <WScom.h>
#include <WSCvlabel.h>

#define WSCvclock_VER  1010
class WSDkeyboard;

class WSCvclock  :public WSCvlabel{

  protected:
    long _clock_update_id;
    void (*_fmt_handler)(long*,char*,long);
    unsigned _hour:4;
    unsigned _date_fmt:4;
    unsigned _min:6;
    unsigned _week_fmt:2;
    unsigned _sec:6;
    unsigned _show_sec:1;
    unsigned _clock_fmt:4;

    WSMFpropertyDef( WSNdateFormat,   WSCuchar, _date_fmt );
    WSMFpropertyDef( WSNweekFormat,   WSCuchar, _week_fmt );
    WSMFpropertyDef( WSNclockFormat,  WSCuchar, _clock_fmt);
    WSMFpropertyDef( WSNsecondOn,     WSCbool,  _show_sec);

    WSDLEX32 static void _clock_handler(WSCuchar,void*);

  public:
    WSDLEX32 WSCvclock(WSCbase*,char*);
    WSDLEX32 virtual ~WSCvclock();
//    void setFormatHandler( void(*)(long*,char*,long len) );

    WSMFguiClassDef(WSCvclock,WSCvlabel);
    WSMFversionDef(WSCvclock);
};
#endif
