//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCVDB_H
#define WSCVDB_H

#include <WScom.h>
#include <WSCngbase.h>
#include <WSCdb.h>

#define WSCvdb_VER  1000

class WSCdbDatabase;
class WSCdbRecord;

class WSCvdb   :public WSCngbase{

  protected:
    WSCdbDatabase* _db;
    char*   _hostname;
    char*   _user;
    char*   _passwd;
    char*   _dbname;
    WSCushort _port; 
    WSCuchar  _type;

    WSMFpropertyDef(WSNhostname,    char*, _hostname);
    WSMFpropertyDef(WSNusername,    char*, _user);
    WSMFpropertyDef(WSNpassword,    char*, _passwd);
    WSMFpropertyDef(WSNdbname,    char*, _dbname);
    WSMFpropertyDef(WSNport,    WSCushort, _port);
    WSMFpropertyDef(WSNtype,    WSCuchar, _type);

  public:
    WSDLEX32 void _init();
    WSDLEX32 WSCdbDatabase* getDBDatabase();

    WSDLEX32 WSCvdb(WSCbase* base, char* name);
    WSDLEX32 virtual ~WSCvdb();

    WSDLEX32 long open(char* hostname,char* uid,char* passwd,char* dbname= NULL,char* port = NULL);
    WSDLEX32 long open();
    WSDLEX32 long close();
    WSDLEX32 WSCbool isOpen();
    WSDLEX32 long sqlExecute(const char*);
    WSDLEX32 long beginTran();
    WSDLEX32 long commitTran();
    WSDLEX32 long abortTran();

    WSDLEX32 void getErrorMsg(char* msg,long size);
    WSDLEX32 WSCstring getErrorMessage();

    WSMFguiClassDef(WSCvdb,WSCngbase);
    WSMFversionDef(WSCvdb);
};

#endif //WSCVDB_H
