//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCVERTFORM_H
#define WSCVERTFORM_H

#include <WScom.h>
#include <WSCform.h>

#define WSCvertForm_VER  1001

class WSCvertForm   :public WSCform{

  protected:
    WSCuchar  _margin;
    WSCushort _min;
    WSCuchar  _alignment;
    unsigned  _vertical:1;

    WSMFpropertyDef(WSNminimum,  WSCushort, _min);
    WSMFpropertyDef(WSNmargin,  WSCuchar, _margin);
    WSMFpropertyDef(WSNalignmentH,  WSCuchar, _alignment);

    WSDLEX32 virtual void  _adjust();
    WSDLEX32 virtual void  _exec_child_adjust_for_anchors();

  public:
    WSDLEX32 WSCvertForm(WSCbase*,char*);
    WSDLEX32 virtual ~WSCvertForm();

    WSDLEX32 virtual void update();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual void onResize(WSCrect*);

    WSMFguiClassDef(WSCvertForm,WSCform);
    WSMFversionDef(WSCvertForm);
};
#endif
