//
// Copyright (C) 1999-2006 WideStudio/MWT Project Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef WSCVODBC_H
#define WSCVODBC_H

#include <WScom.h>
#include <WSCngbase.h>

#define WSCvodbc_VER  1000

class WSCodbcDatabase;
class WSCodbcRecord;

class WSCvodbc   :public WSCngbase{

  protected:
    WSCodbcDatabase* _db;
    char*   _dsn;
    char*   _user;
    char*   _passwd;

    WSMFpropertyDef(WSNdsn,    char*, _dsn);
    WSMFpropertyDef(WSNusername,    char*, _user);
    WSMFpropertyDef(WSNpassword,    char*, _passwd);


  public:
    WSDLEX32 void _init();
    WSDLEX32 WSCodbcDatabase* getODBCDatabase();

    WSDLEX32 WSCvodbc(WSCbase* base, char* name);
    WSDLEX32 virtual ~WSCvodbc();

    WSDLEX32 long open(char* dsn,char* uid,char* passwd);
    WSDLEX32 long open();
    WSDLEX32 long close();
    WSDLEX32 WSCbool isOpen();
    WSDLEX32 long sqlExecute(const char*);
    WSDLEX32 long beginTran();
    WSDLEX32 long commitTran();
    WSDLEX32 long abortTran();

    WSDLEX32 void getErrorMsg(char* msg,long size);
    WSDLEX32 WSCstring getErrorMessage();

    WSMFguiClassDef(WSCvodbc,WSCngbase);
    WSMFversionDef(WSCvodbc);
};

#endif //WSCVODBC_H
